# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['modpoll']

package_data = \
{'': ['*']}

install_requires = \
['paho-mqtt>=1.5.1,<2.0.0',
 'pip>=21.2,<22.0',
 'prettytable>=2.2.0,<3.0.0',
 'pymodbus>=2.5.2,<3.0.0',
 'requests>=2.26.0,<3.0.0']

extras_require = \
{':python_version < "3.8"': ['importlib-metadata>=1.0,<2.0']}

entry_points = \
{'console_scripts': ['modpoll = modpoll:app']}

setup_kwargs = {
    'name': 'modpoll',
    'version': '0.3.10',
    'description': 'A Command Line Tool for Modbus',
    'long_description': '# modpoll - A Command Line Tool for Modbus\n\n[![pipeline status](https://gitlab.com/helloysd/modpoll/badges/master/pipeline.svg)](https://gitlab.com/helloysd/modpoll/-/commits/master)\n[![License](https://img.shields.io/pypi/l/modpoll)](https://gitlab.com/helloysd/modpoll/-/blob/master/LICENSE)\n[![Downloads](http://pepy.tech/badge/modpoll)](http://pepy.tech/project/modpoll)\n\n> Learn more about `modpoll` usage at [documentation](https://helloysd.gitlab.io/modpoll) site. \n\n\n\n## Motivation\n\nThe initial idea of creating this tool is to help myself debugging new devices during site survey. A site survey usually has limited time and space, working on-site also piles up some pressures. At that time, a portable swiss-knife toolkit is our best friend.\n\nThis program can be easily deployed to Raspberry Pi or similar embedded devices, continuously polling data from the connected modbus devices, user can choose to save data locally or publish to a MQTT broker for easy debugging, the MQTT broker can be setup on the same Raspberry Pi or on the cloud. Once data has been successfully published, user can subscribe to a specific MQTT topic to view the collected data via a smart phone. \n\n\n\n<p align="center">\n  <img src="docs/assets/modpoll-usage.png">\n</p>\n\n\n\nMoreover, you can also continuously run this program on any PC or server with Python 3 support. One common use case is to deploy `modpoll` onto a server and keep it running as a gateway, i.e. polling data from local Modbus devices and forward to a centralized cloud server. In that sense, `modpoll` helps to bridge between the traditional world of fieldbus network and the modern world of IoT edge/cloud infrustructure. \n\n> This program is designed to be a standalone tool, it works out-of-the-box. If you are looing for a modbus python library, please consider the following two great open source projects, [pymodbus](https://github.com/riptideio/pymodbus) or [minimalmodbus](https://github.com/pyhys/minimalmodbus)\n\n\n\n## Feature\n\n- Support Modbus RTU/TCP/UDP devices\n- Show polling data for local debugging, like a typical modpoll tool\n- Publish polling data to MQTT broker for remote debugging, especially on smart phone\n- Export polling data to local storage for further investigation\n- Provide docker solution for continuous data polling use case\n\n\n\n## Installation\n\nThis program is tested on python 3.6+, the package is available in the Python Package Index, user can easily install it using `pip`.\n\n```bash\npip install modpoll\n```\n\nUpgrade the tool via the following command,\n\n```bash\npip install -U modpoll\n```\n\n\n\n## Quickstart\n\nAs the name tells, *modpoll* is a tool for communicating with Modbus devices, so ideally it makes more sense if you have a real Modbus device on hand for the following test, but it is OK if you don\'t, we have deployed a virtual Modbus TCP device on cloud at `modsim.topmaker.net:502` for your quick testing purpose, the code is available at [modsim](https://github.com/gavinying/modsim), let\'s start expoloring *modpoll* tool with the virtual device *modsim*.\n\n\n\n### Poll modsim service\n\nUsing *modpoll* tool, you can poll the first 5 holding registers via the following command,\n\n```bash\nmodpoll --tcp modsim.topmaker.net --config https://raw.githubusercontent.com/gavinying/modpoll/master/examples/modsim.csv\n```\n\n\n<p align="center">\n  <img src="docs/assets/screenshot-modpoll.png">\n</p>\n\n\n\n### Poll local modsim\n\nIf you prefer a local test, you can launch your own device simulator by running `modsim` locally, \n\n```bash\ndocker run -p 5020:5020 helloysd/modsim\n```\n\n> Use `sudo` before the docker command if you want to use the standard port `502`.\n\nIt will create a virtual Modbus TCP device running at `localhost:5020`, and then you can poll it using `modpoll` tool, \n\n```bash\nmodpoll --tcp localhost --tcp-port 5020 --config https://raw.githubusercontent.com/gavinying/modpoll/master/examples/modsim.csv\n```\n\n\n\n### Publish data to MQTT broker\n\nThis is the most useful function of this new *modpoll* tool. `modpoll` provides a very simple way to publish collected data to MQTT broker, so user can view data from a smart phone via any free MQTT client app. \n\nThe following example uses a public MQTT broker `mqtt.eclipseprojects.io` for test purpose. You can also setup your own MQTT broker locally using [mosquitto](https://mosquitto.org/download/).\n\n```bash\nmodpoll --tcp modsim.topmaker.net --config https://raw.githubusercontent.com/gavinying/modpoll/master/examples/modsim.csv --mqtt-host mqtt.eclipseprojects.io\n```\n\nWith successful data polling and publishing, you can subscribe the topic `modpoll/modsim` on the same MQTT broker `mqtt.eclipseprojects.io` to view the collected data. \n\n> The MQTT topic uses `<mqtt_topic_prefix>/<deviceid>` pattern, <mqtt_topic_prefix> is provided by `--mqtt-topic-prefix` argument, the default value is `modpoll/`  and <deviceid> is provided by the Modbus configure file. \n\n\n\n<p align="center">\n  <img width="1280" height="720" src="docs/assets/screencast-modpoll-mqtt.gif">\n</p>\n\n\n\n## Run in docker\n\nA docker image has been provided for user to directly run the program without local installation, \n\n  ```bash\n  docker run helloysd/modpoll\n  ```\n\nIt shows the version of the program by default.\n\nSimilar to the above `modsim` test, we can poll the first 5 holding registers with `docker run`,\n\n  ```bash\n  docker run helloysd/modpoll --tcp modsim.topmaker.net --config https://raw.githubusercontent.com/gavinying/modpoll/master/examples/modsim.csv\n  ```\n\nIf you want to load a local configure file, you need to mount a local folder onto container volume, \nfor example, if the child folder `examples` contains the config file `modsim.csv`, we can use it via the following command, \n\n  ```bash\n  docker run -v $(pwd)/examples:/app/examples helloysd/modpoll --tcp modsim.topmaker.net --config /app/examples/modsim.csv\n  ```\n\n\n\n## Basic Usage\n\n- Connect to Modbus TCP device\n\n  ```bash\n  modpoll --tcp 192.168.1.10 --config examples/modsim.csv\n  ```\n\n- Connect to Modbus RTU device \n\n  ```bash\n  modpoll --rtu /dev/ttyUSB0 --rtu-baud 9600 --config examples/scpms6.csv\n  ```\n\n- Connect to Modbus TCP device and publish data to MQTT broker \n\n  ```bash\n  modpoll --tcp modsim.topmaker.net --tcp-port 5020 --config examples/modsim.csv --mqtt-host mqtt.eclipseprojects.io\n  ```\n\n- Connect to Modbus TCP device and export data to local csv file\n\n  ```bash\n  modpoll --tcp modsim.topmaker.net --tcp-port 5020 --config examples/modsim.csv --export data.csv\n  ```\n\n\n\n> *Please refer to the [documentation](https://helloysd.gitlab.io/modpoll) site for more details about the configuration and examples.*\n\n\n\n## Credits\n\nThe implementation of this project is heavily inspired by the following two projects:\n- https://github.com/owagner/modbus2mqtt (MIT license)\n- https://github.com/mbs38/spicierModbus2mqtt (MIT license)\n\nThanks to Max Brueggemann and Oliver Wagner for their great work. \n\n\n\n## License\n\nMIT © [helloysd](helloysd@foxmail.com)\n',
    'author': 'Ying Shaodong',
    'author_email': 'helloysd@foxmail.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://helloysd.gitlab.io/modpoll',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'extras_require': extras_require,
    'entry_points': entry_points,
    'python_requires': '>=3.6,<4.0',
}


setup(**setup_kwargs)
