"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.PostCss = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const json_1 = require("../json");
const tailwind_1 = require("./tailwind");
/**
 * Declares a PostCSS dependency with a default config file.
 */
class PostCss {
    constructor(project, options) {
        this.fileName = options?.fileName ?? "postcss.config.json";
        project.addDeps("postcss");
        const config = { plugins: {} };
        if (options?.tailwind ?? true) {
            config.plugins.tailwindcss = {};
            config.plugins.autoprefixer = {};
            this.tailwind = new tailwind_1.TailwindConfig(project, options?.tailwindOptions);
            project.addDeps("tailwindcss", "autoprefixer");
        }
        this.file = new json_1.JsonFile(project, this.fileName, {
            obj: config,
            marker: false,
        });
        project.npmignore?.exclude(`/${this.fileName}`);
    }
}
exports.PostCss = PostCss;
_a = JSII_RTTI_SYMBOL_1;
PostCss[_a] = { fqn: "projen.web.PostCss", version: "0.60.16" };
//# sourceMappingURL=data:application/json;base64,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