"use strict";
var _a, _b, _c;
Object.defineProperty(exports, "__esModule", { value: true });
exports.NextComponent = exports.NextJsTypeScriptProject = exports.NextJsProject = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const component_1 = require("../component");
const javascript_1 = require("../javascript");
const sample_file_1 = require("../sample-file");
const typescript_1 = require("../typescript");
const util_1 = require("../util");
const postcss_1 = require("./postcss");
/**
 * Next.js project without TypeScript.
 *
 * @pjid nextjs
 */
class NextJsProject extends javascript_1.NodeProject {
    constructor(options) {
        super({
            jest: false,
            minNodeVersion: "12.13.0",
            ...options,
        });
        this.srcdir = options.srcdir ?? "pages";
        this.assetsdir = options.assetsdir ?? "public";
        this.tailwind = options.tailwind ?? true;
        new NextComponent(this, { typescript: false, tailwind: this.tailwind });
        // generate sample code in `pages` and `public` if these directories are empty or non-existent.
        if (options.sampleCode ?? true) {
            new NextSampleCode(this, {
                fileExt: "js",
                srcdir: this.srcdir,
                assetsdir: this.assetsdir,
                tailwind: this.tailwind,
            });
        }
    }
}
exports.NextJsProject = NextJsProject;
_a = JSII_RTTI_SYMBOL_1;
NextJsProject[_a] = { fqn: "projen.web.NextJsProject", version: "0.60.16" };
/**
 * Next.js project with TypeScript.
 *
 * @pjid nextjs-ts
 */
class NextJsTypeScriptProject extends typescript_1.TypeScriptAppProject {
    constructor(options) {
        const defaultOptions = {
            srcdir: "pages",
            eslint: false,
            minNodeVersion: "12.13.0",
            jest: false,
            tsconfig: {
                include: ["**/*.ts", "**/*.tsx"],
                compilerOptions: {
                    // required by Next.js
                    esModuleInterop: true,
                    module: "CommonJS",
                    moduleResolution: javascript_1.TypeScriptModuleResolution.NODE,
                    isolatedModules: true,
                    resolveJsonModule: true,
                    jsx: javascript_1.TypeScriptJsxMode.PRESERVE,
                    // recommended by Next.js
                    allowJs: true,
                    skipLibCheck: true,
                    forceConsistentCasingInFileNames: true,
                    noEmit: true,
                    lib: ["dom", "dom.iterable", "esnext"],
                    strict: false,
                    target: "es5",
                    incremental: true,
                },
            },
        };
        // never generate default TypeScript sample code, since this class provides its own
        super(util_1.deepMerge([
            defaultOptions,
            options,
            { sampleCode: false },
        ]));
        this.srcdir = options.srcdir ?? "pages";
        this.assetsdir = options.assetsdir ?? "public";
        this.tailwind = options.tailwind ?? true;
        new NextComponent(this, { typescript: true, tailwind: this.tailwind });
        // 'next build' command fails if tsconfig.json is immutable
        if (this.tsconfig) {
            this.tsconfig.file.readonly = false;
        }
        // generate sample code in `pages` and `public` if these directories are empty or non-existent.
        if (options.sampleCode ?? true) {
            new NextSampleCode(this, {
                fileExt: "tsx",
                srcdir: this.srcdir,
                assetsdir: this.assetsdir,
                tailwind: this.tailwind,
            });
        }
    }
}
exports.NextJsTypeScriptProject = NextJsTypeScriptProject;
_b = JSII_RTTI_SYMBOL_1;
NextJsTypeScriptProject[_b] = { fqn: "projen.web.NextJsTypeScriptProject", version: "0.60.16" };
class NextComponent extends component_1.Component {
    constructor(project, options) {
        super(project);
        this.typescript = options.typescript ?? false;
        this.tailwind = options.tailwind ?? true;
        project.addDeps("next", "react", "react-dom");
        if (this.typescript) {
            project.addDevDeps("@types/react", "@types/react-dom");
        }
        if (this.tailwind) {
            new postcss_1.PostCss(project, { tailwind: true });
        }
        // NextJS CLI commands, see: https://nextjs.org/docs/api-reference/cli
        project.addTask("dev", {
            description: "Starts the Next.js application in development mode",
            exec: "next dev",
        });
        project.compileTask.exec("next build");
        project.addTask("export", {
            description: "Exports the application for production deployment",
            exec: "next export",
        });
        project.addTask("server", {
            description: "Starts the Next.js application in production mode",
            exec: "next start",
        });
        project.addTask("telemetry", {
            description: "Checks the status of Next.js telemetry collection",
            exec: "next telemetry",
        });
        project.npmignore?.exclude("# Next.js", "/.next/");
        project.gitignore.exclude("# Next.js", "/.next/");
    }
}
exports.NextComponent = NextComponent;
_c = JSII_RTTI_SYMBOL_1;
NextComponent[_c] = { fqn: "projen.web.NextComponent", version: "0.60.16" };
class NextSampleCode extends component_1.Component {
    constructor(project, options) {
        super(project);
        this.fileExt = options.fileExt ?? "js";
        this.srcdir = options.srcdir;
        this.assetsdir = options.assetsdir;
        this.tailwind = options.tailwind;
        const indexJs = [
            'import Head from "next/head"',
            "",
            "export default function Home() {",
            "  return (",
            '    <div className="container">',
            "      <Head>",
            "        <title>Create Next App</title>",
            "      </Head>",
            "",
            "      <main>",
            '        <h1 className="title">',
            '          Welcome to <a href="https://nextjs.org">Next.js!</a>',
            "        </h1>",
            "",
            '        <p className="description">',
            "          Get started by editing <code>pages/index.js</code>",
            "        </p>",
            "",
            '        <div className="grid">',
            '          <a href="https://nextjs.org/docs" className="card">',
            "            <h3>Documentation &rarr;</h3>",
            "            <p>Find in-depth information about Next.js features and API.</p>",
            "          </a>",
            "",
            '          <a href="https://nextjs.org/learn" className="card">',
            "            <h3>Learn &rarr;</h3>",
            "            <p>Learn about Next.js in an interactive course with quizzes!</p>",
            "          </a>",
            "",
            "          <a",
            '            href="https://github.com/vercel/next.js/tree/master/examples"',
            '            className="card"',
            "          >",
            "            <h3>Examples &rarr;</h3>",
            "            <p>Discover and deploy boilerplate example Next.js projects.</p>",
            "          </a>",
            "",
            "          <a",
            '            href="https://vercel.com/import?filter=next.js&utm_source=create-next-app&utm_medium=default-template&utm_campaign=create-next-app"',
            '            className="card"',
            "          >",
            "            <h3>Deploy &rarr;</h3>",
            "            <p>",
            "              Instantly deploy your Next.js site to a public URL with Vercel.",
            "            </p>",
            "          </a>",
            "        </div>",
            "      </main>",
            "",
            "      <footer>",
            "        <a",
            '          href="https://vercel.com?utm_source=create-next-app&utm_medium=default-template&utm_campaign=create-next-app"',
            '          target="_blank"',
            '          rel="noopener noreferrer"',
            "        >",
            "          Powered by Vercel",
            '          <img src="/vercel.svg" alt="Vercel Logo" className="logo" />',
            "        </a>",
            "      </footer>",
            "",
            "      <style jsx>{`",
            "        .container {",
            "          min-height: 100vh;",
            "          padding: 0 0.5rem;",
            "          display: flex;",
            "          flex-direction: column;",
            "          justify-content: center;",
            "          align-items: center;",
            "        }",
            "",
            "        main {",
            "          padding: 5rem 0;",
            "          flex: 1;",
            "          display: flex;",
            "          flex-direction: column;",
            "          justify-content: center;",
            "          align-items: center;",
            "        }",
            "",
            "        footer {",
            "          width: 100%;",
            "          height: 100px;",
            "          border-top: 1px solid #eaeaea;",
            "          display: flex;",
            "          justify-content: center;",
            "          align-items: center;",
            "        }",
            "",
            "        footer img {",
            "          margin-left: 0.5rem;",
            "        }",
            "",
            "        footer a {",
            "          display: flex;",
            "          justify-content: center;",
            "          align-items: center;",
            "        }",
            "",
            "        a {",
            "          color: inherit;",
            "          text-decoration: none;",
            "        }",
            "",
            "        .title a {",
            "          color: #0070f3;",
            "          text-decoration: none;",
            "        }",
            "",
            "        .title a:hover,",
            "        .title a:focus,",
            "        .title a:active {",
            "          text-decoration: underline;",
            "        }",
            "",
            "        .title {",
            "          margin: 0;",
            "          line-height: 1.15;",
            "          font-size: 4rem;",
            "        }",
            "",
            "        .title,",
            "        .description {",
            "          text-align: center;",
            "        }",
            "",
            "        .description {",
            "          line-height: 1.5;",
            "          font-size: 1.5rem;",
            "        }",
            "",
            "        code {",
            "          background: #fafafa;",
            "          border-radius: 5px;",
            "          padding: 0.75rem;",
            "          font-size: 1.1rem;",
            "          font-family: Menlo, Monaco, Lucida Console, Liberation Mono,",
            "            DejaVu Sans Mono, Bitstream Vera Sans Mono, Courier New, monospace;",
            "        }",
            "",
            "        .grid {",
            "          display: flex;",
            "          align-items: center;",
            "          justify-content: center;",
            "          flex-wrap: wrap;",
            "",
            "          max-width: 800px;",
            "          margin-top: 3rem;",
            "        }",
            "",
            "        .card {",
            "          margin: 1rem;",
            "          flex-basis: 45%;",
            "          padding: 1.5rem;",
            "          text-align: left;",
            "          color: inherit;",
            "          text-decoration: none;",
            "          border: 1px solid #eaeaea;",
            "          border-radius: 10px;",
            "          transition: color 0.15s ease, border-color 0.15s ease;",
            "        }",
            "",
            "        .card:hover,",
            "        .card:focus,",
            "        .card:active {",
            "          color: #0070f3;",
            "          border-color: #0070f3;",
            "        }",
            "",
            "        .card h3 {",
            "          margin: 0 0 1rem 0;",
            "          font-size: 1.5rem;",
            "        }",
            "",
            "        .card p {",
            "          margin: 0;",
            "          font-size: 1.25rem;",
            "          line-height: 1.5;",
            "        }",
            "",
            "        .logo {",
            "          height: 1em;",
            "        }",
            "",
            "        @media (max-width: 600px) {",
            "          .grid {",
            "            width: 100%;",
            "            flex-direction: column;",
            "          }",
            "        }",
            "      `}</style>",
            "",
            "      <style jsx global>{`",
            "        html,",
            "        body {",
            "          padding: 0;",
            "          margin: 0;",
            "          font-family: -apple-system, BlinkMacSystemFont, Segoe UI, Roboto,",
            "            Oxygen, Ubuntu, Cantarell, Fira Sans, Droid Sans, Helvetica Neue,",
            "            sans-serif;",
            "        }",
            "",
            "        * {",
            "          box-sizing: border-box;",
            "        }",
            "      `}</style>",
            "    </div>",
            "  )",
            "}",
            "",
        ];
        if (this.tailwind) {
            indexJs.unshift('import "tailwindcss/tailwind.css"');
        }
        const vercelSvg = [
            '<svg width="283" height="64" viewBox="0 0 283 64" fill="none" ',
            '    xmlns="http://www.w3.org/2000/svg">',
            '    <path d="M141.04 16c-11.04 0-19 7.2-19 18s8.96 18 20 18c6.67 0 12.55-2.64 16.19-7.09l-7.65-4.42c-2.02 2.21-5.09 3.5-8.54 3.5-4.79 0-8.86-2.5-10.37-6.5h28.02c.22-1.12.35-2.28.35-3.5 0-10.79-7.96-17.99-19-17.99zm-9.46 14.5c1.25-3.99 4.67-6.5 9.45-6.5 4.79 0 8.21 2.51 9.45 6.5h-18.9zM248.72 16c-11.04 0-19 7.2-19 18s8.96 18 20 18c6.67 0 12.55-2.64 16.19-7.09l-7.65-4.42c-2.02 2.21-5.09 3.5-8.54 3.5-4.79 0-8.86-2.5-10.37-6.5h28.02c.22-1.12.35-2.28.35-3.5 0-10.79-7.96-17.99-19-17.99zm-9.45 14.5c1.25-3.99 4.67-6.5 9.45-6.5 4.79 0 8.21 2.51 9.45 6.5h-18.9zM200.24 34c0 6 3.92 10 10 10 4.12 0 7.21-1.87 8.8-4.92l7.68 4.43c-3.18 5.3-9.14 8.49-16.48 8.49-11.05 0-19-7.2-19-18s7.96-18 19-18c7.34 0 13.29 3.19 16.48 8.49l-7.68 4.43c-1.59-3.05-4.68-4.92-8.8-4.92-6.07 0-10 4-10 10zm82.48-29v46h-9V5h9zM36.95 0L73.9 64H0L36.95 0zm92.38 5l-27.71 48L73.91 5H84.3l17.32 30 17.32-30h10.39zm58.91 12v9.69c-1-.29-2.06-.49-3.2-.49-5.81 0-10 4-10 10V51h-9V17h9v9.2c0-5.08 5.91-9.2 13.2-9.2z" fill="#000"/>',
            "</svg>",
        ];
        new sample_file_1.SampleDir(project, this.srcdir, {
            files: {
                ["index." + this.fileExt]: indexJs.join("\n"),
            },
        });
        new sample_file_1.SampleDir(project, this.assetsdir, {
            files: {
                "vercel.svg": vercelSvg.join("\n"),
            },
        });
        new sample_file_1.SampleFile(project, "next-env.d.ts", {
            contents: [
                '/// <reference types="next" />',
                '/// <reference types="next/types/global" />',
                '/// <reference types="next/image-types/global" />',
                "// NOTE: This file should not be edited",
                "// see https://nextjs.org/docs/basic-features/typescript for more information.",
                "",
            ].join("\n"),
        });
    }
}
//# sourceMappingURL=data:application/json;base64,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