"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Projenrc = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const fs_1 = require("fs");
const path_1 = require("path");
const component_1 = require("../component");
const render_options_1 = require("../javascript/render-options");
/**
 * Sets up a typescript project to use TypeScript for projenrc.
 */
class Projenrc extends component_1.Component {
    constructor(project, options = {}) {
        super(project);
        this.rcfile = options.filename ?? ".projenrc.ts";
        const projensrc = options.projenCodeDir ?? "projenrc";
        // tell eslint to take .projenrc.ts and *.ts files under `projen` into account as a dev-dependency
        project.tsconfigDev.addInclude(this.rcfile);
        project.eslint?.allowDevDeps(this.rcfile);
        project.eslint?.addIgnorePattern(`!${this.rcfile}`);
        project.tsconfigDev.addInclude(`${projensrc}/**/*.ts`);
        project.eslint?.allowDevDeps(`${projensrc}/**/*.ts`);
        project.eslint?.addIgnorePattern(`!${projensrc}/**/*.ts`);
        // this is the task projen executes when running `projen` without a
        // specific task (if this task is not defined, projen falls back to
        // running "node .projenrc.js").
        project.addDevDeps("ts-node");
        // we use "tsconfig.dev.json" here to allow projen source files to reside
        // anywhere in the project tree.
        project.defaultTask?.exec(`ts-node --project ${project.tsconfigDev.fileName} ${this.rcfile}`);
        this.generateProjenrc();
    }
    generateProjenrc() {
        const rcfile = path_1.resolve(this.project.outdir, this.rcfile);
        if (fs_1.existsSync(rcfile)) {
            return; // already exists
        }
        const bootstrap = this.project.initProject;
        if (!bootstrap) {
            return;
        }
        const parts = bootstrap.fqn.split(".");
        const moduleName = parts[0];
        const importName = parts[1];
        const className = parts.slice(1).join(".");
        const { renderedOptions, imports } = render_options_1.renderJavaScriptOptions({
            args: bootstrap.args,
            type: bootstrap.type,
            comments: bootstrap.comments,
        });
        imports.add(importName);
        const lines = new Array();
        lines.push(`import { ${[...imports].sort().join(", ")} } from "${moduleName}";`);
        lines.push();
        lines.push(`const project = new ${className}(${renderedOptions});`);
        lines.push();
        lines.push("project.synth();");
        fs_1.writeFileSync(rcfile, lines.join("\n"));
        this.project.logger.info(`Project definition file was created at ${rcfile}`);
    }
}
exports.Projenrc = Projenrc;
_a = JSII_RTTI_SYMBOL_1;
Projenrc[_a] = { fqn: "projen.typescript.Projenrc", version: "0.60.16" };
//# sourceMappingURL=data:application/json;base64,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