import { Component } from "../component";
import { Project } from "../project";
declare type Transform = {
    name: string;
    args: Record<string, any>;
};
declare type SmithyCommon = {
    imports?: string[];
    plugins?: PluginsType;
};
declare type PluginValue = {
    service?: string;
    [key: string]: any;
};
export declare type ProjectionValue = SmithyCommon & {
    abstract?: boolean;
    transforms?: Transform[];
};
export declare type ProjectionKey = string;
export declare type ProjectionsType = Record<ProjectionKey, ProjectionValue>;
export declare type PluginKey = string;
export declare type PluginsType = Record<PluginKey, PluginValue>;
/**
 * Options for `SmithyBuild`
 */
export interface SmithyBuildOptions extends SmithyCommon {
    /**
     * Defines the version of smithy-build.
     * @default "1.0"
     */
    readonly version?: string;
    /**
     * Specifies a location where smithy projections are written.
     * @default - no output directory
     */
    readonly outputDirectory?: string;
    /**
     * Map of projections name to projection configurations
     * https://awslabs.github.io/smithy/1.0/guides/building-models/build-config.html#projections
     * @default - no projections
     */
    readonly projections?: ProjectionsType;
    /**
     * If a plugin can't be found, Smithy will by default fail the build.
     * This setting can be set to true to allow the build to progress
     * even if a plugin can't be found on the classpath.
     *
     * @default - no ignoreMissingPlugins set in the smithy-build.json file
     */
    readonly ignoreMissingPlugins?: boolean;
}
/**
 * Smithy build configuration options
 */
export declare class SmithyBuild extends Component {
    /**
     * Defines the version of smithy-build.
     * @default "1.0"
     */
    readonly version: string;
    /**
     * Specifies a location where smithy projections are written.
     * @default - no output directory
     */
    readonly outputDirectory?: string;
    /**
     * List of imports relative to the location of smithy-build.json file.
     * @default no imports
     */
    private _imports?;
    /**
     * If a plugin can't be found, Smithy will by default fail the build.
     * This setting can be set to true to allow the build to progress
     * even if a plugin can't be found on the classpath.
     *
     * @default - no ignoreMissingPlugins set in the smithy-build.json file
     */
    readonly ignoreMissingPlugins?: boolean;
    /**
     * Map of projections name to projection configurations
     * https://awslabs.github.io/smithy/1.0/guides/building-models/build-config.html#projections
     * @default - no projections
     */
    private _projections?;
    /**
     * Map of plugin name to plugin configurations
     * https://awslabs.github.io/smithy/1.0/guides/building-models/build-config.html#plugins
     * @default - no plugins
     */
    private _plugins?;
    private readonly manifest;
    constructor(project: Project, options?: SmithyBuildOptions);
    /**
     * Get configured projections
     */
    get projections(): {
        [x: string]: ProjectionValue;
    } | undefined;
    /**
     * Get configured imports
     */
    get imports(): string[] | undefined;
    /**
     * Get configured plugins
     */
    get plugins(): {
        [x: string]: PluginValue;
    } | undefined;
    /**
     * Add a smithy build import
     */
    addImport(imp: string): void;
    /**
     * Add smithy build projections
     */
    addProjections(projections: ProjectionsType): void;
    /**
     * Add smithy build plugins
     */
    addPlugins(plugins: PluginsType): void;
}
export {};
