"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Projects = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const path = require("path");
const vm = require("vm");
const inventory_1 = require("./inventory");
const render_options_1 = require("./javascript/render-options");
const option_hints_1 = require("./option-hints");
/**
 * Programmatic API for projen.
 */
class Projects {
    constructor() { }
    /**
     * Creates a new project with defaults.
     *
     * This function creates the project type in-process (with in VM) and calls
     * `.synth()` on it (if `options.synth` is not `false`).
     *
     * At the moment, it also generates a `.projenrc.js` file with the same code
     * that was just executed. In the future, this will also be done by the project
     * type, so we can easily support multiple languages of projenrc.
     */
    static createProject(options) {
        createProject(options);
    }
}
exports.Projects = Projects;
_a = JSII_RTTI_SYMBOL_1;
Projects[_a] = { fqn: "projen.Projects", version: "0.60.16" };
function createProject(opts) {
    const projectType = inventory_1.resolveProjectType(opts.projectFqn);
    // Default project resolution location
    let mod = "./index";
    // External projects need to load the module from the modules directory
    if (projectType.moduleName !== "projen") {
        try {
            mod = path.dirname(require.resolve(path.join(projectType.moduleName, "package.json"), {
                paths: [process.cwd()],
            }));
        }
        catch (err) {
            throw new Error(`External project module '${projectType.moduleName}' could not be resolved.`);
        }
    }
    // "dir" is exposed as a top-level option to require users to specify a value for it
    opts.projectOptions.outdir = opts.dir;
    // pass the FQN of the project type to the project initializer so it can
    // generate the projenrc file.
    const { renderedOptions } = render_options_1.renderJavaScriptOptions({
        bootstrap: true,
        comments: opts.optionHints ?? option_hints_1.InitProjectOptionHints.FEATURED,
        type: projectType,
        args: opts.projectOptions,
        omitFromBootstrap: ["outdir"],
    });
    // generate a random variable name because jest tests appear to share
    // VM contexts, causing
    //
    // > SyntaxError: Identifier 'project' has already been declared
    //
    // errors if this isn't unique
    const varName = "project" + Math.random().toString(36).slice(2);
    const initProjectCode = `const ${varName} = new ${projectType.typename}(${renderedOptions});`;
    // eslint-disable-next-line @typescript-eslint/no-require-imports
    const module = require(mod);
    const ctx = vm.createContext(module);
    const synth = opts.synth ?? true;
    const postSynth = opts.post ?? true;
    process.env.PROJEN_DISABLE_POST = (!postSynth).toString();
    vm.runInContext([initProjectCode, synth ? `${varName}.synth();` : ""].join("\n"), ctx);
}
//# sourceMappingURL=data:application/json;base64,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