"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.License = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const fs = require("fs-extra");
const file_1 = require("./file");
class License extends file_1.FileBase {
    constructor(project, options) {
        super(project, "LICENSE", { marker: false });
        const spdx = options.spdx;
        const textFile = `${__dirname}/../license-text/${spdx}.txt`;
        if (!fs.existsSync(textFile)) {
            throw new Error(`unsupported license ${spdx}`);
        }
        const years = options.copyrightPeriod ?? new Date().getFullYear().toString();
        const owner = options.copyrightOwner;
        let text = fs.readFileSync(textFile, "utf-8");
        text = text.replace("$copyright_period", years);
        // if the license text includes $copyright_owner, then `copyrightOwner` is required.
        if (text.indexOf("$copyright_owner") !== -1) {
            if (!owner) {
                throw new Error(`The ${spdx} license requires "copyrightOwner" to be specified`);
            }
            text = text.replace("$copyright_owner", owner);
        }
        this.text = text;
    }
    synthesizeContent(_) {
        return this.text;
    }
}
exports.License = License;
_a = JSII_RTTI_SYMBOL_1;
License[_a] = { fqn: "projen.License", version: "0.60.16" };
//# sourceMappingURL=data:application/json;base64,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