# AUTOGENERATED FILE! PLEASE DON'T EDIT
import k1lib as _k1lib, base64 as _base64, io as _io
import matplotlib.pyplot as _plt, random as _random
from typing import Callable as _Callable, List as _List, Union as _Union
class PlotDecorator:
    def __init__(self, sliceablePlot:"SliceablePlot", name:str):
        self.sliceablePlot = sliceablePlot
        self.name = name; self.args, self.kwargs = None, None
    def __call__(self, *args, **kwargs):
        self.args = args; self.kwargs = kwargs; return self.sliceablePlot
    def run(self): getattr(_plt, self.name)(*self.args, **self.kwargs)
class SliceablePlot:
    def __init__(self, plotF:_Callable[[slice], None], slices:_Union[slice, _List[slice]]=slice(None), plotDecorators:_List[PlotDecorator]=[], docs=""):
        self.plotF = plotF
        self.slices = [slices] if isinstance(slices, slice) else slices
        self.docs = docs; self.plotDecorators = list(plotDecorators)
    @property
    def squeezedSlices(self):
        """If :attr:`slices` only has 1 element, then return that
element, else return the entire list."""
        return _k1lib.squeeze(self.slices)
    def __getattr__(self, attr):
        if attr.startswith("_"): raise AttributeError()
        # automatically assume the attribute is a plt.attr method
        dec = PlotDecorator(self, attr)
        self.plotDecorators.append(dec); return dec
    def __getitem__(self, idx):
        if type(idx) == slice:
            return SliceablePlot(self.plotF, [idx], self.plotDecorators, self.docs)
        if type(idx) == tuple and all([type(elem) == slice for elem in idx]):
            return SliceablePlot(self.plotF, idx, self.plotDecorators, self.docs)
        raise Exception(f"Don't understand {idx}")
    def __repr__(self):
        self.plotF(self.squeezedSlices)
        for ax in _plt.gcf().get_axes():
            _plt.sca(ax)
            for decorator in self.plotDecorators: decorator.run()
        _plt.show()
        return f"""Sliceable plot. Can...
- p[a:b]: to focus on a specific range of the plot
- p.yscale("log"): to perform operation as if you're using plt{self.docs}"""
def plotSegments(x:_List[float], y:_List[float], states:_List[int], colors:_List[str]=None):
    """Plots a line graph, with multiple segments with different colors.

:param x: list of x coordinate at each point
:param y: list of y coordinates at each point
:param states: list of color at each point
:param colors: string colors to display for each states"""
    if colors is None: colors = ["tab:blue", "tab:red", "tab:green", "tab:orange", "tab:purple", "tab:brown"][:len(x)]
    _x = []; _y = []; state = -1; count = -1 # stretchs, and bookkeeping nums
    lx = None; ly = None # last x and y from last stretch, for plot autocompletion
    while count + 1 < len(x):
        count += 1
        if state != states[count]:
            if len(_x) > 0 and state >= 0:
                if lx != None: _x = [lx] + _x; _y = [ly] + _y
                _plt.plot(_x, _y, colors[state]); lx = _x[-1]; ly = _y[-1]
            _x = [x[count]]; _y = [y[count]]; state = states[count]
        else: _x.append(x[count]); _y.append(y[count])
    if len(_x) > 0 and state >= 0:
        if lx != None: _x = [lx] + _x; _y = [ly] + _y
        _plt.plot(_x, _y, colors[state])
class Carousel:
    _idx:int = _random.randint(0, 1e6)
    def __init__(self):
        """Creates a new Carousel. You can then add images and whatnot.
Will even work even when you export the notebook as html. Example::

    import numpy as np, matplotlib.pyplot as plt
    c = Carousel()
    x = np.linspace(-2, 2); plt.plot(x, x ** 2); c.savePlt()
    x = np.linspace(-1, 3); plt.plot(x, x ** 2); c.savePlt()
    c # displays in notebook cell"""
        self.imgs:_List[str] = [] # all base64 imgs
        self.defaultFormat = "jpeg"
    def save(self, f:_Callable[[_io.BytesIO], None]):
        """Generic image save function.

:param f: lambda that provides a :class:`io.BytesIO` for you to write to
"""
        byteArr = _io.BytesIO(); f(byteArr); byteArr.seek(0)
        self.imgs.append(_base64.b64encode(byteArr.read()).decode())
    def savePlt(self):
        """Saves current plot from matplotlib"""
        self.save(lambda byteArr: _plt.savefig(byteArr, format=self.defaultFormat))
        _plt.clf()
    def savePIL(self, image):
        """Saves a PIL image"""
        self.save(lambda byteArr: image.save(byteArr, format=self.defaultFormat))
    def _repr_html_(self):
        imgs = [f"\"<img src='data:image/{self.defaultFormat};base64, {img}' />\"" for img in self.imgs]
        idx = Carousel._idx; Carousel._idx += 1
        pre = f"k1c_{idx}"
        html = f"""
<style>
    .{pre}_btn {{
        cursor: pointer;
        padding: 10px 15px;
        background: #9e9e9e;
        float: left;
        margin-right: 5px;
        color: #000;
        user-select: none
    }}
    .{pre}_btn:hover {{
        background: #4caf50;
        color: #fff;
    }}
</style>
<div>
    <div id="{pre}_prevBtn" class="{pre}_btn">Prev</div>
    <div id="{pre}_nextBtn" class="{pre}_btn">Next</div>
    <div style="clear:both"/>
    <div id="{pre}_status" style="padding: 10px"></div>
</div>
<div id="{pre}_imgContainer"></div>
<script>
    {pre}_imgs = [{','.join(imgs)}];
    {pre}_imgIdx = 0;
    function {pre}_display() {{
        document.querySelector("#{pre}_imgContainer").innerHTML = {pre}_imgs[{pre}_imgIdx];
        document.querySelector("#{pre}_status").innerHTML = "Image: " + ({pre}_imgIdx + 1) + "/" + {pre}_imgs.length;
    }};
    document.querySelector("#{pre}_prevBtn").onclick = () => {{
        {pre}_imgIdx -= 1;
        {pre}_imgIdx = Math.max({pre}_imgIdx, 0);
        {pre}_display();
    }};
    document.querySelector("#{pre}_nextBtn").onclick = () => {{
        {pre}_imgIdx += 1;
        {pre}_imgIdx = Math.min({pre}_imgIdx, {pre}_imgs.length - 1);
        {pre}_display();
    }};
    {pre}_display();
</script>
        """
        return html