# AUTOGENERATED FILE! PLEASE DON'T EDIT
"""This module is for color formats, units and whatnot"""
import k1lib
from typing import Dict
metricPrefixes = {-8:"y",-7:"z",-6:"a",-5:"f",-4:"p",-3:"n",-2:"u",-1:"m",0:"",1:"k",2:"M",3:"G",4:"T",5:"P",6:"E",7:"Z",8:"Y"}
#metricPrefixes = ["", "k", "M", "G", "T", "P", "E", "Z", "Y"]
sizes = {i: f"{p}B" for i, p in metricPrefixes.items() if i >= 0}; sizes[0] = "bytes"
def _formatScale(x, units:Dict[int, str]):
    for i, unit in units.items():
        if abs(x) < (upperBound := 1000 * 1000**i):
            return f"{round(1e3*x/upperBound, 2)} {unit}"
    return f"{round(1e3*x/upperBound, 2)} {unit}"
def size(_bytes=0): return _formatScale(_bytes, sizes)
computations = {i: f"{p}FLOPs" for i, p in metricPrefixes.items() if i >= 0}
def computation(flop=0): return _formatScale(flop, computations)
computationRates = {i: f"{p}FLOPS" for i, p in metricPrefixes.items() if i >= 0}
def computationRate(flops=0): return _formatScale(flops, computationRates)
times = {i:f"{p}s" for i, p in metricPrefixes.items() if i <= 0}
def time(seconds=0): return _formatScale(seconds, times)
def item(items=0): return _formatScale(items, {0: "", 1: "k", 2: "M", 3: "B", 4: "T"})
_esc = '\033['
_end = f'{_esc}0m'
def darkcyan(s:str):  return f"{_esc}36m{s}{_end}"
def red(s:str):       return f"{_esc}91m{s}{_end}"
def green(s:str):     return f"{_esc}92m{s}{_end}"
def yellow(s:str):    return f"{_esc}93m{s}{_end}"
def blue(s:str):      return f"{_esc}94m{s}{_end}"
def purple(s:str):    return f"{_esc}95m{s}{_end}"
def cyan(s:str):      return f"{_esc}96m{s}{_end}"
def bold(s:str):      return f"{_esc}1m{s}{_end}"
def grey(s:str):      return f"{_esc}38;2;150;150;150m{s}{_end}"
def darkgrey(s:str):  return f"{_esc}38;2;100;100;100m{s}{_end}"
def underline(s:str): return f"{_esc}4m{s}{_end}"
def identity(s:str):  return f"{s}"