# AUTOGENERATED FILE! PLEASE DON'T EDIT
import k1lib, time
from k1lib.callbacks import Callback, Callbacks
@k1lib.patch(Callback.cls)
class ProgressBar(Callback):
    """Displays the current progress, epoch and batch while running."""
    def startRun(self):
        self.startTime = time.time(); self.step = 0; self.progress = 0
    def startBatch(self):
        self.elapsedTime = time.time() - self.startTime
        self.step += 1
        self.progress = (self.batch / self.batches + self.epoch) / self.epochs
        if self.step % 10 == 0:
            a = str(round(100 * self.progress)).rjust(3)
            b = f"{self.epoch}/{self.epochs}".rjust(k1lib.numDigits(self.epochs) * 2 + 1)
            c = f"{self.batch}/{self.batches}".rjust(k1lib.numDigits(self.batches) * 2 + 1)
            d = f"{round(self.elapsedTime, 2)}".rjust(6)
            print(f"\rProgress: {a}%, epoch: {b}, batch: {c}, elapsed: {d}s  ", end="")
@k1lib.patch(Callbacks, docs=ProgressBar)
def withProgressBar(self): return self.append(ProgressBar())