# AUTOGENERATED FILE! PLEASE DON'T EDIT
from k1lib.callbacks import Callback, Callbacks
import k1lib, time, torch, math, logging, numpy as np, torch.nn as nn
from functools import partial
import matplotlib.pyplot as plt
__all__ = ["Profiler"]
import k1lib.callbacks.profilers as ps
ComputationProfiler = ps.computation.ComputationProfiler
IOProfiler = ps.io.IOProfiler
MemoryProfiler = ps.memory.MemoryProfiler
TimeProfiler = ps.time.TimeProfiler
@k1lib.patch(Callback.cls)
class Profiler(Callback):
    """Profiles memory, time, and computational complexity of the network"""
    def __init__(self):
        super().__init__();self._mpCache=None;self._tpCache=None
        self._cpCache=None;self._ioCache=None;self.dependsOn=["Recorder"]
    def _memory(self): # do this to quickly debug, cause if not, Callback will just raise AttributeError on .memory
        if self._mpCache != None: return self._mpCache
        self.cbs.append(mp := MemoryProfiler(), name="_profiler_MemoryProfiler")
        mp.run(); mp.detach(); self._mpCache = mp; return self.memory
    @property
    def memory(self) -> MemoryProfiler: return self._memory()
    def _computation(self):
        if self._cpCache != None: return self._cpCache
        self.cbs.append(cp := ComputationProfiler(self), name="_profiler_ComputationProfiler")
        cp.run(); cp.detach(); self._cpCache = cp; return self.computation
    @property
    def computation(self) -> ComputationProfiler: return self._computation()
    def _time(self):
        if self._tpCache != None: return self._tpCache
        self.cbs.append(tp := TimeProfiler(), name="_profiler_TimeProfiler")
        tp.run(); tp.detach(); self._tpCache = tp; return self.time
    @property
    def time(self) -> TimeProfiler: return self._time()
    def _io(self):
        if self._ioCache != None: return self._ioCache
        self.cbs.append(io := IOProfiler(), name="_profiler_IOProfiler")
        io.run(); io.detach(); self._ioCache = io; return self.io
    @property
    def io(self) -> IOProfiler: return self._io()
    def __repr__(self):
        return f"""{self._reprHead}, can...
- p.memory: to profile module memory requirements
- p.time: to profile module execution times
- p.computation: to estimate module computation
- p.io: to get input and output shapes of 
{self._reprCan}"""
@k1lib.patch(Callbacks, docs=Profiler)
def withProfiler(self): return self.append(Profiler())