# AUTOGENERATED FILE! PLEASE DON'T EDIT
from k1lib.callbacks import Callback, Callbacks
import k1lib, numpy as np
import matplotlib.pyplot as plt
from functools import partial
__all__ = ["ParamFinder"]
@k1lib.patch(Callback.cls)
class ParamFinder(Callback):
    """Automatically finds out the right value for
    a specific parameter"""
    def __init__(self):
        super().__init__(); self.order = 23
        self.activated = False; self.losses = []
    @property
    def samples(self): return self._samples
    @samples.setter
    def samples(self, samples):
        self._samples = samples
        self.potentialValues = 10**np.linspace(-6, 2, samples)
    @property
    def value(self):
        if self.idx >= len(self.potentialValues): raise k1lib.CancelRunException("Checked all possible param values")
        return self.potentialValues[self.idx]
    @property
    def lossAvgs(self): return sum(self.losses[-2:])/2
    def startBatch(self):
        if self.activated:
            self.idx += 1
            for paramGroup in self.opt.param_groups:
                paramGroup[self.param] = self.value
    @property
    def suggestedValue(self): return self.best/2
    def endLoss(self):
        if self.activated:
            self.losses.append(self.loss)
            lossAvgs = self.lossAvgs
            if lossAvgs < self.bestLoss:
                self.best = self.value
                self.bestLoss = lossAvgs
            if lossAvgs > self.bestLoss * 10: raise k1lib.CancelRunException("Loss increases significantly")
    def __repr__(self):
        return f"""{self._reprHead}, use...
- pf.run(): to start scanning for good params and automatically plots
- pf.plot(): to plot
- pf.samples = ...: to set how many param values to iterate through
{self._reprCan}"""
@k1lib.patch(ParamFinder)
def run(self, param:str="lr", samples:int=300):
    self.param = param; self.samples = samples
    self.idx = 0; self.losses = []; self.best = None; self.bestLoss = float("inf")
    self.activated = True; ogParams = self.model.exportParams()
    with self.learner.cbs.suspend(cbsClasses=["HookModule", "HookParam", "ParamScheduler", "Loss", "Autosave"]):
        self.learner.run(int(1e3))
        self.activated = False; self.model.importParams(ogParams)
    return self.plot()
def plotF(self, _slice):
    r = k1lib.Range(len(self.losses)).fromUnit(_slice)
    plt.plot(self.potentialValues[r.slice_], self.losses[r.slice_])
    plt.xscale("log"); plt.xlabel(self.param); plt.ylabel("Loss")
@k1lib.patch(ParamFinder)
def plot(self, *args, **kwargs):
    if len(self.losses) == 0: return self.run(*args, **kwargs)
    else:
        print(f"Suggested param: {self.suggestedValue}"); plt.figure(dpi=120)
        return k1lib.viz.SliceablePlot(partial(plotF, self), docs="\n\nReminder: slice range here is actually [0, 1], because it's kinda hard to slice the normal way")
@k1lib.patch(Callbacks, docs=ParamFinder)
def withParamFinder(self): return self.append(ParamFinder())