# AUTOGENERATED FILE! PLEASE DON'T EDIT
import k1lib, time, os, logging, numpy as np, matplotlib.pyplot as plt
from typing import Set, List, Union, Callable
from collections import OrderedDict
__all__ = ["Callback", "Callbacks"]
_orderDocs = """
- 7: pre-default runs, like LossLandscape
- 10: default runs, like DontTrainValid
- 13: custom mods, like ModifyBatch
- 15: pre-recording mod
- 17: recording mods, like Profiler.memory
- 20: default recordings, like Loss
- 23: post-default recordings, like ParamFinder
- 25: guards, like TimeLimit, CancelOnExplosion"""
class Callback:
    r"""Represents a callback. Define specific functions
inside to intercept certain parts of the training
loop. Can reference Learner's attrs directly
using `self` like this::

    self.opt # actually accessing Learner.opt, if `opt` is not defined

You can also set Learner's attributes like this::

    self.learner.xb = self.xb[None]

This takes x batch of learner, unsqueeze it at
the 0 position, then sets the x batch again.

Normally, you will define a subclass of this and
define specific intercept functions, but if you
want to create a throwaway callback, then do this::

    Callback().withCheckpoint("startRun", lambda: print("start running"))

You can use `.cls` for a list of default Callback
classes, for any particular needs.

You can also use `.order` to set the order of execution of the callback.
The higher, the later it gets executed. Value suggestions:

- 7: pre-default runs, like LossLandscape
- 10: default runs, like DontTrainValid
- 13: custom mods, like ModifyBatch
- 15: pre-recording mod
- 17: recording mods, like Profiler.memory
- 20: default recordings, like Loss
- 23: post-default recordings, like ParamFinder
- 25: guards, like TimeLimit, CancelOnExplosion"""
    def __init__(self):
        self.learner = None; self.cbs = None; self.suspended = False
        self.name = self.__class__.__name__; self.dependsOn:Set[str] = set()
        self.order = 10 # can be modified by subclasses. A smaller order will be executed first
    def suspend(self):
        """Called upon when the Callback is temporarily suspended. Overridable"""
        self.suspended = True
    def restore(self):
        """Called upon when the Callback is back from suspension. Overridable"""
        self.suspended = False
    def __getattr__(self, attr):
        if attr == "learner": raise AttributeError(attr)
        if hasattr(self.learner, attr):
            return getattr(self.learner, attr)
        raise AttributeError(attr)
    def __getstate__(self):
        state = dict(self.__dict__)
        del state["learner"]; del state["cbs"]; return state
    def __setstate__(self, state): self.__dict__.update(state)
    def __repr__(self): return f"{self._reprHead}, can...\n{self._reprCan}"
    @property
    def _reprHead(self): return f"Callback `{self.name}`"
    @property
    def _reprCan(self): return """- cb.something: to get specific attribute "something" from learner if not available
- cb.withCheckpoint(checkpoint, f): to quickly insert an event handler
- cb.detach(): to remove itself from its parent Callbacks"""
    def withCheckpoint(self, checkpoint:str, f:Callable[["Callback"], None]):
        """Quickly set a checkpoint, for simple, inline-able functions

:param checkpoint: checkpoints like "startRun"
:param f: function that takes in the Callback itself"""
        setattr(self, checkpoint, lambda: f(self)); return self
    def detach(self):
        """Detaches from the parent :class:`~k1lib.callbacks.callbacks.Callback`"""
        self.cbs.remove(self.name); return self
Callback.cls = k1lib.Object()
class Timings:
    @property
    def state(self):
        answer = dict(self.__dict__); answer.pop("getdoc", None); return answer
    @property
    def checkpoints(self):
        return [cp for cp in self.state if k1lib.isNumeric(self[cp])]
    def __getattr__(self, attr):
        if attr.startswith("_"): raise AttributeError()
        self.__dict__[attr] = 0; return 0
    def __getitem__(self, idx): return getattr(self, idx)
    def __setitem__(self, idx, value): setattr(self, idx, value)
    def plot(self):
        plt.figure(dpi=100); checkpoints = self.checkpoints
        timings = np.array([self[cp] for cp in checkpoints])
        maxTiming = timings.max()
        if maxTiming >= 1:
            plt.bar(checkpoints, timings); plt.ylabel("Time (s)")
        elif maxTiming >= 1e-3 and maxTiming < 1:
            plt.bar(checkpoints, timings*1e3); plt.ylabel("Time (ms)")
        elif maxTiming >= 1e-6 and maxTiming < 1e-3:
            plt.bar(checkpoints, timings*1e6); plt.ylabel("Time (us)")
        plt.xticks(rotation="vertical"); plt.show()
    def __repr__(self):
        cps = '\n'.join([f'- {cp}: {self[cp]}' for cp in self.checkpoints])
        return f"""Timings object. Checkpoints:\n{cps}\n
Can...
- t.startRun: to get specific checkpoint's execution time
- t.plot(): to plot all checkpoints"""
_defaultCbCall = lambda *a, **k: None
class Callbacks:
    def __init__(self):
        self._learner = None; self.cbsDict = {}; self.timings = Timings()
    @property
    def learner(self): return self._learner
    @learner.setter
    def learner(self, learner):
        self._learner = learner
        for cb in self.cbs: cb.learner = learner
    @property
    def cbs(self) -> List[Callback]: return [*self.cbsDict.values()] # convenience method for looping over stuff
    def _sort(self) -> "Callbacks":
        self.cbsDict = OrderedDict(sorted(self.cbsDict.items())); return self
    def append(self, cb:Callback, name:str=None):
        """Adds a callback to the collection."""
        cb.learner = self.learner; cb.cbs = self; name = name or cb.name
        if name in self.cbsDict:
            i = 0
            while f"{name}{i}" in self.cbsDict: i += 1
            name = f"{name}{i}"
        cb.name = name; self.cbsDict[name] = cb; self._sort()
        getattr(self, "_appendExtraProcessing", lambda cb: None)(cb)
        self._handleCbCall(cb, "appended"); return self
    def __contains__(self, e:str): return e in self.cbsDict
    def remove(self, name:str):
        """Removes a callback from the collection."""
        if name not in self.cbsDict: return print(f"Callback `{name}` not found")
        cb = self.cbsDict[name]; del self.cbsDict[name]
        self._handleCbCall(cb, "detached"); self._sort(); return self
    def removePrefix(self, prefix:str):
        """Removes any callback with the specified prefix"""
        for cb in self.cbs:
            if cb.name.startswith(prefix): self.remove(cb.name)
        return self
    def _handleCbCall(self, cb, checkpoint:str, *args, **kwargs):
        return getattr(cb, checkpoint, _defaultCbCall)(*args, **kwargs) != None
    def __call__(self, checkpoint:str, *args, **kwargs):
        beginTime = time.time()
        answer = any([self._handleCbCall(cb, checkpoint, *args, **kwargs) for cb in self.cbs])
        self.timings[checkpoint] += time.time() - beginTime
        return answer
    def __getitem__(self, idx:Union[int, str]): return self.cbs[idx] if isinstance(idx, int) else self.cbsDict[idx]
    def __iter__(self):
        for cb in self.cbsDict.values(): yield cb
    def __len__(self): return len(self.cbsDict)
    def __getattr__(self, attr):
        if attr == "cbsDict": raise AttributeError(attr)
        if attr in self.cbsDict: return self.cbsDict[attr]
        else: raise AttributeError(attr)
    def __getstate__(self):
        state = dict(self.__dict__); del state["_learner"]; return state
    def __setstate__(self, state):
        self.__dict__.update(state)
        for cb in self.cbs: cb.cbs = self
    def __repr__(self):
        return "Callbacks:\n" + '\n'.join([f"- {cbName}" for cbName in self.cbsDict]) + """\n
Use...
- cbs.append(cb[, name]): to add a callback with a name
- cbs("startRun"): to trigger a specific event
- cbs.Loss: to get a specific callback by name
- cbs[i]: to get specific callback by index
- cbs.timings: to get callback execution times
- `with cbs.suspend(["Loss", "Cuda"]): pass`: to temporarily prevent triggering events in
    specific callbacks. Can be nested
- cbs.restore(): to restore latest temporary suspension
- cbs.withs: to get list of with- functions. Corresponding classes are in k1lib.Callback.cls
"""
    def withBasics(self):
        """Adds a bunch of very basic Callbacks that's needed for everything. Also
includes Callbacks that are not necessary, but don't slow things down"""
        self.withProgressBar().withLoss().withDontTrainValid()
        self.withLossLandscape().withProfiler().withRecorder()
        return self.withCancelOnExplosion().withParamFinder()
    def withQOL(self):
        """Adds quality of life Callbacks. Right now it's just Autosave"""
        return self.withAutosave()
    def withAdvanced(self):
        """Adds advanced Callbacks that do fancy stuff, but may slow things
down if not configured specifically."""
        return self.withHookModule().withHookParam()
@k1lib.patch(Callbacks)
def _resolveDependencies(self):
    for cb in self.cbs:
        cb._dependents:Set[Callback] = set()
        cb.dependsOn = set(cb.dependsOn)
    for cb in self.cbs:
        for cb2 in self.cbs:
            if cb2.__class__.__name__ in cb.dependsOn:
                cb2._dependents.add(cb)
class SuspendContext:
    def __init__(self, cbs:Callbacks, cbsNames:List[str], cbsClasses:List[str]):
        self.cbs = cbs; self.cbsNames = cbsNames; self.cbsClasses = cbsClasses
        self.cbs.suspendStack = getattr(self.cbs, "suspendStack", [])
    def __enter__(self):
        cbsClasses = set(self.cbsClasses); cbsNames = set(self.cbsNames)
        self._resolveDependencies()
        def explore(cb:Callback):
            for dept in cb._dependents:
                cbsClasses.add(dept.__class__.__name__); explore(dept)
        [explore(cb) for cb in self.cbs if cb.__class__.__name__ in cbsClasses or cb.name in cbsNames]
        stackFrame = [cb for cb in self.cbs if cb.__class__.__name__ in cbsClasses or cb.name in cbsNames]
        for cb in stackFrame: cb.suspend(); cb.detach()
        self.suspendStack.append(stackFrame)
    def __exit__(self, *ignored):
        stackFrame = self.suspendStack.pop()
        self.cbs.poppingStackFrame = True
        for cb in stackFrame:
            self.append(cb); cb.restore()
        self.cbs.poppingStackFrame = False
    def __getattr__(self, attr): return getattr(self.cbs, attr)
@k1lib.patch(Callbacks)
def suspend(self, cbsNames:List[str]=[], cbsClasses:List[str]=[]):
    """Suspension context for specified Callbacks.

:param cbsNames: checks Callback' names against this list
:param cbsClasses: checks Callback' class names against this list

| As Callback's default name is the class name, just use **cbsNames**
    if you're hesitant"""
    return SuspendContext(self, cbsNames, cbsClasses)
@k1lib.patch(Callbacks)
def suspendEvaluation(self, cbsNames:List[str]=[], cbsClasses:List[str]=[]):
    """For typical suspend classes used for evaluation callbacks"""
    cbsClasses.extend(["HookModule", "HookParam", "ProgressBar", "ParamScheduler", "Loss", "Autosave"])
    return self.suspend(cbsNames, cbsClasses)
class AppendContext:
    def __init__(self, cbs:Callbacks): self.cbs = cbs
    def __enter__(self): self.cbs.contexts.append([])
    def __exit__(self, *ignored): [cb.detach() for cb in self.cbs.contexts.pop()]
@k1lib.patch(Callbacks)
def _appendExtraProcessing(self, cb):
    if "contexts" not in self.__dict__: self.contexts = [[]]
    if not getattr(self, "poppingStackFrame", False):
        self.contexts[-1].append(cb)
@k1lib.patch(Callbacks)
def context(self):
    """Creates a new add context manager. Every callbacks
added inside the context will be detached when
the context finishes"""
    return AppendContext(self)
withsLogger = logging.getLogger("Callbacks_withs")
@k1lib.patch(Callbacks, "withs")
@property
def withs(self):
    """Gets all with- functions nicely formatted, with `order`
and `short docs` fields"""
    withsLogger.debug("started")
    ws = [w for w in dir(Callbacks()) if w.startswith("with") and w != "withs"]
    ws.sort(); lname = 25; lorder = 6; ldocs = int(os.getenv('COLUMNS', 73)) - lname - lorder
    print("function name".ljust(lname) + "order".ljust(lorder) + "short docs")
    for w in ws:
        withsLogger.debug(f"Disassembling {w}")
        docs = ""; print(w.ljust(lname), end="")
        if w[4:] in Callback.cls:
            try:
                from inspect import signature
                cl = Callback.cls[w[4:]]; docs = docs or cl.__doc__
                params = [None] * (len(signature(cl.__init__).parameters) - 1)
                orderI = cl(*params).order; order = f"{orderI}".ljust(lorder)
                print((k1lib.format.grey if orderI == 10 else k1lib.format.identity)(order), end="")
            except Exception as e:
                withsLogger.debug(e)
                print(" "*lorder, end="")
        else: print(" "*lorder, end="")
        withsLogger.debug(f"before print docs: {getattr(self, w).__doc__}")
        print(k1lib.limitChars(docs or getattr(self, w).__doc__, ldocs))
        withsLogger.debug(f"Finished disassembling {w}")
    print(f"\nOrder value suggestions:{_orderDocs}")