# AUTOGENERATED FILE! PLEASE DON'T EDIT
"""
For operations that feel like the termination
"""
from collections import defaultdict
from typing import Iterator
from k1lib.bioinfo.cli.init import patchDefaultDelim, BaseCli
import k1lib.bioinfo.cli as cli
__all__ = ["stdout", "file", "pretty", "display"]
class _Stdout(BaseCli):
    """Prints out all lines"""
    def __ror__(self, it:Iterator[str]):
        for line in it: print(line)
    def __call__(self): return self
stdout = _Stdout()
class file(BaseCli):
    def __init__(self, fileName:str): self.fileName = fileName
    def __ror__(self, it:Iterator[str]) -> None:
        with open(self.fileName, "w") as f:
            for line in it: f.write(f"{line}\n")
class pretty(BaseCli):
    def __init__(self, delim:str=None):
        """Pretty prints a table"""
        self.delim = patchDefaultDelim(delim)
    def __ror__(self, it:Iterator[str]):
        lines = []
        widths = defaultdict(lambda: 0)
        for line in it:
            lines.append(elems := line.split(self.delim))
            for i, elem in enumerate(elems):
                widths[i] = max(len(elem), widths[i])
        for elems in lines:
            s = ""
            for w, elem in zip(widths.values(), elems):
                s += elem.rstrip(" ").ljust(w+3)
            yield s
class display(BaseCli):
    def __init__(self, lines:int=10, delim:str=None):
        """Convenience method for getting head, make it pretty and print it out"""
        self.lines = lines; self.delim = delim
    def __ror__(self, it:Iterator[str], lines=10):
        a = (it if self.lines is None else it | cli.head(self.lines))
        a | pretty(self.delim) > stdout