# AUTOGENERATED FILE! PLEASE DON'T EDIT
"""
This is for quick modifiers, think of them as changing formats
"""
__all__ = ["lstrip", "rstrip", "strip", "apply",
           "upper", "lower", "replace", "remove", "sort"]
from typing import Callable, Iterator
from k1lib.bioinfo.cli.init import patchDefaultDelim, BaseCli
class lstrip(BaseCli):
    """Strips left of every line"""
    def __init__(self, char:str=None): self.char = char
    def __ror__(self, it:Iterator[str]):
        if self.char != None:
            for line in it: yield line.lstrip(char)
        else:
            for line in it: yield line.lstrip()
class rstrip(BaseCli):
    "Strips right of every line"
    def __init__(self, char:str=None): self.char = char
    def __ror__(self, it:Iterator[str]):
        if self.char != None:
            for line in it: yield line.rstrip(char)
        else:
            for line in it: yield line.rstrip()
class strip(BaseCli):
    """Strips both sides of every line"""
    def __init__(self, char:str=None): self.char = char
    def __ror__(self, it:Iterator[str]):
        if self.char != None:
            for line in it: yield line.strip(char)
        else:
            for line in it: yield line.strip()
class apply(BaseCli):
    def __init__(self, f:Callable[[str], str]):
        """Applies a function f to every line"""
        self.f = f
    def __ror__(self, it:Iterator[str]):
        for line in it: yield self.f(line)
class upper(BaseCli):
    """Make all characters uppercase"""
    def __ror__(self, it:Iterator[str]):
        for line in it: yield line.upper()
class lower(BaseCli):
    """Make all characters lowercase"""
    def __ror__(self, it:Iterator[str]):
        for line in it: yield line.lower()
class replace(BaseCli):
    def __init__(self, s:str, target:str=None):
        """Replaces substring `s` with `target` for each line"""
        self.s = s; self.target = patchDefaultDelim(target)
    def __ror__(self, it:Iterator[str]):
        for line in it: yield line.replace(self.s, self.target)
class remove(replace):
    def __init__(self, s:str):
        """Removes a specific substring in each line"""
        super().__init__(s, "")
from k1lib.bioinfo.cli.filt import isNumeric
class sort(BaseCli):
    def __init__(self, column:int=0, reverse=False, numeric=True, delim:str=None):
        """Sorts all lines based on a specific `column`.

:param reverse: False for smaller to bigger, True for bigger to smaller
:param numeric: whether to treat column as float
:param delim: delimiter that separates columns"""
        self.column = column; self.reverse = reverse; self.numeric = numeric
        self.filterF = (lambda x: float(x)) if numeric else (lambda x: x)
        self.delim = patchDefaultDelim(delim)
    def __ror__(self, it:Iterator[str]):
        if self.numeric: it = it | isNumeric(self.column, self.delim)
        elems = list(it)
        def sortF(line):
            elems = line.split(self.delim)
            if len(elems) > self.column:
                return self.filterF(elems[self.column])
            return float("inf")
        elems = sorted(elems, key=sortF)
        if self.reverse: elems.reverse()
        return iter(elems)
    def __invert__(self):
        """Creates a clone that has the opposite sort order"""
        return sort(self.column, not self.reverse, self.numeric, self.delim)