# AUTOGENERATED FILE! PLEASE DON'T EDIT
settings = {"defaultDelim": "\t", "defaultIndent": "  ",
            "oboFile": None, "strict": False, "lookupImgs": True}
def patchDefaultDelim(s:str):
    """
:param s:
    - if not None, returns self
    - else returns the default delimiter in settings"""
    return settings["defaultDelim"] if s is None else s
def patchDefaultIndent(s:str):
    """
:param s:
    - if not None, returns self
    - else returns the default indent character in settings"""
    return settings["defaultIndent"] if s is None else s
from typing import List, Iterator, Any
import itertools
class BaseCli:
    def __and__(self, cliObj:"BaseCli"):
        if isinstance(self, oneToMany):
            self.cliObjs.append(cliObj); return self
        if isinstance(cliObj, oneToMany):
            cliObj.cliObjs.append(cliObj); return cliObj
        return oneToMany(self, cliObj)
    def all(self) -> "BaseCli":
        """Applies this BaseCli to all incoming streams"""
        return manyToMany(self)
    def __or__(self, it):
        if isinstance(it, BaseCli):
            return serial(self, it)
    def f(self):
        """Creates a normal function :math:`f(x)` which is equivalent to
``x | self``."""
        return lambda it: self.__ror__(it)
    def __lt__(self, it):
        """Default backup join symbol `>`, in case `it` implements __ror__()"""
        return self.__ror__(it)
class serial(BaseCli):
    def __init__(self, *clis:List[BaseCli]):
        """Merges clis into 1, feeding end to end"""
        self.clis = clis
    def __ror__(self, it:Iterator[Any]) -> Iterator[Any]:
        for cli in self.clis: it = cli.__ror__(it)
        return it
class oneToMany(BaseCli):
    def __init__(self, *clis:List[BaseCli]):
        """Splits 1 stream into multiple streams, each for a cli
in the list"""
        self.clis = clis
    def __ror__(self, it:Iterator[Any]) -> Iterator[Iterator[Any]]:
        its = itertools.tee(it, len(self.clis))
        for cli, it in zip(self.clis, its):
            yield cli.__ror__(it)
class manyToMany(BaseCli):
    def __init__(self, cli):
        """Applies multiple streams to a single cli"""
        self.cli = cli
    def __ror__(self, it:Iterator[Iterator[Any]]) -> Iterator[Iterator[Any]]:
        for stream in it: yield self.cli.__ror__(stream)