# AUTOGENERATED FILE! PLEASE DON'T EDIT
__all__ = ["grep", "grepTemplate"]
import re
from k1lib.bioinfo.cli.init import patchDefaultDelim, BaseCli
from collections import deque
from typing import Iterator
class grep(BaseCli):
    def __init__(self, pattern:str, before:int=0, after:int=0, singleLine:bool=False, delim:str=None):
        """Find lines that has the specified pattern.

:param pattern: regex pattern to search for in a line
:param before: lines before the hit. Outputs independent lines
:param after: lines after the hit. Outputs independent lines
:param singleLine: change to True, to bunch before and after lines to a single line
:param delim: the delimiter in between sections if singleLine is True"""
        self.pattern = re.compile(pattern)
        self.before = before; self.after = after
        self.singleLine = singleLine; self.delim = patchDefaultDelim(None)
    def __ror__(self, it:Iterator[str]):
        if self.singleLine:
            gr = grep(self.pattern.pattern, self.before, self.after)
            elems = []; idx = 0
            for line in (it | gr):
                if gr.sectionIdx > idx: # outputs whatever remaining
                    idx = gr.sectionIdx
                    yield self.delim.join(elems)
                    elems = []
                elems.append(line)
            yield self.delim.join(elems); return
        self.sectionIdx = 0
        queue = deque(); self.counter = 0 # remaining lines after to display
        for line in it:
            # saves recent past lines
            queue.append(line)
            if len(queue) > self.before + 1: queue.popleft()
            a = self.pattern.search(line) is not None
            b = self.counter > 0
            if a or b: # if detected, or still printing the "after" section
                if a:
                    self.sectionIdx += 1
                    self.counter = self.after + 1 # resets "after" section
                for l in queue: yield l # prints current line and everything before
                queue.clear()
                self.counter -= 1
class grepTemplate(BaseCli):
    def __init__(self, pattern:str, template:str):
        """Searches over all lines, pick out the match, and expands
it to the templateand yields"""
        self.pattern = re.compile(pattern); self.template = template
    def __ror__(self, it:Iterator[str]):
        for line in it:
            matchObj = self.pattern.search(line)
            if matchObj is None: continue
            yield matchObj.expand(self.template)