# AUTOGENERATED FILE! PLEASE DON'T EDIT
"""
This is for functions that cuts out specific parts of the table
"""
from typing import Callable, Union, List, overload, Iterator, Any
from k1lib.bioinfo.cli.init import patchDefaultDelim, BaseCli, settings
import k1lib.bioinfo.cli as cli
__all__ = ["filt", "nonEmpty", "nonEmptyStream", "startswith", "endswith",
           "isNumeric", "inRange",
           "head", "nhead",
           "columns", "cut", "rows", "every"]
class filt(BaseCli):
    def __init__(self, predicate:Callable[[str], bool], column:int=0, delim:str=None):
        """Filters out lines.

:param column:
    - if integer, then predicate(line.split(delim)[column])
    - if None, then predicate(line)"""
        self.predicate = predicate; self.column = column
        self.delim = patchDefaultDelim(delim)
    def __ror__(self, it:Iterator[str]):
        if self.column is not None:
            for line in it:
                elems = line.split(self.delim)
                if len(elems) <= self.column: continue
                if self.predicate(elems[self.column]): yield line
        else:
            for line in it:
                if self.predicate(line): yield line
    def __invert__(self):
        """Negate the condition"""
        return filt(lambda s: not self.predicate(s), self.column, self.delim)
class nonEmpty(filt):
    def __init__(self, column:int=0, delim:str=None):
        """Filters out lines' column that is empty"""
        super().__init__(lambda l: l != "", column, delim)
class nonEmptyStream(BaseCli):
    """Filters out streams that have no rows"""
    def __ror__(self, streams:Iterator[Iterator[Any]]) -> Iterator[Iterator[Any]]:
        for stream in streams:
            try:
                it = iter(stream)
                firstValue = next(it)
                def newGen():
                    yield firstValue; yield from it
                yield newGen()
            except StopIteration: pass
class startswith(filt):
    def __init__(self, s:str, column:int=0, delim:str=None):
        """Filters out lines' column that don't start with `s`"""
        super().__init__(lambda l: l.startswith(s), column, delim)
class endswith(filt):
    def __init__(self, s:str, column:int=0, delim:str=None):
        super().__init__(lambda l: l.endswith(s), column, delim)
class isNumeric(BaseCli):
    def __init__(self, column:int=None, delim:str=None):
        """Filters out a line if that column is not a number"""
        self.column = column; self.delim = patchDefaultDelim(delim)
    def __ror__(self, it:Iterator[str]):
        if self.column is not None:
            for line in it:
                try: float(line.split(self.delim)[self.column]); yield line
                except ValueError: pass
        else:
            for line in it:
                try: float(line); yield line
                except ValueError: pass
class head(BaseCli):
    def __init__(self, n:int=10):
        """Only outputs first {n} lines, preferable over row()[:n]"""
        self.n = n
    def __ror__(self, it:Iterator[str]):
        for i, line in enumerate(it):
            if i >= self.n: break
            yield line
class nhead(BaseCli):
    def __init__(self, n:int=1):
        """Only outputs after first {n} lines, preferable over row()[n:]"""
        self.n = n
    def __ror__(self, it:Iterator[str]):
        for i, line in enumerate(it):
            if i < self.n: continue
            yield line
class columns(BaseCli):
    def __init__(self, *columns:Union[int, slice, List[int]], delim:str=None):
        """Cuts out specific columns, separated by `delim`"""
        if len(columns) == 1 and isinstance(columns[0], (list, tuple, slice)): columns = columns[0]
        self.columns = columns; self.delim = patchDefaultDelim(delim)
    def __ror__(self, it:Iterator[str]):
        columns = self.columns
        if isinstance(columns, int): columns = set([columns])
        if isinstance(columns, list): columns = set(columns)
        for i, line in enumerate(it):
            if i == 0 and isinstance(columns, slice):
                columns = set(range(len(line.split(self.delim)))[columns])
            yield self.delim.join(elem for i, elem in enumerate(line.split(self.delim)) if i in columns)
    def __getitem__(self, idx): return cut(idx, delim=self.delim)
cut = columns
class rows(BaseCli):
    def __init__(self, *rows):
        """Cuts out specific rows. Can do `rows()[5:10]` to get rows 5 to 10"""
        if len(rows) == 1 and isinstance(rows[0], (list, tuple)): rows = rows[0]
        self.rows = rows
    def __getitem__(self, _slice):
        answer = rows(); answer.rows = _slice; return answer
    def __ror__(self, it:Iterator[str]):
        l = list(it)
        if isinstance(self.rows, slice):
            self.rows = range(len(l))[self.rows]
        for row in self.rows: yield l[row]
class every(BaseCli):
    def __init__(self, length:int, offset:int=0):
        """Get lines every `length`, starting at a specific `offset`"""
        self.length = length; self.offset = offset
    def __ror__(self, it:Iterator[str]):
        for i, line in enumerate(it):
            if (i - self.offset) % self.length == 0: yield line
class inRange(BaseCli):
    def __init__(self, min:float=None, max:float=None, column:int=None, delim:str=None):
        """Checks whether a column is in range or not"""
        self.min = min if min is not None else float("-inf")
        self.max = max if max is not None else float("inf")
        self.column = column; self.delim = patchDefaultDelim(delim)
    def __ror__(self, it:Iterator[str]):
        if self.column is not None:
            for line in it:
                value = float(line.split(self.delim)[self.column])
                if value >= self.min and value < self.max:
                    yield line
        else:
            if not settings["strict"]: it = it | cli.numeric()
            for value in it:
                if value >= self.min and value < self.max: yield value