# AUTOGENERATED FILE! PLEASE DON'T EDIT
import k1lib, torch.nn as nn, torch, dill
class Learner:
    def __init__(self):
        self.model = None; self.data = None; self.opt = None
        self.lossF = None; self._cbs = None; self.fileName = None
        self.css = "*"
        self.cbs = k1lib.Callbacks().withBasics().withQOL().withAdvanced()
    @property
    def cbs(self): return self._cbs
    @cbs.setter
    def cbs(self, cbs): cbs.learner = self; self._cbs = cbs
    @property
    def css(self): return self._css
    @css.setter
    def css(self, css:str):
        self._css = css
        if self.model != None: self.selector = k1lib.selector.select(self.model, self.css)
    def __getattr__(self, attr):
        if attr == "cbs": raise AttributeError()
        return getattr(self.cbs, attr)
    def __getstate__(self):
        answer = dict(self.__dict__); del answer["selector"]; return answer
    def __setstate__(self, state):
        self.__dict__.update(state)
        self.css = self.css; self.cbs.learner = self
    def evaluate(self): pass # supposed to be overriden, to provide functionality here
    @property
    def warnings(self):
        warnings = "Warning: no model yet. Set using `l.model = ...`\n" if self.model == None else ""
        warnings += "Warning: no loss function yet. Set using `l.lossF = ...`\n" if self.lossF == None else ""
        warnings += "Warning: no data yet. Set using `l.data = ...`\n" if self.data == None else ""
        warnings += "Warning: no optimizer yet. Set using `l.opt = ...`\n" if self.opt == None else ""
        if warnings != "": warnings += "\n\n"
        return warnings
    def __repr__(self):
        return f"""{self.warnings}l.model:\n{k1lib.tab(k1lib.limitLines(str(self.model)))}
l.opt:\n{k1lib.tab(k1lib.limitLines(str(self.opt)))}
l.cbs:\n{k1lib.tab(k1lib.limitLines(self.cbs.__repr__()))}
Use...
- l.model = ...: to specify a nn.Module object
- l.data = ...: to specify data object
- l.opt = ...: to specify an optimizer
- l.lossF = ...: to specify a loss function
- l.css = ...: to select modules using CSS. "#root" for root model
- l.cbs = ...: to use a custom `Callbacks` object
- l.selector: to get the modules selected by `l.css`
- l.run(epochs): to run the network
- l.Loss: to get a specific callback, this case "Loss"\n\n"""
@k1lib.patch(Learner)
def save(self, fileName:str=None):
    self.fileName = fileName or self.fileName
    if self.fileName == None:
        files = [file for file in os.listdir() if file.startswith("learner") and file.endswith(".pth")]
        files = set([int(file.split(".pth")[0].split("learner-")[1]) for file in files])
        count = 0;
        while count in files: count += 1
        self.fileName = f"l-{count}.pth"
    torch.save(self, self.fileName, pickle_module=dill)
    print(f"Saved to {self.fileName}")
@k1lib.patch(Learner)
def load(fileName:str=None):
    if fileName==None: fileName = input("Enter learner file name to load:")
    print(f"Loaded from {fileName}"); return torch.load(fileName, pickle_module=dill)
@k1lib.patch(Learner)
def _run1Batch(self):
    self.cbs("startBatch")
    try:
        self.cbs("startPass"); self.y = self.model(self.xb); self.cbs("endPass")
        self.cbs("startLoss"); loss = self.lossF(self.y, self.yb)
        self.loss = loss.detach().item(); self.cbs("endLoss")
        if not self.cbs("startBackward"): loss.backward()
        if not self.cbs("startStep"):  self.opt.step()
        if not self.cbs("startZeroGrad"): self.opt.zero_grad(set_to_none=True)
    except k1lib.CancelBatchException as ex:
        self.cbs("cancelBatch"); print(f"Batch cancelled: {ex}.")
    self.cbs("endBatch")
@k1lib.patch(Learner)
def _run1Epoch(self):
    self.cbs("startEpoch")
    try:
        self.batches = (trainLen := len(self.data.train)) + len(self.data.valid)
        self.model.train()
        for self.batch, (self.xb, self.yb) in enumerate(self.data.train):
            self._run1Batch()
        self.model.eval(); self.cbs("startValidBatches")
        for self.batch, (self.xb, self.yb) in enumerate(self.data.valid):
            self.batch += trainLen; self._run1Batch()
    except k1lib.CancelEpochException as ex:
        self.cbs("cancelEpoch")
        print(f"Epoch cancelled: {ex}.")
    self.cbs("endEpoch")
@k1lib.patch(Learner)
def run(self, epochs:int, batches:int=None):
    if self.warnings != "": raise Exception(self.warnings)
    self.epochs = epochs; self.css = self.css # update module selector
    with self.cbs.context():
        if batches != None: self.cbs.withBatchLimit(batches)
        self.cbs("startRun")
        try:
            for self.epoch in range(epochs): self._run1Epoch()
        except k1lib.CancelRunException as ex:
            self.cbs("cancelRun"); print(f"Run cancelled: {ex}.")
        self.cbs("endRun"); return self
@k1lib.patch(Learner)
def evaluate(self): raise NotImplementedError("You have to define evaluate() by yourself")