# Copyright 2019 Canonical Ltd.  This software is licensed under the
# GNU Lesser General Public License version 3 (see the file LICENSE).
import json
import textwrap
from sys import stdout


def write_double(stream, api_name, api_data):
    double_name = u'%s_%s' % (api_name, "1_0")
    double_text = textwrap.dedent(u"""\

    {double_name} = service_mock(
        service={service!r},
        methods={methods!r},
        url={url!r},
        input_schema={request_schema!r},
        output_schema={response_schema!r},
    )

    """).format(
        double_name=double_name,
        **api_data
    )
    stream.write(double_text)


HEADER_TEXT = u"""\
# This file is AUTO GENERATED. Do not edit this file directly. Instead,
# re-generate it.

from acceptable._doubles import service_mock

"""


def write_header(stream):
    stream.write(HEADER_TEXT)


def generate_service_mock_doubles(metadata, stream=stdout):
    write_header(stream)
    for module_name, module_data in metadata.items():
        if module_name.startswith('$'):
            continue
        for api_name, api_data in module_data['apis'].items():
            write_double(stream, api_name, api_data)
