# coding=utf-8
# --------------------------------------------------------------------------
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.pipeline import ClientRawResponse
from msrest.exceptions import HttpOperationError

from .. import models


class EmsProfileOperations(object):
    """EmsProfileOperations operations.

    :param client: Client for service requests.
    :param config: Configuration of service client.
    :param serializer: An object model serializer.
    :param deserializer: An object model deserializer.
    """

    models = models

    def __init__(self, client, config, serializer, deserializer):

        self._client = client
        self._serialize = serializer
        self._deserialize = deserializer

        self.config = config

    def get_ems_profile_results(
            self, ems_system_id, flight_id, profile_id, custom_headers=None, raw=False, **operation_config):
        """[DEPRECATED] Returns profile results for a specific flight.

        This route has been replaced by
        'v2/ems-systems/{emsSystemId}/flights/{flightId}/profiles/{profileId}/query'
        route which aligns better with existing API conventions.

        :param ems_system_id: The unique identifier of the system containing
         the EMS data.
        :type ems_system_id: int
        :param flight_id: The integer ID of the flight record to use when
         retrieving profile information.
        :type flight_id: int
        :param profile_id: The unique identifier of the APM profile, e.g.
         "A7483C44-9DB9-4A44-9EB5-F67681EE52B0" for
         the library flight safety events profile.
        :type profile_id: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.get_ems_profile_results.metadata['url']
        path_format_arguments = {
            'emsSystemId': self._serialize.url("ems_system_id", ems_system_id, 'int'),
            'flightId': self._serialize.url("flight_id", flight_id, 'int'),
            'profileId': self._serialize.url("profile_id", profile_id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 400, 401, 404, 503]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('AdiEmsWebApiV2DtoEmsProfileProfileResults', response)
        if response.status_code == 400:
            deserialized = self._deserialize('AdiEmsWebApiModelError', response)
        if response.status_code == 401:
            deserialized = self._deserialize('AdiEmsWebApiModelError', response)
        if response.status_code == 404:
            deserialized = self._deserialize('AdiEmsWebApiModelError', response)
        if response.status_code == 503:
            deserialized = self._deserialize('AdiEmsWebApiModelError', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    get_ems_profile_results.metadata = {'url': '/v2/ems-systems/{emsSystemId}/flights/{flightId}/ems-profiles/{profileId}'}

    def get_ems_profiles(
            self, ems_system_id, custom_headers=None, raw=False, **operation_config):
        """[DEPRECATED] Returns information about a set of profiles for an EMS
        system.

        This route has been replaced by
        'v2/ems-systems/{emsSystemId}/profile-groups' and
        'v2/ems-systems/{emsSystemId}/profiles' routes which align better with
        existing API conventions and offers more features like searching and
        enumerating the profile group
        hierarchy.

        :param ems_system_id: The unique identifier of the system containing
         the EMS data.
        :type ems_system_id: int
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.get_ems_profiles.metadata['url']
        path_format_arguments = {
            'emsSystemId': self._serialize.url("ems_system_id", ems_system_id, 'int')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 401, 503]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('[AdiEmsWebApiV2DtoEmsProfileEmsProfile]', response)
        if response.status_code == 401:
            deserialized = self._deserialize('AdiEmsWebApiModelError', response)
        if response.status_code == 503:
            deserialized = self._deserialize('AdiEmsWebApiModelError', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    get_ems_profiles.metadata = {'url': '/v2/ems-systems/{emsSystemId}/ems-profiles'}

    def get_ems_profile_glossary(
            self, ems_system_id, profile_id, profile_version_number=None, format=None, custom_headers=None, raw=False, **operation_config):
        """[DEPRECATED] Returns the file content of an APM profile glossary for a
        specific profile and version.

        <p>
        This route has been replaced by
        'v2/ems-systems/{emsSystemId}/profiles/{profileId}/glossary' route
        which
        aligns better with existing API conventions and offers more features
        like returning JSON responses with
        a more detailed glossary.
        </p>
        <p>
        This API is intended to be used in conjunction with the
        "ems-systems/{emsSystemId}/flights/{flightId}/ems-profiles/{profileId}"
        API used to return APM (Automated
        Parameter Measurement) profile result. Using the data returned from
        this API you can interpret and
        better understand the results returned in  the profile results.
        </p>.

        :param ems_system_id: The unique identifier of the system containing
         the EMS data.
        :type ems_system_id: int
        :param profile_id: The unique identifier of the APM profile, e.g.
         "A7483C44-9DB9-4A44-9EB5-F67681EE52B0" for
         the library flight safety events profile.
        :type profile_id: str
        :param profile_version_number: Numbered version of an APM profile. The
         current version of the profile
         will be used if a version number is not provided.
        :type profile_version_number: int
        :param format: The format the glossary should be returned in. This
         defaults to CSV. Possible values include: 'json', 'csv'
        :type format: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.get_ems_profile_glossary.metadata['url']
        path_format_arguments = {
            'emsSystemId': self._serialize.url("ems_system_id", ems_system_id, 'int'),
            'profileId': self._serialize.url("profile_id", profile_id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        if profile_version_number is not None:
            query_parameters['profileVersionNumber'] = self._serialize.query("profile_version_number", profile_version_number, 'int')
        if format is not None:
            query_parameters['format'] = self._serialize.query("format", format, 'str')

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 400, 401, 404, 503]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('AdiEmsWebApiV2DtoEmsProfileEmsProfileGlossary', response)
        if response.status_code == 400:
            deserialized = self._deserialize('AdiEmsWebApiModelError', response)
        if response.status_code == 401:
            deserialized = self._deserialize('AdiEmsWebApiModelError', response)
        if response.status_code == 404:
            deserialized = self._deserialize('AdiEmsWebApiModelError', response)
        if response.status_code == 503:
            deserialized = self._deserialize('AdiEmsWebApiModelError', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    get_ems_profile_glossary.metadata = {'url': '/v2/ems-systems/{emsSystemId}/ems-profiles/{profileId}/glossary'}
