# coding=utf-8
# --------------------------------------------------------------------------
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.pipeline import ClientRawResponse
from msrest.exceptions import HttpOperationError

from .. import models


class AnalyticOperations(object):
    """AnalyticOperations operations.

    :param client: Client for service requests.
    :param config: Configuration of service client.
    :param serializer: An object model serializer.
    :param deserializer: An object model deserializer.
    """

    models = models

    def __init__(self, client, config, serializer, deserializer):

        self._client = client
        self._serialize = serializer
        self._deserialize = deserializer

        self.config = config

    def search_for_analytics(
            self, ems_system_id, text, group=None, max_results=None, category=None, custom_headers=None, raw=False, **operation_config):
        """Searches for analytics by name.

        :param ems_system_id: The unique identifier of the system containing
         the EMS data.
        :type ems_system_id: int
        :param text: The search terms used to find a list of analytics by
         name.
        :type text: str
        :param group: An optional group ID to specify where to limit the
         search. If not specified, all groups
         are searched.
        :type group: str
        :param max_results: The optional maximum number of matching results to
         return. If not specified, a
         default value of 200 is used. Use 0 to return all results.
        :type max_results: int
        :param category: The category of analytics to search, including
         "Full", "Physical" or "Logical". A
         null value specifies the default analytic set, which represents the
         full set of values exposed by the
         backing EMS system. Possible values include: 'full', 'physical',
         'logical'
        :type category: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.search_for_analytics.metadata['url']
        path_format_arguments = {
            'emsSystemId': self._serialize.url("ems_system_id", ems_system_id, 'int')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        query_parameters['text'] = self._serialize.query("text", text, 'str')
        if group is not None:
            query_parameters['group'] = self._serialize.query("group", group, 'str')
        if max_results is not None:
            query_parameters['maxResults'] = self._serialize.query("max_results", max_results, 'int')
        if category is not None:
            query_parameters['category'] = self._serialize.query("category", category, 'str')

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 401, 503]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('[AdiEmsWebApiV2DtoAnalyticInfo]', response)
        if response.status_code == 401:
            deserialized = self._deserialize('AdiEmsWebApiModelError', response)
        if response.status_code == 503:
            deserialized = self._deserialize('AdiEmsWebApiModelError', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    search_for_analytics.metadata = {'url': '/v2/ems-systems/{emsSystemId}/analytics'}

    def get_analytic_info(
            self, ems_system_id, analytic_id, custom_headers=None, raw=False, **operation_config):
        """Retrieves metadata information associated with an analytic such as a
        description or units.

        :param ems_system_id: The unique identifier of the system containing
         the EMS data.
        :type ems_system_id: int
        :param analytic_id: The analytic ID for which data is retrieved. These
         identifiers are typically
         obtained from nodes in an analytic group tree.
        :type analytic_id:
         ~emsapi.models.AdiEmsWebApiV2ModelAnalyticAnalyticId
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.get_analytic_info.metadata['url']
        path_format_arguments = {
            'emsSystemId': self._serialize.url("ems_system_id", ems_system_id, 'int')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        header_parameters['Content-Type'] = 'application/json; charset=utf-8'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct body
        body_content = self._serialize.body(analytic_id, 'AdiEmsWebApiV2ModelAnalyticAnalyticId')

        # Construct and send request
        request = self._client.post(url, query_parameters, header_parameters, body_content)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 401, 503]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('AdiEmsWebApiV2DtoAnalyticInfo', response)
        if response.status_code == 401:
            deserialized = self._deserialize('AdiEmsWebApiModelError', response)
        if response.status_code == 503:
            deserialized = self._deserialize('AdiEmsWebApiModelError', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    get_analytic_info.metadata = {'url': '/v2/ems-systems/{emsSystemId}/analytics'}

    def search_for_flight_analytics(
            self, ems_system_id, flight_id, text, group=None, max_results=None, category=None, custom_headers=None, raw=False, **operation_config):
        """Searches for analytics by name for a specific flight.

        :param ems_system_id: The unique identifier of the system containing
         the EMS data.
        :type ems_system_id: int
        :param flight_id: The integer ID of the flight record to use when
         searching analytics.
        :type flight_id: int
        :param text: The search terms used to find a list of analytics by
         name.
        :type text: str
        :param group: An optional group ID to specify where to limit the
         search. If not specified, all groups are
         searched.
        :type group: str
        :param max_results: The optional maximum number of matching results to
         return. If not specified, a
         default value of 200 is used. Use 0 to return all results.
        :type max_results: int
        :param category: The category of analytics to search, including
         "Full", "Physical" or "Logical". A
         null value specifies the default analytic set, which represents the
         full set of values exposed by the
         backing EMS system. Possible values include: 'full', 'physical',
         'logical'
        :type category: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.search_for_flight_analytics.metadata['url']
        path_format_arguments = {
            'emsSystemId': self._serialize.url("ems_system_id", ems_system_id, 'int'),
            'flightId': self._serialize.url("flight_id", flight_id, 'int')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        query_parameters['text'] = self._serialize.query("text", text, 'str')
        if group is not None:
            query_parameters['group'] = self._serialize.query("group", group, 'str')
        if max_results is not None:
            query_parameters['maxResults'] = self._serialize.query("max_results", max_results, 'int')
        if category is not None:
            query_parameters['category'] = self._serialize.query("category", category, 'str')

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 401, 503]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('[AdiEmsWebApiV2DtoAnalyticInfo]', response)
        if response.status_code == 401:
            deserialized = self._deserialize('AdiEmsWebApiModelError', response)
        if response.status_code == 503:
            deserialized = self._deserialize('AdiEmsWebApiModelError', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    search_for_flight_analytics.metadata = {'url': '/v2/ems-systems/{emsSystemId}/flights/{flightId}/analytics'}

    def get_flight_analytic_info(
            self, ems_system_id, flight_id, analytic_id, custom_headers=None, raw=False, **operation_config):
        """Retrieves metadata information associated with an analytic such as a
        description or units.

        :param ems_system_id: The unique identifier of the system containing
         the EMS data.
        :type ems_system_id: int
        :param flight_id: The integer ID of the flight record to use when
         retrieving the analytic information.
        :type flight_id: int
        :param analytic_id: The analytic ID for which data is retrieved. These
         identifiers are typically
         obtained from nodes in an analytic group tree.
        :type analytic_id:
         ~emsapi.models.AdiEmsWebApiV2ModelAnalyticAnalyticId
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.get_flight_analytic_info.metadata['url']
        path_format_arguments = {
            'emsSystemId': self._serialize.url("ems_system_id", ems_system_id, 'int'),
            'flightId': self._serialize.url("flight_id", flight_id, 'int')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        header_parameters['Content-Type'] = 'application/json; charset=utf-8'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct body
        body_content = self._serialize.body(analytic_id, 'AdiEmsWebApiV2ModelAnalyticAnalyticId')

        # Construct and send request
        request = self._client.post(url, query_parameters, header_parameters, body_content)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 401, 503]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('AdiEmsWebApiV2DtoAnalyticInfo', response)
        if response.status_code == 401:
            deserialized = self._deserialize('AdiEmsWebApiModelError', response)
        if response.status_code == 503:
            deserialized = self._deserialize('AdiEmsWebApiModelError', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    get_flight_analytic_info.metadata = {'url': '/v2/ems-systems/{emsSystemId}/flights/{flightId}/analytics'}

    def get_analytic_group_contents(
            self, ems_system_id, analytic_group_id=None, category=None, custom_headers=None, raw=False, **operation_config):
        """Retrieves the contents of an analytic group, which is a hierarchical
        tree structure used to organize analytics.

        The contents of a group includes both subgroups and analytics.

        :param ems_system_id: The unique identifier of the system containing
         the EMS data.
        :type ems_system_id: int
        :param analytic_group_id: The ID of the group whose contents to
         retrieve.
         If not specified, the contents of the root group will be returned.
        :type analytic_group_id: str
        :param category: The category of analytics we are interested in.
         "Full", "Physical" or "Logical".
         A null value specifies the default analytic set, which represents the
         full set of values exposed by the backing EMS system. Possible values
         include: 'full', 'physical', 'logical'
        :type category: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.get_analytic_group_contents.metadata['url']
        path_format_arguments = {
            'emsSystemId': self._serialize.url("ems_system_id", ems_system_id, 'int')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        if analytic_group_id is not None:
            query_parameters['analyticGroupId'] = self._serialize.query("analytic_group_id", analytic_group_id, 'str')
        if category is not None:
            query_parameters['category'] = self._serialize.query("category", category, 'str')

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 401, 503]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('AdiEmsWebApiV2DtoAnalyticGroupContents', response)
        if response.status_code == 401:
            deserialized = self._deserialize('AdiEmsWebApiModelError', response)
        if response.status_code == 503:
            deserialized = self._deserialize('AdiEmsWebApiModelError', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    get_analytic_group_contents.metadata = {'url': '/v2/ems-systems/{emsSystemId}/analytic-groups'}

    def get_flight_analytic_group_contents(
            self, ems_system_id, flight_id, analytic_group_id=None, category=None, custom_headers=None, raw=False, **operation_config):
        """Retrieves the contents of an analytic group, which is a hierarchical
        tree structure used to organize analytics.

        <p>The contents of a group includes both subgroups and analytics.</p>
        <p>In this resource a flight is specified which will enumerate
        analytics specific to the flight such as
        physical parameters in addition to the analytics and groups which apply
        to all flights.</p>.

        :param ems_system_id: The unique identifier of the system containing
         the EMS data.
        :type ems_system_id: int
        :param flight_id: The integer ID of the flight record to use when
         retrieving the analytic group.
        :type flight_id: int
        :param analytic_group_id: The ID of the group whose contents to
         retrieve.
         If not specified, the contents of the root group will be returned
         instead.
        :type analytic_group_id: str
        :param category: The category of analytics we are interested in.
         "Full", "Physical" or "Logical".
         A null value specifies the default analytic set, which represents the
         full set of values exposed by the backing EMS system. Possible values
         include: 'full', 'physical', 'logical'
        :type category: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.get_flight_analytic_group_contents.metadata['url']
        path_format_arguments = {
            'emsSystemId': self._serialize.url("ems_system_id", ems_system_id, 'int'),
            'flightId': self._serialize.url("flight_id", flight_id, 'int')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        if analytic_group_id is not None:
            query_parameters['analyticGroupId'] = self._serialize.query("analytic_group_id", analytic_group_id, 'str')
        if category is not None:
            query_parameters['category'] = self._serialize.query("category", category, 'str')

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 401, 503]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('AdiEmsWebApiV2DtoAnalyticGroupContents', response)
        if response.status_code == 401:
            deserialized = self._deserialize('AdiEmsWebApiModelError', response)
        if response.status_code == 503:
            deserialized = self._deserialize('AdiEmsWebApiModelError', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    get_flight_analytic_group_contents.metadata = {'url': '/v2/ems-systems/{emsSystemId}/flights/{flightId}/analytic-groups'}

    def get_query_results(
            self, ems_system_id, flight_id, query, custom_headers=None, raw=False, **operation_config):
        """Queries offsets and values in time-series data for a specified flight
        and analytic.

        <p>
        This can be used to query for multiple analytics at the same time by
        providing more than one analytic ID
        in the query. Keep in mind that querying for many analytics might cause
        your request to take a longer
        period of time to complete.
        </p>
        <p>Below are some guidelines to consider when using this API.
        <ul><li>Use the <code>size</code> option to return a specified amount
        of interpolated samples. </li><li>Not specifying a <code>size</code>
        returns all data samples, but you can also use a range of
        <code>start</code> and <code>end</code>
        values to limit the amount of data returned. You can't use this option
        with the <code>unsampledDataMode</code>
        option.</li><li>Use the <code>offsets</code> option to return data for
        only a specified set of samples. If an analytic isn't
        sampled at the offset, its interpolated value is returned. You can't
        use this option with the
        <code>unsampledDataMode</code> option.</li><li>Use the
        <code>offsetType</code> option to return values only at sampled
        locations using the <code>sampledValues</code> option or at
        a specific sampling rate using the <code>samplingRate</code> option.
        Since these options are more complex and can leave
        sample locations with no value (i.e. the analytic isn't sampled at that
        location) or DNE values where the sample
        <code>does not exist</code> you can use the <code>offsetType</code> in
        conjunction with the <code>unsampledDataMode</code>, the
        <code>unsampledValue</code>,
        and/or the <code>doesNotExistValue</code> options. These are explained
        in greater detail below.</li><li>If you use the
        <code>unsampledDataMode</code> option with <code>offsetType</code> you
        can set how unsampled data is treated
        with one of the following options:
        <ul><li><code>leaveBlank</code> Leaves any unsampled data locations as
        blank values. This is the
        default.</li><li><code>uniquePreviousSample</code> leaves values blank
        except when there is a previous valid sampled
        value that was skipped over due to the sampling rate if it is
        unchanged. This can be used to circumvent the
        issue of possibly returning all blank values when the provided sampling
        rate doesn't match the analytic's
        sampling rate.</li><li><code>stairStep</code> Any unsampled values are
        filled with the last known sampled
        value.</li><li><code>linearInterpolation</code> This performs a linear
        interpolation on the data to calculate a value for unsampled
        locations.</li><li><code>parameterDefault</code> Some analytics define
        their own default for how to treat unsampled data. This option uses
        that default setting.</li><li><code>previousSample</code> leaves values
        blank except when there is a previous valid sampled
        value that was skipped over due to the sampling rate (regardless of
        change). This can be used to circumvent
        the issue of possibly returning all blank values when the provided
        sampling rate doesn't match the analytic's
        sampling rate or if the values are not changing.</li></ul></li><li>Use
        the <code>unsampledValue</code> to provide your own value to be used
        for unsampled values. This only applies when using
        <code>offsetType</code> queries.</li><li>Use the
        <code>doesNotExistValue</code> to provide your own value for values
        that are DNE. This only applies when using <code>offsetType</code>
        queries.</li><li>Use the <code>discretesAsStrings</code> to specify
        whether the values of discrete parameters should be their string
        representations or their numeric value. This only applies when using
        <code>offsetType</code> queries.</li></ul></p>.

        :param ems_system_id: The unique identifier of the system containing
         the EMS data.
        :type ems_system_id: int
        :param flight_id: The integer ID of the flight record for which to
         query data.
        :type flight_id: int
        :param query: The information used to construct a query for which
         results are returned.
        :type query: ~emsapi.models.AdiEmsWebApiV2ModelAnalyticQuery
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.get_query_results.metadata['url']
        path_format_arguments = {
            'emsSystemId': self._serialize.url("ems_system_id", ems_system_id, 'int'),
            'flightId': self._serialize.url("flight_id", flight_id, 'int')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        header_parameters['Content-Type'] = 'application/json; charset=utf-8'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct body
        body_content = self._serialize.body(query, 'AdiEmsWebApiV2ModelAnalyticQuery')

        # Construct and send request
        request = self._client.post(url, query_parameters, header_parameters, body_content)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 400, 401, 503]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('AdiEmsWebApiV2ModelAnalyticQueryResult', response)
        if response.status_code == 400:
            deserialized = self._deserialize('AdiEmsWebApiModelError', response)
        if response.status_code == 401:
            deserialized = self._deserialize('AdiEmsWebApiModelError', response)
        if response.status_code == 503:
            deserialized = self._deserialize('AdiEmsWebApiModelError', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    get_query_results.metadata = {'url': '/v2/ems-systems/{emsSystemId}/flights/{flightId}/analytics/query'}

    def get_metadata(
            self, ems_system_id, flight_id, analytic_id, custom_headers=None, raw=False, **operation_config):
        """Returns the analytic metadata for a flight.

        <p>There are two special values always returned by the metadata
        call.</p>
        <ul>
        <li>Shape : [Single, Multiple, Unknown] : describes whether the result
        will be a single value or an array of values.</li>
        <li>DataType : [Real, Integer, String, Boolean, DateTime, Unknown] :
        describes the type of data returned.</li>
        </ul>
        The list of other properties
        returned are specific to each analytic but may include:
        <ul><li>Basic\Comments</li><li>Basic\Description</li><li>Information\Comments</li><li>Information\Description</li><li>Information\\UID</li><li>Parameter\Abbreviation</li><li>Parameter\Constant</li><li>Parameter\ID</li><li>Parameter\\Name</li><li>Value\Is
        Discrete</li><li>Value\Operational Rate Max</li><li>Value\Physical
        Range Min</li><li>Value\\Units</li><li>Value\Wraps</li></ul>.

        :param ems_system_id: The unique identifier of the system containing
         the EMS data.
        :type ems_system_id: int
        :param flight_id: The integer ID of the flight record for which to
         retrieve data.
        :type flight_id: int
        :param analytic_id: The analytic ID (wrapped in double quotes) for
         which metadata is retrieved. These
         identifiers are typically obtained from nodes in an analytic group
         tree.
        :type analytic_id:
         ~emsapi.models.AdiEmsWebApiV2ModelAnalyticAnalyticId
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.get_metadata.metadata['url']
        path_format_arguments = {
            'emsSystemId': self._serialize.url("ems_system_id", ems_system_id, 'int'),
            'flightId': self._serialize.url("flight_id", flight_id, 'int')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        header_parameters['Content-Type'] = 'application/json; charset=utf-8'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct body
        body_content = self._serialize.body(analytic_id, 'AdiEmsWebApiV2ModelAnalyticAnalyticId')

        # Construct and send request
        request = self._client.post(url, query_parameters, header_parameters, body_content)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 401, 503]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('AdiEmsWebApiV2DtoMetadata', response)
        if response.status_code == 401:
            deserialized = self._deserialize('AdiEmsWebApiModelError', response)
        if response.status_code == 503:
            deserialized = self._deserialize('AdiEmsWebApiModelError', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    get_metadata.metadata = {'url': '/v2/ems-systems/{emsSystemId}/flights/{flightId}/analytics/metadata'}
