# coding=utf-8
# --------------------------------------------------------------------------
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class AdiEmsWebApiV2DtoWeatherWeatherPhenomenon(Model):
    """Describes an individual weather phenomenon.

    All required parameters must be populated in order to send to Azure.

    :param unparsed: Required. The original, unparsed weather phenomenon
     string
    :type unparsed: str
    :param intensity: Describes the intensity of the whether phenomenon.
     Possible values include: 'light', 'moderate', 'heavy', 'vicinity'
    :type intensity: str or ~emsapi.models.enum
    :param qualifier: A qualifier for any weather precipitation. Possible
     values include: 'none', 'shallow', 'partial', 'patchy', 'drifting',
     'blowing', 'showers', 'thunderstorms', 'freezing'
    :type qualifier: str or ~emsapi.models.enum
    :param precipitation: The type of precipitation that this phenomenon
     represents. Possible values include: 'none', 'drizzle', 'rain', 'snow',
     'snowGrains', 'iceCrystals', 'icePellets', 'hail', 'smallHail', 'unknown'
    :type precipitation: str or ~emsapi.models.enum
    :param precipitation_secondary: The secondary type of precipitation that
     can be optionally specified to more accurately describe the
     precipitation. Possible values include: 'none', 'drizzle', 'rain', 'snow',
     'snowGrains', 'iceCrystals', 'icePellets', 'hail', 'smallHail', 'unknown'
    :type precipitation_secondary: str or ~emsapi.models.enum
    :param obscuration: Any weather that can obscure vision. Possible values
     include: 'none', 'mist', 'fog', 'smoke', 'volcanicAsh', 'dust', 'sand',
     'haze', 'spray'
    :type obscuration: str or ~emsapi.models.enum
    :param other: Other weather cases that do not fall under precipitation.
     Possible values include: 'none', 'dustWhirls', 'squalls', 'funnelCloud',
     'sandstorm', 'duststorm'
    :type other: str or ~emsapi.models.enum
    """

    _validation = {
        'unparsed': {'required': True},
    }

    _attribute_map = {
        'unparsed': {'key': 'unparsed', 'type': 'str'},
        'intensity': {'key': 'intensity', 'type': 'str'},
        'qualifier': {'key': 'qualifier', 'type': 'str'},
        'precipitation': {'key': 'precipitation', 'type': 'str'},
        'precipitation_secondary': {'key': 'precipitationSecondary', 'type': 'str'},
        'obscuration': {'key': 'obscuration', 'type': 'str'},
        'other': {'key': 'other', 'type': 'str'},
    }

    def __init__(self, *, unparsed: str, intensity=None, qualifier=None, precipitation=None, precipitation_secondary=None, obscuration=None, other=None, **kwargs) -> None:
        super(AdiEmsWebApiV2DtoWeatherWeatherPhenomenon, self).__init__(**kwargs)
        self.unparsed = unparsed
        self.intensity = intensity
        self.qualifier = qualifier
        self.precipitation = precipitation
        self.precipitation_secondary = precipitation_secondary
        self.obscuration = obscuration
        self.other = other
