# coding=utf-8
# --------------------------------------------------------------------------
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class AdiEmsWebApiV2DtoWeatherMetarRunwayVisualRange(Model):
    """Describes the current 10-minute average visual range for a runway, which is
    the distance over which a pilot
    can see the runway surface markings.

    All required parameters must be populated in order to send to Azure.

    :param runway: Required. The name/number/approach direction identifying
     the runway
    :type runway: str
    :param visibility_primary: The primary runway visibility distance in feet.
     If a variable range is set, this value describes the
     minimum visibility distance in a visual range
    :type visibility_primary: float
    :param visibility_primary_qualifier: A qualifier describing the primary
     visibility distance. Possible values include: 'equal', 'greaterThan',
     'lessThan'
    :type visibility_primary_qualifier: str or ~emsapi.models.enum
    :param visibility_variable: The variable runway visibility distance in
     feet, describing the maximum visibility distance in the
     visual range
    :type visibility_variable: float
    :param visibility_variable_qualifier: A qualifier describing the variable
     visibility distance. Possible values include: 'equal', 'greaterThan',
     'lessThan'
    :type visibility_variable_qualifier: str or ~emsapi.models.enum
    :param trend: The trend of the runway visibility distance. Possible values
     include: 'unknown', 'noChange', 'increasing', 'decreasing'
    :type trend: str or ~emsapi.models.enum
    """

    _validation = {
        'runway': {'required': True},
    }

    _attribute_map = {
        'runway': {'key': 'runway', 'type': 'str'},
        'visibility_primary': {'key': 'visibilityPrimary', 'type': 'float'},
        'visibility_primary_qualifier': {'key': 'visibilityPrimaryQualifier', 'type': 'str'},
        'visibility_variable': {'key': 'visibilityVariable', 'type': 'float'},
        'visibility_variable_qualifier': {'key': 'visibilityVariableQualifier', 'type': 'str'},
        'trend': {'key': 'trend', 'type': 'str'},
    }

    def __init__(self, *, runway: str, visibility_primary: float=None, visibility_primary_qualifier=None, visibility_variable: float=None, visibility_variable_qualifier=None, trend=None, **kwargs) -> None:
        super(AdiEmsWebApiV2DtoWeatherMetarRunwayVisualRange, self).__init__(**kwargs)
        self.runway = runway
        self.visibility_primary = visibility_primary
        self.visibility_primary_qualifier = visibility_primary_qualifier
        self.visibility_variable = visibility_variable
        self.visibility_variable_qualifier = visibility_variable_qualifier
        self.trend = trend
