# coding=utf-8
# --------------------------------------------------------------------------
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class AdiEmsWebApiV2DtoUploadUploadRequest(Model):
    """Encapsulates information that will be returned when beginning a new data
    ingestion transfer.

    :param name: The name of the transfer; this is not necessarily unique, and
     is just what the user passed
     when they initiated the transfer.
    :type name: str
    :param type: The type of the upload; this is the handler that we will use
     to process the uploaded data.
     The format of the data will be determined by what this upload type is.
     Possible values include: 'emsCollectionZipped', 'testTransfer',
     'emsCollectionRaw'
    :type type: str or ~emsapi.models.enum
    :param password: The password the data is encrypted with, if any. This
     point of the encryption possibility
     is that this may be part of a store-and-forward system that stores the
     data encrypted locally.
     (Thus passing it here along with the data is not particularly a security
     issue, but rather
     a way to avoid having to decrypt it as it transfers.)
     Note: This is not currently supported with any of the UploadTypes but may
     be in the future.
    :type password: str
    :param total_size: The total size of the data to be transferred. This may
     be absent in the case where the upload
     is being streamed and the total size is unknown. If provided this allows
     you to skip making a
     Finish call to the API to explicitly finish the transfer. Instead a Finish
     will be inferred
     when sufficient bytes have been sent.
    :type total_size: long
    :param metadata: Arbitrary metadata attached to the transfer record. This
     may be used by post-processing later
     or for other uses. If this is one of the EMS Collection UploadTypes then
     this information will
     be added to the generated ident.xml.
    :type metadata: dict[str, str]
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'password': {'key': 'password', 'type': 'str'},
        'total_size': {'key': 'totalSize', 'type': 'long'},
        'metadata': {'key': 'metadata', 'type': '{str}'},
    }

    def __init__(self, *, name: str=None, type=None, password: str=None, total_size: int=None, metadata=None, **kwargs) -> None:
        super(AdiEmsWebApiV2DtoUploadUploadRequest, self).__init__(**kwargs)
        self.name = name
        self.type = type
        self.password = password
        self.total_size = total_size
        self.metadata = metadata
