# coding=utf-8
# --------------------------------------------------------------------------
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class AdiEmsWebApiV2DtoUploadUploadRecord(Model):
    """Represents one record in the list of uploads that we know about on the
    server side.

    :param id: The transfer ID of the transfer, set by the server when the
     transfer started
    :type id: str
    :param type: The type of the upload. Possible values include:
     'emsCollectionZipped', 'testTransfer', 'emsCollectionRaw'
    :type type: str or ~emsapi.models.enum
    :param name: Name field set by the client when the transfer started
    :type name: str
    :param current_count: The current number of bytes transferred
    :type current_count: long
    :param total_size: The total size of the transfer, if known
    :type total_size: long
    :param last_transfer: The timestamp of the last time someone uploaded
     bytes to this transfer. This will
     be used to determine when a transfer can be aborted automatically
    :type last_transfer: datetime
    :param last_processing: The timestamp of the last time someone tried to
     process this transfer. This will
     be used to determine when a transfer can be aborted automatically
    :type last_processing: datetime
    :param start_time: The start time of the transfer, from when the initial
     start request is made
    :type start_time: datetime
    :param transfer_finish_time: The finish time of the actual data transfer
     portion of the process
    :type transfer_finish_time: datetime
    :param processing_finish_time: The finish time of the processing portion
     of the process
    :type processing_finish_time: datetime
    :param state: The state of the upload, up to and including EMS hand-off.
     Possible values include: 'transferring', 'waitingProcessing',
     'processing', 'processedSuccess', 'processedFailure', 'abandonedTransfer',
     'abandonedProcessing', 'canceled'
    :type state: str or ~emsapi.models.enum
    :param metadata: Metadata for the upload; this is somewhat arbitrary and
     specific to the type
     of the transfer, but in any event, it will be a JSON blob with key/value
     pairs
    :type metadata: dict[str, str]
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'current_count': {'key': 'currentCount', 'type': 'long'},
        'total_size': {'key': 'totalSize', 'type': 'long'},
        'last_transfer': {'key': 'lastTransfer', 'type': 'iso-8601'},
        'last_processing': {'key': 'lastProcessing', 'type': 'iso-8601'},
        'start_time': {'key': 'startTime', 'type': 'iso-8601'},
        'transfer_finish_time': {'key': 'transferFinishTime', 'type': 'iso-8601'},
        'processing_finish_time': {'key': 'processingFinishTime', 'type': 'iso-8601'},
        'state': {'key': 'state', 'type': 'str'},
        'metadata': {'key': 'metadata', 'type': '{str}'},
    }

    def __init__(self, *, id: str=None, type=None, name: str=None, current_count: int=None, total_size: int=None, last_transfer=None, last_processing=None, start_time=None, transfer_finish_time=None, processing_finish_time=None, state=None, metadata=None, **kwargs) -> None:
        super(AdiEmsWebApiV2DtoUploadUploadRecord, self).__init__(**kwargs)
        self.id = id
        self.type = type
        self.name = name
        self.current_count = current_count
        self.total_size = total_size
        self.last_transfer = last_transfer
        self.last_processing = last_processing
        self.start_time = start_time
        self.transfer_finish_time = transfer_finish_time
        self.processing_finish_time = processing_finish_time
        self.state = state
        self.metadata = metadata
