#
# Lockstep Platform SDK for Python
#
# (c) 2021-2022 Lockstep, Inc.
#
# For the full copyright and license information, please view the LICENSE
# file that was distributed with this source code.
#
# @author     Lockstep Network <support@lockstep.io>
# @copyright  2021-2022 Lockstep, Inc.
# @link       https://github.com/Lockstep-Network/lockstep-sdk-python
#


from dataclasses import dataclass
from lockstep.models.paymentappliedmodel import PaymentAppliedModel
from lockstep.models.notemodel import NoteModel
from lockstep.models.attachmentmodel import AttachmentModel
from lockstep.models.customfielddefinitionmodel import CustomFieldDefinitionModel
from lockstep.models.customfieldvaluemodel import CustomFieldValueModel

@dataclass
class PaymentModel:
    """
    A Payment represents money sent from one company to another. A
    single payment may contain payments for one or more invoices; it is
    also possible for payments to be made in advance of an invoice, for
    example, as a deposit. The creator of the Payment is identified by
    the `CustomerId` field, and the recipient of the Payment is
    identified by the `CompanyId` field. Most Payments are uniquely
    identified both by a Lockstep Platform ID number and a customer ERP
    "key" that was generated by the system that originated the Payment.
    Payments that have not been fully applied have a nonzero
    `UnappliedAmount` value, which represents a deposit that has been
    paid and not yet applied to an Invoice.
    """

    groupKey: str | None = None
    paymentId: str | None = None
    companyId: str | None = None
    erpKey: str | None = None
    paymentType: str | None = None
    tenderType: str | None = None
    isOpen: bool | None = None
    memoText: str | None = None
    paymentDate: str | None = None
    postDate: str | None = None
    paymentAmount: float | None = None
    unappliedAmount: float | None = None
    currencyCode: str | None = None
    referenceCode: str | None = None
    created: str | None = None
    createdUserId: str | None = None
    modified: str | None = None
    modifiedUserId: str | None = None
    appEnrollmentId: str | None = None
    isVoided: bool | None = None
    inDispute: bool | None = None
    applications: list[PaymentAppliedModel] | None = None
    notes: list[NoteModel] | None = None
    attachments: list[AttachmentModel] | None = None
    customFieldDefinitions: list[CustomFieldDefinitionModel] | None = None
    customFieldValues: list[CustomFieldValueModel] | None = None

