#
# Lockstep Platform SDK for Python
#
# (c) 2021-2022 Lockstep, Inc.
#
# For the full copyright and license information, please view the LICENSE
# file that was distributed with this source code.
#
# @author     Lockstep Network <support@lockstep.io>
# @copyright  2021-2022 Lockstep, Inc.
# @link       https://github.com/Lockstep-Network/lockstep-sdk-python
#


from dataclasses import dataclass

@dataclass
class ConnectorInfoModel:
    """
    Represents all possible data required to set up an app enrollment
    for a connector. Only send required fields for the given connector.
    """

    authCode: str | None = None
    realmId: str | None = None
    redirectUri: str | None = None
    email: str | None = None
    username: str | None = None
    password: str | None = None
    serverName: str | None = None
    serverPort: int | None = None

