#!/usr/bin/env python
# -*- coding: utf-8 -*-

from jinja2 import Template

###############################################################################


CONFIG_ENV_VAR_NAME = "WORKFLOW_CONFIG"
CWD_CONFIG_FILE_NAME = "workflow_config.json"

DEFAULT_QUILT_STORAGE = "s3://allencell-internal-quilt"
DEFAULT_QUILT_PACKAGE_OWNER = "aics"
DEFAULT_PROJECT_LOCAL_STAGING_DIR = "{cwd}/local_staging"
DEFAULT_STEP_LOCAL_STAGING_DIR = "/".join(
    [DEFAULT_PROJECT_LOCAL_STAGING_DIR, "{module_name}"]
)

###############################################################################


# This is decently GitHub centric...
README_TEMPLATE = Template(
    """# {{ quilt_package_name }}

[Project Repo]({{ source_url }})

[Active Branch]({{ source_url }}/tree/{{ branch_name }})

[Code Changes for Commit: {{ commit_hash }}]({{ source_url }}/commit/{{ commit_hash }})

Version Generated by: {{ creator }}
"""
)  # noqa: F501
