"""Generated by Django 4.1 on 2022-08-13 19:52."""

import os
import shutil

from pathlib import Path

from django.db import migrations, models

import codex.models


CONFIG_PATH = Path(os.environ.get("CODEX_CONFIG_DIR", Path.cwd() / "config"))
COVER_ROOT = CONFIG_PATH / "cache" / "covers"


def clear_covers(_apps, _schema_editor):
    """Remove old covers."""
    shutil.rmtree(COVER_ROOT, ignore_errors=True)


def remove_null_librarian_statuses(apps, _schema_editor):
    """Remove all librarian statuses."""
    ls_model = apps.get_model("codex", "librarianstatus")
    ls_model.objects.all().delete()


class Migration(migrations.Migration):
    """Choices and max_length changes, mostly."""

    dependencies = [
        ("codex", "0016_remove_comic_cover_path_librarianstatus"),
    ]

    operations = [
        migrations.RunPython(clear_covers),
        migrations.RunPython(remove_null_librarian_statuses),
        migrations.AlterModelOptions(
            name="timestamp",
            options={},
        ),
        migrations.AlterField(
            model_name="adminflag",
            name="name",
            field=models.CharField(db_index=True, max_length=128),
        ),
        migrations.AlterField(
            model_name="character",
            name="name",
            field=models.CharField(db_index=True, max_length=128),
        ),
        migrations.AlterField(
            model_name="comic",
            name="file_format",
            field=models.CharField(
                choices=[("comic", "Comic"), ("pdf", "Pdf")],
                default="comic",
                max_length=5,
            ),
        ),
        migrations.AlterField(
            model_name="comic",
            name="format",
            field=models.CharField(db_index=True, max_length=32, null=True),
        ),
        migrations.AlterField(
            model_name="comic",
            name="name",
            field=models.CharField(db_index=True, default="", max_length=128),
        ),
        migrations.AlterField(
            model_name="creditperson",
            name="name",
            field=models.CharField(db_index=True, max_length=128),
        ),
        migrations.AlterField(
            model_name="creditrole",
            name="name",
            field=models.CharField(db_index=True, max_length=128),
        ),
        migrations.AlterField(
            model_name="failedimport",
            name="name",
            field=models.CharField(db_index=True, default="", max_length=128),
        ),
        migrations.AlterField(
            model_name="folder",
            name="name",
            field=models.CharField(db_index=True, default="", max_length=128),
        ),
        migrations.AlterField(
            model_name="genre",
            name="name",
            field=models.CharField(db_index=True, max_length=128),
        ),
        migrations.AlterField(
            model_name="imprint",
            name="name",
            field=models.CharField(db_index=True, default="", max_length=128),
        ),
        migrations.AlterField(
            model_name="librarianstatus",
            name="name",
            field=models.CharField(db_index=True, max_length=128),
        ),
        migrations.AlterField(
            model_name="librarianstatus",
            name="type",
            field=models.CharField(db_index=True, max_length=32),
        ),
        migrations.AlterField(
            model_name="librarianstatus",
            name="active",
            field=models.DateTimeField(default=None, null=True),
        ),
        migrations.AlterField(
            model_name="librarianstatus",
            name="total",
            field=models.PositiveSmallIntegerField(default=0),
        ),
        migrations.AddField(
            model_name="librarianstatus",
            name="preactive",
            field=models.BooleanField(default=False),
        ),
        migrations.AlterField(
            model_name="library",
            name="path",
            field=models.CharField(
                db_index=True,
                max_length=4095,
                unique=True,
                validators=[codex.models.validate_dir_exists],
            ),
        ),
        migrations.AlterField(
            model_name="location",
            name="name",
            field=models.CharField(db_index=True, max_length=128),
        ),
        migrations.AlterField(
            model_name="publisher",
            name="name",
            field=models.CharField(db_index=True, default="", max_length=128),
        ),
        migrations.AlterField(
            model_name="series",
            name="name",
            field=models.CharField(db_index=True, default="", max_length=128),
        ),
        migrations.AlterField(
            model_name="seriesgroup",
            name="name",
            field=models.CharField(db_index=True, max_length=128),
        ),
        migrations.AlterField(
            model_name="storyarc",
            name="name",
            field=models.CharField(db_index=True, max_length=128),
        ),
        migrations.AlterField(
            model_name="tag",
            name="name",
            field=models.CharField(db_index=True, max_length=128),
        ),
        migrations.AlterField(
            model_name="team",
            name="name",
            field=models.CharField(db_index=True, max_length=128),
        ),
        migrations.AlterField(
            model_name="timestamp",
            name="name",
            field=models.CharField(db_index=True, max_length=128),
        ),
        migrations.AlterField(
            model_name="volume",
            name="name",
            field=models.CharField(db_index=True, default="", max_length=128),
        ),
        migrations.AlterUniqueTogether(
            name="timestamp",
            unique_together={("name",)},
        ),
    ]
