# Contributing to `easyaccess`


When contributing to this repository, please first discuss the change you wish to make via [issues](https://github.com/des-labs/easyaccess/issues),
[DES help request form](https://des.ncsa.illinois.edu/help), or any other method with the owners of this repository before making a change.

Please note we have a [code of conduct](CODE_OF_CONDUCT.md) for this project, please follow it in all your interactions with the project.

## Reporting Bugs

When creating a bug or an issue please include as many details as possible. Create your issues [here](https://github.com/des-labs/easyaccess/issues) and follow this steps:

- Search the [current issues page](https://github.com/des-labs/easyaccess/issues) **and the [old easyaccess repo issues](https://github.com/mgckind/easyaccess/issues) (include both open and closed issues)** or our FAQ for a list of common questions or previously solved problems
- Use a clear and descriptive title for the issue to identify the problem.
- Provide all information about OS
- Provide information about the installation process (source, pip, conda, Docker, etc)
- software version including Python
- Detailed information on how to reproduce the problem
- Provide screenshots when useful

## Other contributions

All kind of contributions are welcome, from fixing bugs, resolving issues or suggesting features. Look at the [current issues](https://github.com/des-labs/easyaccess/issues) to see how you can contribute and provide help.

## Pull Request Process

1. Ensure any install or build dependencies are removed before the end of the layer when doing a
   build.
2. Update the README.md with details of changes to the interface, this includes new environment
   variables, exposed ports, useful file locations and container parameters.
3. Increase the version numbers in any examples files and the README.md to the new version that this
   Pull Request would represent. The versioning scheme we use is [SemVer](http://semver.org/).
4. You may merge the Pull Request in once you have the sign-off of two other developers, or if you
   do not have permission to do that, you may request the second reviewer to merge it for you.

## Authors

Please see our [list of contributors](AUTHORS.md), if you feel you have contributed to the project and we have neglected adding you to the list please accept our apologizes and [let us know](https://des.ncsa.illinois.edu/help) to correct it.


