import secrets
import string
from pathlib import Path

import pytest


@pytest.fixture(scope="session")
def test_account_jwt():

    # TODO: env variable
    tmp_token = "eyJhbGciOiJSUzI1NiIsInR5cCI6IkpXVCIsImtpZCI6IlNMdVluMm1jTDN5UXByWjRRQ0pMdiJ9.eyJnaXZlbl9uYW1lIjoiS2VubnkiLCJmYW1pbHlfbmFtZSI6IldvcmttYW4iLCJuaWNrbmFtZSI6Imtlbm55IiwibmFtZSI6Iktlbm55IFdvcmttYW4iLCJwaWN0dXJlIjoiaHR0cHM6Ly9saDMuZ29vZ2xldXNlcmNvbnRlbnQuY29tL2EtL0FPaDE0R2pPVDAzUVBMQkNiUXdaQTlpc3hOMTc3aGg5OUIxZm5Fb0txR0hOamNRSG4xTTRENWE2S2pTT1ctX0VBdXIyWFkxQVc3ODNmVklCUEpCc1FYRjB4UkRkZEFQcmtYUE1MOU0wRmVINm9TU3o5cG1jRElLcW1waVN5YWF1RFpudUd2NjBaaXAycC0yM21YNWpqSzhzWjdqU3hYbUlLV0k2UkxJVXNkR2c2dVNWa2p2dmJYUnI3NXplQkJFZm1jUG53UzNLdlNVTkdwX2hwR0NwQ3Q5aXc4MHZVUlM4NWJmakFuY245Q0RMajNlb3lCMUUxZ01VZjhzcWxEaEhUVEVqNExKSFlJd3hjOFBpdWtWakpXbzd4OTFSQTdVRE1FMXNVeXhfQlNnakNVWGcyS0VkdFFaOEl6Njlsc2V3ckNZWDBvbEhPeURnUTcwMzloX2lmd241NzdkTVpuLXZ5aG1DUkpldUNrT1NiYlBiMW1MQ2hpMU1zNXVNY0dRXzVTZm5zbjAtZndGOW9GME01Z3dVMkVnZ2MtTjNfR0xZOHl0dUJ0dG5zcE5wbnFwd0JGWnNRMnRLV1pJZnZCSEk5b2w2NkVDaFFxZTQ1b3JjY0pkbXA2LXZpQnFrTlllUGYyWk9BdkRNNU9velZ5aGdXMFZ5dGFGeUQxUVJnLWhTUDg0a3lKRUpqekQ0bkY4RXpqbEx2RHhwUkV3Z25vUklybjFwTjJ1eUM3U3lxUjFncWJKOXVVNFB5MFBRRFVlV1RyTG9CVFhGWjYzdERac05LUUpYSHVESEV1T05pc1pucjdKazJBeHlQU2otQnk2X3dWMDA5Nm1HUGF1QzltbXpwZUk0LV9FRktEX3pYcER4cGJNRnJ4dnh3TkpFdXIxX0VoLWJTMzU1cW92b2ZsT0tzcjRFaXZWX1B1MGJmUkNHcUdta2lKRWVLSFZ6bUVnVmltX3ZkVUR5T01MYmNDOWFqQTE5eUtDcmRoSUxhb1Q4ZHpSYS1INFNyWjJzZVdsUjJPWTBDbVl1a2c9czk2LWMiLCJsb2NhbGUiOiJlbiIsInVwZGF0ZWRfYXQiOiIyMDIyLTAyLTE1VDIyOjI0OjIxLjk1MloiLCJlbWFpbCI6Imtlbm55QGxhdGNoLmJpbyIsImVtYWlsX3ZlcmlmaWVkIjp0cnVlLCJpc3MiOiJodHRwczovL2xhdGNoYWkudXMuYXV0aDAuY29tLyIsInN1YiI6Imdvb2dsZS1vYXV0aDJ8MTA1MDg3OTM4NjkzMDUwODkxMDI0IiwiYXVkIjoianpGQk9oSWJmcDRFUFJZWjh3bXg0WXl2TDI3TEZEZUIiLCJpYXQiOjE2NDU1MDAyMTQsImV4cCI6MTY0NTUzNjIxNH0.grRO5nkw4B-Tk7RcO3LusC9n0r5Bw65YA6h3Km8CmUspUmL2GfrDdhb3pqF7uGqc475CEZADRMNpm7vUuOWKUSWH9ezHtx2bAoKOpnU5jfdVwGLHE8LgaMzITFXDc7hX1aFAZTKuVnh7zrBnK5e6opejKqtninJPFAD0utwtxObdqKglN5RQUfzVCM2y6d-va4_uU9NkHErqaDGbUhixrSbtUqWrNikRGs8cp8k_h4Ow2pZdWoXXDsvvNMVXk9NS4Rrl5Xfpfkn11rwYLjWMreMX6MPIhQeZZJdHX89TbTuKF59WT-FzSmMRVjTvaXeoiZXdYrGBI_THIAIxERdASw"
    token_dir = Path.home().joinpath(".latch")
    token_dir.mkdir(exist_ok=True)
    token_file = token_dir.joinpath("token")
    with open(token_file, "w") as f:
        f.write(tmp_token)

    return tmp_token


@pytest.fixture(scope="session")
def project_name():
    alphabet = string.ascii_letters
    return "".join(secrets.choice(alphabet) for i in range(8)).lower()
