# v0.2.0 migration guide

Version 0.2.0 of magicgui was a complete rewrite that introduced a couple
breaking API changes

## `.Gui()` attribute removed

Before `v0.2.0`, the {func}`~magicgui.magicgui` decorator added a `Gui` attribute to
the decorated function that was to be called to instantiate a widget.  In `v0.2.0`
the object returned from the {func}`~magicgui.magicgui` decorator is already an
instantiated {class}`~magicgui.widgets._bases.Widget`.

````{admonition} **Old Method 👎**
:class: danger

```python
from magicgui import magicgui, event_loop

@magicgui
def function(x, y):
    ...

with event_loop():
    gui = function.Gui(show=True)
```

````

````{admonition} **New Method 👍**
:class: tip

```python
from magicgui import magicgui

@magicgui
def function(x, y):
    ...

function.show(run=True)
```

````

## New base widget type

Before `v0.2.0`, the `Gui()` object returned by the {func}`~magicgui.magicgui`
decorator was a `MagicGuiBase` widget class, which in turn was a *direct
subclass* of a backend widget, such as a
[`QtWidgets.QWidget`](https://doc.qt.io/qt-5/qwidget.html).  In `v0.2.0`, all
widgets derive from [magicgui.widgets.Widget](magicgui.widgets._bases.Widget),
and the *backend* is available at `widget.native`.  If you are incorporating
magicgui widgets into a larger Qt-based GUI, please note that you will want
to use `widget.native` instead of `widget`

````{tip}

```python
from magicgui import magicgui, use_app

use_app('qt')

@magicgui
def function(x, y):
    ...
```

```python
>>> print(type(function))
<class 'magicgui.function_gui.FunctionGui'>
>>> print(type(function.native))
<class 'PyQt5.QtWidgets.QWidget'>
```
````

## Starting the application

It is now easier to show a widget and start an application by calling
`widget.show(run=True)`. Calling `show(run=True)` will *immediately* block
execution of your script and show the widget.  If you wanted to (for instance)
show *multiple* widgets next to each other, then you would still want to use the
`event_loop` context manager:

````{tip}

```python
from magicgui import magicgui, event_loop

@magicgui
def function_a(x=1, y=3):
    ...

@magicgui
def function_b(z='asdf'):
    ...

with event_loop():
    function_a.show()
    function_b.show()
# both widgets will show (though b may be on top of a)
```

````

## Getting and setting values

To get or set the value of a widget programmatically, you no
longer set the corresponding widget attribute directly, but rather
use the `widget.value` attribute:

````{admonition} **Old Method 👎**
:class: danger

> `gui.x` used to be a [descriptor](https://docs.python.org/3/glossary.html#term-descriptor)
> object to get/set the value, but the actual underlying widget was at `gui.x_widget`

```python
gui = function.Gui()
gui.x = 10
```
````

````{admonition} **New Method 👍**
:class: tip

> now `function.x` IS the widget, and you set its value with `function.x.value`

```python
function.x.value = 10
```
````

## Connecting callbacks to events

When binding callbacks to change events, you no longer connect to
`gui.<name>_changed`, you now connect to `function.<name>.changed`:

````{admonition} **Old Method 👎**
:class: danger
```python
gui = function.Gui()
gui.x_changed.connect(my_callback)
```
````

````{admonition} **New Method 👍**
:class: tip

```python
function.x.changed.connect(my_callback)
```
````

## Renamed

- `Widget.refresh_choices` has been renamed to `Widget.reset_choices`.

- `@magicgui(result=True)` has been renamed to `@magicgui(result_widget=True)`
