# AUTOGENERATED FILE! PLEASE DON'T EDIT
"""
This module is for color formats, units and whatnot. This is exposed
automatically with::

   from k1lib.imports import *
   fmt.txt # exposed
"""
import k1lib, math; from k1lib import cli
from typing import Dict, Iterator, Tuple
__all__ = ["generic", "metricPrefixes", "size", "sizeOf",
           "comp", "compRate", "time", "item", "throughput", "txt"]
k1lib.settings.add("fmt", k1lib.Settings().add("separator", True, "whether to have a space between the number and the unit"), "from k1lib.fmt module");
settings = k1lib.settings.fmt
metricPrefixes = {-8:"y",-7:"z",-6:"a",-5:"f",-4:"p",-3:"n",-2:"u",-1:"m",0:"",1:"k",2:"M",3:"G",4:"T",5:"P",6:"E",7:"Z",8:"Y"}
#metricPrefixes = ["", "k", "M", "G", "T", "P", "E", "Z", "Y"]
def generic(x, units:Dict[int, str]):
    c = " " if settings.separator else ""
    for i, unit in units.items():
        upperBound = 1000 * 1000**i
        if abs(x) < upperBound:
            return f"{round(1e3*x/upperBound, 2)}{c}{unit}"
    return (f"{round(1e3*x/upperBound, 2)}{c}{unit}").strip()
sizes = {i: f"{p}B" for i, p in metricPrefixes.items() if i >= 0}; #sizes[0] = "bytes"
def size(_bytes=0):
    """Formats disk size.
Example::

    # returns "50.0 bytes"
    fmt.size(50)
    # returns "12.0 MB"
    fmt.size(1.2e7)
"""
    return generic(_bytes, sizes)
def sizeOf(l:Iterator[float]) -> Tuple[str, Iterator[float]]:
    """Figures out appropriate scale, scales back the Iterator, and return both.
Example::

    x = torch.abs(torch.randn(2)) * 1e4 + 1e5
    label, t = fmt.sizeOf(x) # label is "kB"
    (t | toTensor()).min() # min value should be close to 100"""
    l = list(l | cli.apply(lambda n: abs(n)))
    v = l | cli.toMax()
    v = math.log10(v) if v > 0 else -math.log10(-v)
    idx = math.floor(v/3)
    coef = 1.0/1000**idx
    return sizes[idx], l | cli.apply(lambda x: x * coef) | cli.deref()
computations = {i: f"{p}FLOPs" for i, p in metricPrefixes.items() if i >= 0}
def comp(flop=0):
    """Formats computation amount.
Example::

    # returns "50.0 FLOPs"
    fmt.computation(50)
    # returns "50.0 MFLOPs"
    fmt.computation(5e7)
"""
    return generic(flop, computations)
computationRates = {i: f"{p}FLOPS" for i, p in metricPrefixes.items() if i >= 0}
def compRate(flops=0):
    """Formats computation rate.
Example::

    # returns "50.0 FLOPS"
    fmt.computationRate(50)
    # returns "50.0 MFLOPS"
    fmt.computationRate(5e7)
"""
    return generic(flops, computationRates)
times = {i:f"{p}s" for i, p in metricPrefixes.items() if i <= 0}
def time(seconds=0):
    """Formats small times.
Example::

    fmt.time(50) # returns "50.0 s"
    fmt.time(4000) # returns "4000.0 s"
    fmt.time(0.02) # returns "20.0 ms"
    fmt.time(1e-5) # returns "10.0 us"
"""
    return generic(seconds, times)
items = {0: "", 1: "k", 2: "M", 3: "B", 4: "T"}
def item(n=0):
    """Formats generic item.
Example::

    # returns "50.0"
    fmt.item(50)
    # returns "500.0 k"
    fmt.item(5e5)
"""
    return generic(n, items).strip()
def throughput(n, unit=""):
    """Formats item throughput.
Example::

    # returns "3.16/year"
    fmt.throughput(1e-7)
    # returns "2.63/month"
    fmt.throughput(1e-6)
    # returns "3.6/hour"
    fmt.throughput(1e-3)
    # returns "100.0 k/s"
    throughput(1e5)
    
    # returns "100.0 k epochs/s"
    throughput(1e5, " epochs")

:param n: items per second
:param unit: optional item unit"""
    if n < 10/(365.25*86400): return item(n*(365.25*86400)) + f"{unit}/year"
    if n < 10/(30.4375*86400): return item(n*(30.4375*86400)) + f"{unit}/month"
    if n < 10/86400: return item(n*86400) + f"{unit}/day"
    if n < 10/3600: return item(n*3600) + f"{unit}/hour"
    if n < 10/60: return item(n*60) + f"{unit}/minute"
    return item(n) + f"{unit}/s"
_esc = '\033['
_end = f'{_esc}0m'
class txt:
    """Text formatting.
Example::

    # will print out red text
    print(fmt.txt.red("some text"))"""
    @staticmethod
    def darkcyan(s:str):  return f"{_esc}36m{s}{_end}"
    @staticmethod
    def red(s:str):       return f"{_esc}91m{s}{_end}"
    @staticmethod
    def green(s:str):     return f"{_esc}92m{s}{_end}"
    @staticmethod
    def yellow(s:str):    return f"{_esc}93m{s}{_end}"
    @staticmethod
    def blue(s:str):      return f"{_esc}94m{s}{_end}"
    @staticmethod
    def purple(s:str):    return f"{_esc}95m{s}{_end}"
    @staticmethod
    def cyan(s:str):      return f"{_esc}96m{s}{_end}"
    @staticmethod
    def bold(s:str):      return f"{_esc}1m{s}{_end}"
    @staticmethod
    def grey(s:str):      return f"{_esc}38;2;150;150;150m{s}{_end}"
    @staticmethod
    def darkgrey(s:str):  return f"{_esc}38;2;100;100;100m{s}{_end}"
    @staticmethod
    def underline(s:str): return f"{_esc}4m{s}{_end}"
    @staticmethod
    def identity(s:str):  return f"{s}"