# AUTOGENERATED FILE! PLEASE DON'T EDIT
import k1lib, time; from k1lib import fmt
from .callbacks import Callback, Callbacks, Cbs
__all__ = ["ProgressBar"]
@k1lib.patch(Cbs)
class ProgressBar(Callback):
    """Displays the current progress, epoch and batch while running.
Deposits variables into :class:`~k1lib.Learner` at checkpoint ``startBatch``:

- progress: single float from 0 to 1, guaranteed to increase monotonically
- epochThroughput
- remaining: estimated remaining time. Does not take into account callbacks that can potentially cancel the run prematurely"""
    def startRun(self):
        self.startTime = time.time(); self.step = 0; self.l.progress = 0
        self.l.loss = float("inf") # to make sure this variable exist
        self.aL = self.bL = self.cL = self.dL = self.eL = 0
    def startBatch(self):
        batch = self.l.batch; batches = self.l.batches; epoch = self.l.epoch; epochs = self.l.epochs
        elapsedTime = self.elapsedTime = time.time() - self.startTime
        if batches is None: progress = self.l.progress = epoch / epochs
        else: progress = self.l.progress = (batch / batches + epoch) / epochs
        epochTh = self.l.epochThroughput = epochs * progress / elapsedTime
        remaining = self.l.remaining = round(elapsedTime / (progress+1e-7) * (1-progress), 2) if progress > 0 else float('inf')
        
        a = str(round(100 * progress)); self.aL = max(self.aL, len(a)); a = a.rjust(self.aL)
        b = f"{epoch}/{epochs} ({fmt.throughput(epochTh, ' epochs')})"; self.bL = max(self.bL, len(b)); b = b.rjust(self.bL)
        c = f"{batch}/{batches}".rjust(k1lib.numDigits(batches) * 2 + 1); self.cL = max(self.cL, len(c)); c = c.rjust(self.cL)
        d = f"{round(elapsedTime, 2)}".rjust(6); self.dL = max(self.dL, len(d)); d = d.rjust(self.dL)
        e = f"{remaining}"; self.eL = max(self.eL, len(e)); e = e.rjust(self.eL)
        print(f"\rProgress: {a}%, epoch: {b}, batch: {c}, elapsed: {d}s, remaining: {e}s, loss: {self.l.loss}             ", end="")