# AUTOGENERATED FILE! PLEASE DON'T EDIT
from .atom import Atom, mo, _a
from functools import partial
from typing import List
import k1lib, re
__all__ = ["alkane", "alcohol", "sameEmpirical"]
def _mole(name, f):
    _a[name] = f; mo.registerSubstance(name, f)
_mole("H2O", lambda: mo.O(mo.H)(mo.H))
_mole("CH4", lambda: mo.C(mo.H)(mo.H)(mo.H)(mo.H))
_mole("COOH", lambda: mo.C(mo.O, 2)(mo.O(mo.H))(mo.H))
_mole("NH3", lambda: mo.N(mo.H)(mo.H)(mo.H))
_mole("CH3OH", lambda: mo.CH4(mo.H2O))
def glucose():
    o = mo.O
    o.bond(mo.CH4).bond(mo.CH3OH).bond(mo.CH3OH).bond(mo.CH3OH).bond(mo.CH3OH).bond(o)
    o.next().bond(mo.CH3OH); return o
_mole("glucose", glucose)
def cyclohexane():
    c = mo.CH4
    return c.bond(mo.CH4).bond(mo.CH4).bond(mo.CH4).bond(mo.CH4).bond(mo.CH4).bond(c)
_mole("cyclohexane", cyclohexane)
def benzene():
    c = mo.CH4
    return c.main(mo.CH4, 2).main(mo.CH4).main(mo.CH4, 2).main(mo.CH4).main(mo.CH4, 2).main(c)
_mole("benzene", benzene)
def adenine():
    n = mo.NH3
    c1 = n.bond(mo.CH4).bond(mo.NH3, 2).bond(mo.CH4)
    c2 = c1.bond(mo.CH4, 2); c2.bond(n)
    c1.bond(mo.CH4)(mo.NH3).bond(mo.NH3, 2).bond(mo.CH4).bond(mo.NH3, 2).bond(c2);
    return n
_mole("adenine", adenine)
def ribose():
    o = mo.H2O
    return o.bond(mo.CH4(mo.CH3OH)).main(mo.CH3OH).main(mo.CH3OH).main(mo.CH3OH).main(o)
_mole("ribose", ribose)
def adenosine(): ri = mo.ribose; ri.next(1)(mo.adenine); return ri
_mole("adenosine", adenosine)
def alkane(n:int) -> Atom:
    """Creates an alkane with ``n`` carbons.
Example::

    # returns "C3H8"
    mo.alkane(3).empirical()"""
    answer = mo.CH4
    for i in range(n-1): answer = answer.bond(mo.CH4)
    return answer
def alcohol(n:int, loc:int=1) -> Atom:
    """Creates an alcohol with ``n`` carbons and an OH group at carbon ``loc``.
Example::

    # returns "C3H8O"
    mo.alcohol(3, 1).empirical()"""
    a = alkane(n)
    a.next(times=loc-1)(mo.H2O)
    return a
@k1lib.patch(Atom)
def perfluoro_ize(mainA:Atom) -> Atom:
    """Replaces all C-H bonds with C-F bonds"""
    for a in mainA.atoms():
        b = a.next()
        if a.name == "H" and b.name == "C":
            a.removeBond(b); b(mo.F)
    return mainA
empC = re.compile("[A-Z][a-z]*[0-9]*")
def sameEmpirical(a:str, b:str) -> bool:
    """Checks whether 2 empirical formula are the same or not.
Example::

    moparse.sameEmpirical("C2H4", "H4C2") # returns True"""
    return sorted(re.findall(empC, a)) == sorted(re.findall(empC, b))