"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (Object.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.SandDanceView = exports.SandDanceModel = void 0;
const base_1 = require("@jupyter-widgets/base");
const version_1 = require("./version");
const deck = __importStar(require("@deck.gl/core"));
const layers = __importStar(require("@deck.gl/layers"));
const luma = __importStar(require("@luma.gl/core"));
const fluentUIComponents_1 = require("./fluentUIComponents");
const vega = __importStar(require("vega"));
const sanddance_explorer_1 = require("@msrvida/sanddance-explorer");
const react_dom_1 = __importDefault(require("react-dom"));
const react_1 = __importDefault(require("react"));
require("@msrvida/sanddance-explorer/dist/css/sanddance-explorer.css");
require("../css/tweak.css");
sanddance_explorer_1.use(fluentUIComponents_1.fluentUI, react_1.default, react_dom_1.default, vega, deck, layers, luma);
let SandDanceModel = /** @class */ (() => {
    class SandDanceModel extends base_1.DOMWidgetModel {
        defaults() {
            return Object.assign(Object.assign({}, super.defaults()), { _model_name: SandDanceModel.model_name, _model_module: SandDanceModel.model_module, _model_module_version: SandDanceModel.model_module_version, _view_name: SandDanceModel.view_name, _view_module: SandDanceModel.view_module, _view_module_version: SandDanceModel.view_module_version, data: '[]', width: '100%', heigth: '640px', snapshots: [], pyversion: 'dev' });
        }
    }
    SandDanceModel.serializers = Object.assign({}, base_1.DOMWidgetModel.serializers);
    SandDanceModel.model_name = 'SandDanceModel';
    SandDanceModel.model_module = version_1.MODULE_NAME;
    SandDanceModel.model_module_version = version_1.MODULE_VERSION;
    SandDanceModel.view_name = 'SandDanceView';
    SandDanceModel.view_module = version_1.MODULE_NAME;
    SandDanceModel.view_module_version = version_1.MODULE_VERSION;
    return SandDanceModel;
})();
exports.SandDanceModel = SandDanceModel;
class SandDanceView extends base_1.DOMWidgetView {
    render() {
        const explorerProps = {
            logoClickUrl: 'https://microsoft.github.io/SandDance/',
            compactUI: true,
            mounted: (explorer) => {
                this.explorer = explorer;
                // restore previous snapshots
                const snapshots = this.model.get('snapshots');
                this.explorer.setState({ snapshots });
                this.model.on('change:data', this.data_changed, this);
                // TODO
                // avoid error
                // LAYER_TEXT-characters-program  Bad uniform project_uViewProjectionMatrix
                setTimeout(() => {
                    this.data_changed();
                }, 0);
            },
            snapshotProps: {
                getTopActions: (snapshots) => {
                    const items = [
                        {
                            key: 'saveAsWidgetState',
                            text: 'Save as Widget State',
                            disabled: snapshots.length === 0,
                            onClick: () => this.saveSnapshots(snapshots),
                        },
                    ];
                    return items;
                }
            },
            systemInfoChildren: [
                react_1.default.createElement("li", null, "SandDance (Python) version: ", this.model.get('pyversion')),
                react_1.default.createElement("li", null, "SandDance Jupyter Widget version: ", version_1.MODULE_VERSION)
            ]
        };
        this.wrapper = react_1.default.createElement('div', {
            style: {
                width: this.model.get('width'),
                height: this.model.get('height'),
            }
        }, [react_1.default.createElement(sanddance_explorer_1.Explorer, Object.assign(Object.assign({}, explorerProps), { key: 'explorer-key' }))]);
        react_dom_1.default.render(this.wrapper, this.el);
        this.model.on('change:width', this.size_changed, this);
        this.model.on('change:height', this.size_changed, this);
    }
    saveSnapshots(snapshots) {
        this.model.set('snapshots', snapshots);
        this.model.save_changes();
    }
    size_changed() {
        if (!this.wrapper) {
            return;
        }
        const style = {
            width: this.model.get('width'),
            height: this.model.get('height'),
        };
        this.wrapper.props.style = style;
    }
    data_changed() {
        if (!this.explorer) {
            return;
        }
        this.explorer.load(JSON.parse(this.model.get('data')));
    }
}
exports.SandDanceView = SandDanceView;
//# sourceMappingURL=widget.js.map