# Generated by Django 2.0.13 on 2021-02-21 17:39

import django.core.validators
from django.db import migrations, models
import django.db.models.deletion
import framework.models


class Migration(migrations.Migration):

    initial = True

    dependencies = [
    ]

    operations = [
        migrations.CreateModel(
            name='SvnPath',
            fields=[
                ('id', models.BigAutoField(primary_key=True, serialize=False)),
                ('_version', models.IntegerField(default=0, verbose_name='版本')),
                ('create_datetime', models.DateTimeField(auto_now_add=True, verbose_name='创建时间')),
                ('update_datetime', models.DateTimeField(auto_now=True, verbose_name='更新时间')),
                ('project_name', models.CharField(db_index=True, max_length=100, validators=[django.core.validators.RegexValidator('^[a-z][\\d\\w_]+$', '字母组合,符合^[a-z][\\d\\w_]+$')], verbose_name='项目名')),
                ('alias', models.CharField(blank=True, default='', max_length=200, verbose_name='项目别称')),
                ('path', models.CharField(db_index=True, max_length=200, verbose_name='svn 路径')),
                ('status', models.IntegerField(blank=True, choices=[(0, '开启'), (1, '关闭')], default=0, null=True, verbose_name='状态')),
                ('remark', models.CharField(blank=True, default='', max_length=500, verbose_name='备注')),
                ('read_member', framework.models.JSONField(blank=True, default='[]', verbose_name='可读成员')),
                ('write_member', framework.models.JSONField(blank=True, default='[]', verbose_name='可写成员')),
                ('other_permission', models.CharField(blank=True, choices=[('r', '只读'), ('w', '只写'), ('rw', '可读写'), ('no', '禁止访问')], default='no', max_length=2, verbose_name='其他访问权限')),
                ('parent', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.DO_NOTHING, to='svn_admin.SvnPath', verbose_name='上级路径')),
            ],
            options={
                'ordering': ['id'],
            },
            bases=(models.Model, framework.models.SqlModelMixin),
        ),
        migrations.AlterUniqueTogether(
            name='svnpath',
            unique_together={('project_name', 'path')},
        ),
    ]
