# Generated by Django 2.0.13 on 2021-02-21 17:37

import django.core.validators
from django.db import migrations, models
import django.db.models.deletion
import framework.models
import myadmin.models.role
import myadmin.models.user
import time


class Migration(migrations.Migration):

    initial = True

    dependencies = [
    ]

    operations = [
        migrations.CreateModel(
            name='Menu',
            fields=[
                ('id', models.BigAutoField(primary_key=True, serialize=False)),
                ('_version', models.IntegerField(default=0, verbose_name='版本')),
                ('create_datetime', models.DateTimeField(auto_now_add=True, verbose_name='创建时间')),
                ('update_datetime', models.DateTimeField(auto_now=True, verbose_name='更新时间')),
                ('parent_id', models.IntegerField(default=0, verbose_name='父节点id')),
                ('alias', models.CharField(db_index=True, max_length=100, verbose_name='显示名')),
                ('name', models.CharField(blank=True, db_index=True, max_length=128, validators=[django.core.validators.RegexValidator('^[a-zA-Z][0-9A-Za-z_]+$', '开头非数字,数字加字母组合')], verbose_name='权限名')),
                ('url', models.CharField(blank=True, default='', max_length=400, verbose_name='访问地址带参数')),
                ('url_path', models.CharField(db_index=True, max_length=128, null=True, verbose_name='访问路径')),
                ('icon', models.CharField(blank=True, default='', max_length=100, null=True, verbose_name='图标')),
                ('css', models.CharField(blank=True, default='', max_length=100, null=True, verbose_name='样式')),
                ('order', models.IntegerField(default=0, verbose_name='排序')),
                ('is_show', models.IntegerField(choices=[(1, '是'), (0, '否')], db_index=True, default=1, verbose_name='显示')),
                ('is_log', models.IntegerField(choices=[(1, '是'), (0, '否')], default=0, verbose_name='记录日志')),
            ],
            options={
                'ordering': ['parent_id', 'order'],
            },
            bases=(models.Model, framework.models.SqlModelMixin),
        ),
        migrations.CreateModel(
            name='OperateLog',
            fields=[
                ('id', models.BigAutoField(primary_key=True, serialize=False)),
                ('_version', models.IntegerField(default=0, verbose_name='版本')),
                ('create_datetime', models.DateTimeField(auto_now_add=True, verbose_name='创建时间')),
                ('update_datetime', models.DateTimeField(auto_now=True, verbose_name='更新时间')),
                ('user_id', models.IntegerField(db_index=True, verbose_name='管理员ID')),
                ('type', models.CharField(db_index=True, max_length=20, verbose_name='类型')),
                ('ip', models.GenericIPAddressField(verbose_name='IP')),
                ('full_path', models.CharField(db_index=True, max_length=200, verbose_name='访问路径')),
                ('post_params', models.TextField(default='', verbose_name='提交参数')),
                ('msg', models.TextField(default='', verbose_name='其他消息')),
                ('user_agent', models.CharField(max_length=200, verbose_name='User-Agent')),
            ],
            options={
                'ordering': ['id'],
            },
            bases=(models.Model, framework.models.SqlModelMixin),
        ),
        migrations.CreateModel(
            name='Resource',
            fields=[
                ('id', models.BigAutoField(primary_key=True, serialize=False)),
                ('_version', models.IntegerField(default=0, verbose_name='版本')),
                ('create_datetime', models.DateTimeField(auto_now_add=True, verbose_name='创建时间')),
                ('update_datetime', models.DateTimeField(auto_now=True, verbose_name='更新时间')),
                ('name', models.CharField(help_text='资源简称,只允许字母', max_length=20, verbose_name='资源名')),
                ('role_id', models.IntegerField(null=True, verbose_name='角色id')),
                ('_members', models.TextField(verbose_name='资源对象成员列表')),
            ],
            bases=(models.Model, framework.models.SqlModelMixin),
        ),
        migrations.CreateModel(
            name='Role',
            fields=[
                ('id', models.BigAutoField(primary_key=True, serialize=False)),
                ('_version', models.IntegerField(default=0, verbose_name='版本')),
                ('create_datetime', models.DateTimeField(auto_now_add=True, verbose_name='创建时间')),
                ('update_datetime', models.DateTimeField(auto_now=True, verbose_name='更新时间')),
                ('alias', models.CharField(max_length=50, verbose_name='角色名称')),
                ('name', models.CharField(db_index=True, max_length=50, unique=True, validators=[django.core.validators.RegexValidator('^[a-z][\\d\\w_]+$', '字母组合,符合^[a-z][\\d\\w_]+$')], verbose_name='标识')),
                ('type', models.IntegerField(choices=[(1, '普通'), (2, '组'), (3, '权限集合')], default=1, verbose_name='类型')),
                ('remark', models.TextField(blank=True, default='', max_length=1000, verbose_name='描述')),
                ('home_index', models.CharField(default='/home', max_length=500, verbose_name='角色首页')),
            ],
            options={
                'ordering': ['id'],
                'abstract': False,
            },
            bases=(myadmin.models.role.RoleManagerMixin, models.Model, framework.models.SqlModelMixin),
        ),
        migrations.CreateModel(
            name='User',
            fields=[
                ('id', models.BigAutoField(primary_key=True, serialize=False)),
                ('_version', models.IntegerField(default=0, verbose_name='版本')),
                ('create_datetime', models.DateTimeField(auto_now_add=True, verbose_name='创建时间')),
                ('update_datetime', models.DateTimeField(auto_now=True, verbose_name='更新时间')),
                ('alias', models.CharField(db_index=True, max_length=50, verbose_name='别名')),
                ('username', models.CharField(db_index=True, max_length=50, unique=True, validators=[django.core.validators.RegexValidator('^[a-z][\\d\\w_]+$', '字母组合,符合^[a-z][\\d\\w_]+$')], verbose_name='用户名')),
                ('password', models.CharField(blank=True, db_index=True, max_length=32, verbose_name='密码')),
                ('last_ip', models.CharField(blank=True, default='', max_length=20, verbose_name='最后登录ip')),
                ('reg_ip', models.CharField(blank=True, default='', max_length=20, verbose_name='注册IP')),
                ('last_time', models.DateTimeField(auto_now_add=True, verbose_name='最后登录时间')),
                ('login_count', models.IntegerField(default=0, verbose_name='登录次数')),
                ('status', models.IntegerField(choices=[(0, '正常'), (1, '锁定'), (2, '删除'), (3, '未激活'), (4, '错误'), (5, '离职')], default=3, verbose_name='状态')),
                ('session_key', models.CharField(blank=True, db_index=True, default='', max_length=40, verbose_name='会话key')),
                ('role', models.ManyToManyField(blank=True, to='myadmin.Role', verbose_name='所属角色')),
            ],
            options={
                'ordering': ['id'],
            },
            bases=(models.Model, framework.models.SqlModelMixin, myadmin.models.user.UserManagerMixin),
        ),
        migrations.CreateModel(
            name='UserDefinedMenu',
            fields=[
                ('id', models.BigAutoField(primary_key=True, serialize=False)),
                ('_version', models.IntegerField(default=0, verbose_name='版本')),
                ('create_datetime', models.DateTimeField(auto_now_add=True, verbose_name='创建时间')),
                ('update_datetime', models.DateTimeField(auto_now=True, verbose_name='更新时间')),
                ('user_id', models.IntegerField(verbose_name='所属管理员ID')),
                ('defined_menu', models.TextField(max_length=1000, verbose_name='用户定义的菜单项')),
                ('map_menu', models.TextField(max_length=1000, verbose_name='系统菜单的映射')),
                ('update_time', models.DateTimeField()),
            ],
            bases=(models.Model, framework.models.SqlModelMixin),
        ),
        migrations.CreateModel(
            name='UserInfo',
            fields=[
                ('id', models.BigAutoField(primary_key=True, serialize=False)),
                ('_version', models.IntegerField(default=0, verbose_name='版本')),
                ('create_datetime', models.DateTimeField(auto_now_add=True, verbose_name='创建时间')),
                ('update_datetime', models.DateTimeField(auto_now=True, verbose_name='更新时间')),
                ('employee_id', models.CharField(blank=True, db_index=True, default='', max_length=15, verbose_name='工号')),
                ('sex', models.IntegerField(choices=[(3, '未知'), (0, '女'), (1, '男')], default=3, verbose_name='性别')),
                ('email', models.EmailField(blank=True, default='', max_length=254, verbose_name='邮件地址')),
                ('email_active', models.BooleanField(default=False, verbose_name='是否激活邮箱')),
                ('qq', models.CharField(blank=True, default='', max_length=15, verbose_name='QQ')),
                ('phone', models.CharField(blank=True, db_index=True, default='', max_length=18, verbose_name='电话')),
                ('phone_active', models.BooleanField(default=False, verbose_name='是否绑定手机')),
                ('user', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='myadmin.User', verbose_name='所属管理员')),
            ],
            bases=(models.Model, framework.models.SqlModelMixin),
        ),
        migrations.CreateModel(
            name='UserOauth',
            fields=[
                ('id', models.BigAutoField(primary_key=True, serialize=False)),
                ('_version', models.IntegerField(default=0, verbose_name='版本')),
                ('create_datetime', models.DateTimeField(auto_now_add=True, verbose_name='创建时间')),
                ('update_datetime', models.DateTimeField(auto_now=True, verbose_name='更新时间')),
                ('user_id', models.IntegerField(db_index=True, default=0, verbose_name='管理员ID')),
                ('oauth_type', models.CharField(max_length=20, verbose_name='Oauth类型')),
                ('oauth_id', models.CharField(db_index=True, max_length=128, verbose_name='Oauth 账号ID')),
                ('access_token', models.CharField(max_length=512, verbose_name='access_token')),
                ('expires_timestamp', models.IntegerField(default=time.time, verbose_name='过期时间戳')),
                ('other_info', models.TextField(default='{}', verbose_name='其他信息')),
            ],
            bases=(models.Model, framework.models.SqlModelMixin),
        ),
        migrations.AddField(
            model_name='role',
            name='creater',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='user_id', to='myadmin.User', verbose_name='创建者'),
        ),
        migrations.AddField(
            model_name='role',
            name='parent',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, to='myadmin.Role', verbose_name='上级'),
        ),
        migrations.AddField(
            model_name='role',
            name='resource',
            field=models.ManyToManyField(blank=True, to='myadmin.Resource', verbose_name='资源对象'),
        ),
        migrations.AlterUniqueTogether(
            name='resource',
            unique_together={('name', 'role_id')},
        ),
    ]
