# Copyright 2021 The KaiJIN Authors. All Rights Reserved.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
# ==============================================================================

from .activation import Swish

from .attention import CollectAttention
from .attention import DistributeAttention

from .conv import DeformConvFunction
from .conv import ModulatedDeformConvFunction
from .conv import DeformConv
from .conv import ModulatedDeformConv
from .conv import ModulatedDeformConvPack

from .convert import EmptyConv2d
from .convert import EmptyConvTranspose2d
from .convert import EmptyBatchNorm2d
from .convert import EmptyLayer
from .convert import FrozenBatchNorm2d

from .embedding import AngleLinear

from . import initialize
from . import losses

from .losses import ContentLoss
from .losses import AngleLoss
from .losses import KLStandardGaussianLoss
from .losses import LogRatioMetricLoss
from .losses import PSNRLoss
from .losses import PixelPositionAwareLoss
from .losses import ReliabLoss
from .losses import StructuralSimilarityLoss
from .losses import SmoothL1Loss
from .losses import SigmoidFocalLoss
from .losses import OrderSensitiveMetricLoss
from .losses import MutualChannelLoss
from .losses import LabelSmoothLoss
from .losses import EBMLoss
from .losses import CharbonnierLoss
from .losses import GradientPenaltyLoss
from .losses import GeneralGanLoss
from .losses import LPIPSLoss

from .losses import PerceptualLoss
from .losses import WeightedTVLoss

from .nms import NonMaxSuppression
from .nms import MultiLabelNonMaxSuppression
from .nms import MulticlassNMS

from .normalize import L2Norm
from .normalize import Scale

from .pooling import DeformRoIPoolingFunction
from .pooling import DeformRoIPooling
from .pooling import DeformRoIPoolingPack
from .pooling import ModulatedDeformRoIPoolingPack
from .pooling import RoIAlign
from .pooling import ROIPool
from .pooling import ChannelMaxPool
from .pooling import ChannelAvgPool
from .pooling import CrissCrossAttention
from .pooling import AtrousSpatialPyramidPooling

from .random import GMMSampler

from .rnn import LSTM
from .rnn import RNN
from .rnn import GRU

from .filter import GradientIntensity