
from test_framework.dut.agent import Agent
from test_framework.dut.slot import Slot
from test_framework.database.dut_database import DutDatabase


class Dut(object):

    def __init__(self):
        self.agent = Agent()
        self.db_client = DutDatabase()

    def refresh(self):
        self.agent.refresh()
        self.refresh_slots()

    def refresh_slots(self):
        slots = self.get_agent_slots()
        for slot in slots:
            slot_obj = Slot(slot[0], slot[1])
            slot_obj.refresh()

    def get_agent_slots(self):
        slots = self.db_client.get_agent_related_slots(self.agent.get_agent_name())
        return slots


if __name__ == '__main__':
    dut = Dut()
    dut.get_agent_slots()
