# Copyright 2020 The TensorStore Authors
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#      http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

load("//third_party:repo.bzl", "third_party_http_archive")
load("@bazel_tools//tools/build_defs/repo:utils.bzl", "maybe")
load("//:cmake_helpers.bzl", "cmake_add_dep_mapping", "cmake_fetch_content_package")

def repo():
    maybe(
        third_party_http_archive,
        name = "org_tukaani_xz",
        strip_prefix = "xz-5.2.5",
        urls = [
            "https://storage.googleapis.com/tensorstore-bazel-mirror/tukaani.org/xz/xz-5.2.5.tar.gz",
            "https://tukaani.org/xz/xz-5.2.5.tar.gz",
        ],
        sha256 = "f6f4910fd033078738bd82bfba4f49219d03b17eb0794eb91efbae419f4aba10",
        build_file = Label("//third_party:org_tukaani_xz/bundled.BUILD.bazel"),
        system_build_file = Label("//third_party:org_tukaani_xz/system.BUILD.bazel"),
        doc_homepage = "https://tukaani.org/xz/",
    )

# https://github.com/xz-mirror/xz/blob/master/CMakeLists.txt
cmake_fetch_content_package(name = "org_tukaani_xz")

cmake_add_dep_mapping(target_mapping = {
    "@org_tukaani_xz//:liblzma": "liblzma",
})
