# Copyright 2020 The TensorStore Authors
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#      http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

load(
    "//third_party:repo.bzl",
    "third_party_http_archive",
)
load("@bazel_tools//tools/build_defs/repo:utils.bzl", "maybe")
load("//:cmake_helpers.bzl", "cmake_add_dep_mapping", "cmake_find_package")

def repo():
    maybe(
        third_party_http_archive,
        name = "org_sourceware_bzip2",
        urls = [
            "https://sourceware.org/pub/bzip2/bzip2-1.0.8.tar.gz",
        ],
        strip_prefix = "bzip2-1.0.8",
        sha256 = "ab5a03176ee106d3f0fa90e381da478ddae405918153cca248e682cd0c4a2269",
        build_file = Label("//third_party:org_sourceware_bzip2/bundled.BUILD.bazel"),
        system_build_file = Label("//third_party:org_sourceware_bzip2/system.BUILD.bazel"),
    )

cmake_find_package(name = "BZip2")

cmake_add_dep_mapping(target_mapping = {
    "@org_sourceware_bzip2//:bzip2": "BZip2::BZip2",
})
