#!/bin/bash
echo "Running parallel tests..."
PYTHONPATH=`pwd`/../src:`pwd`/.. pytest --cov=testcode --cov-report term --cov-report html .  -s -C 4 >& output.txt && echo -e "\e[31mFAIL: \e[39mExpected error status" && exit 1 || echo -e "\e[32mPASS:\e[39m Got expected error return code"
cat output.txt | grep "== 1 failed, 1005 passed" || echo -e "\e[31mFAILED: \e[39mPass/fail counts not as expected" | exit 1 && echo -e "\e[32mPASSED: \e[39m Pass/fail counts as expected"
test `grep -c "###### INITIALIZE ############" output.txt` == 1 || echo -e "\e[31mFAILED: \e[39mInitializer not invoked" | exit 2 && echo -e "\e[32mPASSED:\e[39m Initializer invoked"
test `grep -c "###### FINALIZE ############" output.txt` == 1 || echo -e "\e[31mFAILED: \e[39mFinalizer not invoked" | exit 3 && echo -e "\e[32mPASSED:\e[39m Finalizer invoked"
grep "TOTAL" output.txt | grep "100" > /dev/null || echo -e "\e[31mFAILED: \e[39mTest Coverage failed" | exit 4 && echo -e "\e[32mPASSED:\e[39m Test coverage"
echo "Running serially and checking same output..."
PYTHONPATH=`pwd`/../src:`pwd`/.. pytest -s . >& output2.txt && echo -e "\e[31mFAIL: \e[39mExpected error status" && exit 5 || echo -e "\e[32mPASS:\e[39m Got expected error return code"
grep "== 1 failed, 1005 passed" output2.txt > /dev/null|| echo -e "\e[31mFAILED: \e[39mPass/fail counts not as expected" | exit 6 && echo -e "\e[32mPASSED: \e[39m Pass/fail counts as expected"
test `grep -c "###### INITIALIZE ############" output2.txt` == 1 || echo -e "\e[31mFAILED: \e[39mInitializer not invoked" | exit 7 && echo -e "\e[32mPASSED:\e[39m Initializer invoked"
test `grep -c "###### FINALIZE ############" output2.txt` == 1 || echo -e "\e[31mFAILED: \e[39mFinalizer not invoked" | exit 8 && echo -e "\e[32mPASSED:\e[39m Finalizer invoked"
