function GetOciTopLevelCommand_waas() {
    return 'waas'
}

function GetOciSubcommands_waas() {
    $ociSubcommands = @{
        'waas' = 'access-rule address-list address-rate-limiting caching-rule captcha certificate custom-protection-rule device-fingerprint-challenge edge-subnet good-bot http-redirect human-interaction-challenge js-challenge policy-config protection-rule protection-settings purge-cache recommendation threat-feed waas-policy waf-blocked-request waf-config waf-log waf-request waf-traffic-datum whitelist work-request'
        'waas access-rule' = 'list update'
        'waas address-list' = 'change-compartment create delete get list update'
        'waas address-rate-limiting' = 'get-waf update-waf'
        'waas caching-rule' = 'list update'
        'waas captcha' = 'list update'
        'waas certificate' = 'change-compartment create delete get list update update-address-list'
        'waas custom-protection-rule' = 'change-compartment create delete get list update update-setting'
        'waas device-fingerprint-challenge' = 'get update'
        'waas edge-subnet' = 'list'
        'waas good-bot' = 'list update'
        'waas http-redirect' = 'change-compartment create delete get list update'
        'waas human-interaction-challenge' = 'get update'
        'waas js-challenge' = 'get update'
        'waas policy-config' = 'get update'
        'waas protection-rule' = 'get list update'
        'waas protection-settings' = 'get update'
        'waas recommendation' = 'accept list'
        'waas threat-feed' = 'list update'
        'waas waas-policy' = 'change-compartment create custom-protection-rule delete get list update'
        'waas waas-policy custom-protection-rule' = 'list'
        'waas waf-blocked-request' = 'list'
        'waas waf-config' = 'get update'
        'waas waf-log' = 'list'
        'waas waf-request' = 'list'
        'waas waf-traffic-datum' = 'list-waf-traffic'
        'waas whitelist' = 'list update'
        'waas work-request' = 'cancel get list'
    }
    return $ociSubcommands
}

function GetOciCommandsToLongParams_waas() {
    $ociCommandsToLongParams = @{
        'waas access-rule list' = 'all from-json help limit page page-size waas-policy-id'
        'waas access-rule update' = 'access-rules from-json help if-match max-wait-seconds waas-policy-id wait-for-state wait-interval-seconds'
        'waas address-list change-compartment' = 'address-list-id compartment-id from-json help if-match'
        'waas address-list create' = 'addresses compartment-id defined-tags display-name freeform-tags from-json help max-wait-seconds wait-for-state wait-interval-seconds'
        'waas address-list delete' = 'address-list-id force from-json help if-match max-wait-seconds wait-for-state wait-interval-seconds'
        'waas address-list get' = 'address-list-id from-json help'
        'waas address-list list' = 'all compartment-id from-json help id lifecycle-state limit name page page-size sort-by sort-order time-created-greater-than-or-equal-to time-created-less-than'
        'waas address-list update' = 'address-list-id addresses defined-tags display-name force freeform-tags from-json help if-match max-wait-seconds wait-for-state wait-interval-seconds'
        'waas address-rate-limiting get-waf' = 'from-json help waas-policy-id'
        'waas address-rate-limiting update-waf' = 'allowed-rate-per-address block-response-code from-json help if-match is-enabled max-delayed-count-per-address max-wait-seconds waas-policy-id wait-for-state wait-interval-seconds'
        'waas caching-rule list' = 'all from-json help limit page page-size waas-policy-id'
        'waas caching-rule update' = 'caching-rules-details from-json help if-match max-wait-seconds waas-policy-id wait-for-state wait-interval-seconds'
        'waas captcha list' = 'all from-json help limit page page-size waas-policy-id'
        'waas captcha update' = 'captchas from-json help if-match max-wait-seconds waas-policy-id wait-for-state wait-interval-seconds'
        'waas certificate change-compartment' = 'certificate-id compartment-id from-json help if-match'
        'waas certificate create' = 'certificate-data compartment-id defined-tags display-name freeform-tags from-json help is-trust-verification-disabled max-wait-seconds private-key-data wait-for-state wait-interval-seconds'
        'waas certificate delete' = 'certificate-id force from-json help if-match max-wait-seconds wait-for-state wait-interval-seconds'
        'waas certificate get' = 'certificate-id from-json help'
        'waas certificate list' = 'all compartment-id display-name from-json help id lifecycle-state limit page page-size sort-by sort-order time-created-greater-than-or-equal-to time-created-less-than'
        'waas certificate update' = 'certificate-id defined-tags display-name force freeform-tags from-json help if-match max-wait-seconds wait-for-state wait-interval-seconds'
        'waas certificate update-address-list' = 'address-list-id addresses defined-tags display-name force freeform-tags from-json help if-match max-wait-seconds wait-for-state wait-interval-seconds'
        'waas custom-protection-rule change-compartment' = 'compartment-id custom-protection-rule-id from-json help if-match'
        'waas custom-protection-rule create' = 'compartment-id defined-tags description display-name freeform-tags from-json help max-wait-seconds template wait-for-state wait-interval-seconds'
        'waas custom-protection-rule delete' = 'custom-protection-rule-id force from-json help if-match max-wait-seconds wait-for-state wait-interval-seconds'
        'waas custom-protection-rule get' = 'custom-protection-rule-id from-json help'
        'waas custom-protection-rule list' = 'all compartment-id display-name from-json help id lifecycle-state limit page page-size sort-by sort-order time-created-greater-than-or-equal-to time-created-less-than'
        'waas custom-protection-rule update' = 'custom-protection-rule-id defined-tags description display-name force freeform-tags from-json help if-match max-wait-seconds template wait-for-state wait-interval-seconds'
        'waas custom-protection-rule update-setting' = 'custom-protection-rules-details from-json help if-match max-wait-seconds waas-policy-id wait-for-state wait-interval-seconds'
        'waas device-fingerprint-challenge get' = 'from-json help waas-policy-id'
        'waas device-fingerprint-challenge update' = 'action action-expiration-in-seconds challenge-settings failure-threshold failure-threshold-expiration-in-seconds force from-json help if-match is-enabled max-address-count max-address-count-expiration-in-seconds max-wait-seconds waas-policy-id wait-for-state wait-interval-seconds'
        'waas edge-subnet list' = 'all from-json help limit page page-size sort-by sort-order'
        'waas good-bot list' = 'all from-json help limit page page-size waas-policy-id'
        'waas good-bot update' = 'from-json good-bots help if-match max-wait-seconds waas-policy-id wait-for-state wait-interval-seconds'
        'waas http-redirect change-compartment' = 'compartment-id from-json help http-redirect-id if-match'
        'waas http-redirect create' = 'compartment-id defined-tags display-name domain freeform-tags from-json help max-wait-seconds response-code target wait-for-state wait-interval-seconds'
        'waas http-redirect delete' = 'force from-json help http-redirect-id if-match max-wait-seconds wait-for-state wait-interval-seconds'
        'waas http-redirect get' = 'from-json help http-redirect-id'
        'waas http-redirect list' = 'all compartment-id display-name from-json help id lifecycle-state limit page page-size sort-by sort-order time-created-greater-than-or-equal-to time-created-less-than'
        'waas http-redirect update' = 'defined-tags display-name force freeform-tags from-json help http-redirect-id if-match max-wait-seconds response-code target wait-for-state wait-interval-seconds'
        'waas human-interaction-challenge get' = 'from-json help waas-policy-id'
        'waas human-interaction-challenge update' = 'action action-expiration-in-seconds challenge-settings failure-threshold failure-threshold-expiration-in-seconds force from-json help if-match interaction-threshold is-enabled is-nat-enabled max-wait-seconds recording-period-in-seconds set-http-header waas-policy-id wait-for-state wait-interval-seconds'
        'waas js-challenge get' = 'from-json help waas-policy-id'
        'waas js-challenge update' = 'action action-expiration-in-seconds are-redirects-challenged challenge-settings criteria failure-threshold force from-json help if-match is-enabled is-nat-enabled max-wait-seconds set-http-header waas-policy-id wait-for-state wait-interval-seconds'
        'waas policy-config get' = 'from-json help waas-policy-id'
        'waas policy-config update' = 'certificate-id cipher-group client-address-header force from-json health-checks help if-match is-behind-cdn is-cache-control-respected is-https-enabled is-https-forced is-origin-compression-enabled is-response-buffering-enabled is-sni-enabled load-balancing-method max-wait-seconds tls-protocols waas-policy-id wait-for-state wait-interval-seconds websocket-path-prefixes'
        'waas protection-rule get' = 'from-json help protection-rule-key waas-policy-id'
        'waas protection-rule list' = 'action all from-json help limit mod-security-rule-id page page-size waas-policy-id'
        'waas protection-rule update' = 'from-json help if-match max-wait-seconds protection-rules waas-policy-id wait-for-state wait-interval-seconds'
        'waas protection-settings get' = 'from-json help waas-policy-id'
        'waas protection-settings update' = 'allowed-http-methods block-action block-error-page-code block-error-page-description block-error-page-message block-response-code force from-json help if-match is-response-inspected max-argument-count max-name-length-per-argument max-response-size-in-ki-b max-total-name-length-of-arguments max-wait-seconds media-types recommendations-period-in-days waas-policy-id wait-for-state wait-interval-seconds'
        'waas purge-cache' = 'from-json help if-match max-wait-seconds resources waas-policy-id wait-for-state wait-interval-seconds'
        'waas recommendation accept' = 'from-json help if-match max-wait-seconds protection-rule-keys waas-policy-id wait-for-state wait-interval-seconds'
        'waas recommendation list' = 'all from-json help limit page page-size recommended-action waas-policy-id'
        'waas threat-feed list' = 'all from-json help limit page page-size waas-policy-id'
        'waas threat-feed update' = 'from-json help if-match max-wait-seconds threat-feeds waas-policy-id wait-for-state wait-interval-seconds'
        'waas waas-policy change-compartment' = 'compartment-id from-json help if-match waas-policy-id'
        'waas waas-policy create' = 'additional-domains compartment-id defined-tags display-name domain freeform-tags from-json help max-wait-seconds origin-groups origins policy-config waf-config wait-for-state wait-interval-seconds'
        'waas waas-policy custom-protection-rule list' = 'action all from-json help limit mod-security-rule-id page page-size waas-policy-id'
        'waas waas-policy delete' = 'force from-json help if-match max-wait-seconds waas-policy-id wait-for-state wait-interval-seconds'
        'waas waas-policy get' = 'from-json help waas-policy-id'
        'waas waas-policy list' = 'all compartment-id display-name from-json help id lifecycle-state limit page page-size sort-by sort-order time-created-greater-than-or-equal-to time-created-less-than'
        'waas waas-policy update' = 'additional-domains defined-tags display-name force freeform-tags from-json help if-match max-wait-seconds origin-groups origins policy-config waas-policy-id waf-config wait-for-state wait-interval-seconds'
        'waas waf-blocked-request list' = 'all from-json help limit page page-size time-observed-greater-than-or-equal-to time-observed-less-than waas-policy-id waf-feature'
        'waas waf-config get' = 'from-json help waas-policy-id'
        'waas waf-config update' = 'access-rules address-rate-limiting caching-rules captchas custom-protection-rules device-fingerprint-challenge force from-json good-bots help human-interaction-challenge if-match js-challenge max-wait-seconds origin origin-groups protection-rules protection-settings threat-feeds waas-policy-id wait-for-state wait-interval-seconds whitelists'
        'waas waf-log list' = 'access-rule-key action all client-address country-code country-name fingerprint from-json help http-method incident-key limit log-type origin-address page page-size protection-rule-key referrer request-url response-code text-contains threat-feed-key time-observed-greater-than-or-equal-to time-observed-less-than user-agent waas-policy-id'
        'waas waf-request list' = 'all from-json help limit page page-size time-observed-greater-than-or-equal-to time-observed-less-than waas-policy-id'
        'waas waf-traffic-datum list-waf-traffic' = 'all from-json help limit page page-size time-observed-greater-than-or-equal-to time-observed-less-than waas-policy-id'
        'waas whitelist list' = 'all from-json help limit page page-size waas-policy-id'
        'waas whitelist update' = 'from-json help if-match max-wait-seconds waas-policy-id wait-for-state wait-interval-seconds whitelists'
        'waas work-request cancel' = 'force from-json help if-match work-request-id'
        'waas work-request get' = 'from-json help work-request-id'
        'waas work-request list' = 'all compartment-id from-json help limit page page-size sort-by sort-order waas-policy-id'
    }
    return $ociCommandsToLongParams
}

function GetOciCommandsToShortParams_waas() {
    $ociCommandsToShortParams = @{
        'waas access-rule list' = '? h'
        'waas access-rule update' = '? h'
        'waas address-list change-compartment' = '? c h'
        'waas address-list create' = '? c h'
        'waas address-list delete' = '? h'
        'waas address-list get' = '? h'
        'waas address-list list' = '? c h'
        'waas address-list update' = '? h'
        'waas address-rate-limiting get-waf' = '? h'
        'waas address-rate-limiting update-waf' = '? h'
        'waas caching-rule list' = '? h'
        'waas caching-rule update' = '? h'
        'waas captcha list' = '? h'
        'waas captcha update' = '? h'
        'waas certificate change-compartment' = '? c h'
        'waas certificate create' = '? c h'
        'waas certificate delete' = '? h'
        'waas certificate get' = '? h'
        'waas certificate list' = '? c h'
        'waas certificate update' = '? h'
        'waas certificate update-address-list' = '? h'
        'waas custom-protection-rule change-compartment' = '? c h'
        'waas custom-protection-rule create' = '? c h'
        'waas custom-protection-rule delete' = '? h'
        'waas custom-protection-rule get' = '? h'
        'waas custom-protection-rule list' = '? c h'
        'waas custom-protection-rule update' = '? h'
        'waas custom-protection-rule update-setting' = '? h'
        'waas device-fingerprint-challenge get' = '? h'
        'waas device-fingerprint-challenge update' = '? h'
        'waas edge-subnet list' = '? h'
        'waas good-bot list' = '? h'
        'waas good-bot update' = '? h'
        'waas http-redirect change-compartment' = '? c h'
        'waas http-redirect create' = '? c h'
        'waas http-redirect delete' = '? h'
        'waas http-redirect get' = '? h'
        'waas http-redirect list' = '? c h'
        'waas http-redirect update' = '? h'
        'waas human-interaction-challenge get' = '? h'
        'waas human-interaction-challenge update' = '? h'
        'waas js-challenge get' = '? h'
        'waas js-challenge update' = '? h'
        'waas policy-config get' = '? h'
        'waas policy-config update' = '? h'
        'waas protection-rule get' = '? h'
        'waas protection-rule list' = '? h'
        'waas protection-rule update' = '? h'
        'waas protection-settings get' = '? h'
        'waas protection-settings update' = '? h'
        'waas purge-cache' = '? h'
        'waas recommendation accept' = '? h'
        'waas recommendation list' = '? h'
        'waas threat-feed list' = '? h'
        'waas threat-feed update' = '? h'
        'waas waas-policy change-compartment' = '? c h'
        'waas waas-policy create' = '? c h'
        'waas waas-policy custom-protection-rule list' = '? h'
        'waas waas-policy delete' = '? h'
        'waas waas-policy get' = '? h'
        'waas waas-policy list' = '? c h'
        'waas waas-policy update' = '? h'
        'waas waf-blocked-request list' = '? h'
        'waas waf-config get' = '? h'
        'waas waf-config update' = '? h'
        'waas waf-log list' = '? h'
        'waas waf-request list' = '? h'
        'waas waf-traffic-datum list-waf-traffic' = '? h'
        'waas whitelist list' = '? h'
        'waas whitelist update' = '? h'
        'waas work-request cancel' = '? h'
        'waas work-request get' = '? h'
        'waas work-request list' = '? c h'
    }
    return $ociCommandsToShortParams
}