function GetOciTopLevelCommand_compute() {
    return 'compute'
}

function GetOciSubcommands_compute() {
    $ociSubcommands = @{
        'compute' = 'boot-volume-attachment capacity-reservation console-history dedicated-vm-host dedicated-vm-host-instance device global-image-capability-schema global-image-capability-schema-version image image-capability-schema image-shape-compatibility-entry instance instance-console-connection pic shape vnic-attachment volume-attachment'
        'compute boot-volume-attachment' = 'attach detach get list'
        'compute capacity-reservation' = 'change-compartment create delete get instance instance-shape list update'
        'compute capacity-reservation instance' = 'list'
        'compute capacity-reservation instance-shape' = 'list'
        'compute console-history' = 'capture delete get get-content list update'
        'compute dedicated-vm-host' = 'change-compartment create delete get host-shape instance-shape list update'
        'compute dedicated-vm-host host-shape' = 'list'
        'compute dedicated-vm-host instance-shape' = 'list'
        'compute dedicated-vm-host-instance' = 'list'
        'compute device' = 'list-instance'
        'compute global-image-capability-schema' = 'get list'
        'compute global-image-capability-schema-version' = 'get list'
        'compute image' = 'change-compartment create delete export get import list update'
        'compute image export' = 'to-object to-object-uri'
        'compute image import' = 'from-object from-object-uri'
        'compute image-capability-schema' = 'change-compartment create delete get list update'
        'compute image-shape-compatibility-entry' = 'add get list remove'
        'compute instance' = 'action attach-vnic change-compartment detach-vnic get get-windows-initial-creds launch list list-vnics terminate update'
        'compute instance-console-connection' = 'create delete get get-plink-connection-string list update'
        'compute pic' = 'agreements listing subscription version'
        'compute pic agreements' = 'get'
        'compute pic listing' = 'get list'
        'compute pic subscription' = 'create delete list'
        'compute pic version' = 'get list'
        'compute shape' = 'list'
        'compute vnic-attachment' = 'get list'
        'compute volume-attachment' = 'attach attach-iscsi-volume attach-paravirtualized-volume detach get list'
    }
    return $ociSubcommands
}

function GetOciCommandsToLongParams_compute() {
    $ociCommandsToLongParams = @{
        'compute boot-volume-attachment attach' = 'boot-volume-id display-name from-json help instance-id max-wait-seconds wait-for-state wait-interval-seconds'
        'compute boot-volume-attachment detach' = 'boot-volume-attachment-id force from-json help if-match max-wait-seconds wait-for-state wait-interval-seconds'
        'compute boot-volume-attachment get' = 'boot-volume-attachment-id from-json help'
        'compute boot-volume-attachment list' = 'all availability-domain boot-volume-id compartment-id from-json help instance-id limit page page-size'
        'compute capacity-reservation change-compartment' = 'capacity-reservation-id compartment-id from-json help if-match max-wait-seconds wait-for-state wait-interval-seconds'
        'compute capacity-reservation create' = 'availability-domain compartment-id defined-tags display-name freeform-tags from-json help instance-reservation-configs is-default-reservation max-wait-seconds wait-for-state wait-interval-seconds'
        'compute capacity-reservation delete' = 'capacity-reservation-id force from-json help if-match max-wait-seconds wait-for-state wait-interval-seconds'
        'compute capacity-reservation get' = 'capacity-reservation-id from-json help'
        'compute capacity-reservation instance list' = 'all availability-domain capacity-reservation-id compartment-id from-json help limit page page-size sort-by sort-order'
        'compute capacity-reservation instance-shape list' = 'all availability-domain compartment-id display-name from-json help limit page page-size sort-by sort-order'
        'compute capacity-reservation list' = 'all availability-domain compartment-id display-name from-json help lifecycle-state limit page page-size sort-by sort-order'
        'compute capacity-reservation update' = 'capacity-reservation-id defined-tags display-name force freeform-tags from-json help if-match instance-reservation-configs is-default-reservation max-wait-seconds wait-for-state wait-interval-seconds'
        'compute console-history capture' = 'defined-tags display-name freeform-tags from-json help instance-id max-wait-seconds wait-for-state wait-interval-seconds'
        'compute console-history delete' = 'force from-json help if-match instance-console-history-id max-wait-seconds wait-for-state wait-interval-seconds'
        'compute console-history get' = 'from-json help instance-console-history-id'
        'compute console-history get-content' = 'file from-json help instance-console-history-id length offset'
        'compute console-history list' = 'all availability-domain compartment-id from-json help instance-id lifecycle-state limit page page-size sort-by sort-order'
        'compute console-history update' = 'defined-tags display-name force freeform-tags from-json help if-match instance-console-history-id max-wait-seconds wait-for-state wait-interval-seconds'
        'compute dedicated-vm-host change-compartment' = 'compartment-id dedicated-vm-host-id from-json help if-match max-wait-seconds wait-for-state wait-interval-seconds'
        'compute dedicated-vm-host create' = 'availability-domain compartment-id dedicated-vm-host-shape defined-tags display-name fault-domain freeform-tags from-json help max-wait-seconds wait-for-state wait-interval-seconds'
        'compute dedicated-vm-host delete' = 'dedicated-vm-host-id force from-json help max-wait-seconds wait-for-state wait-interval-seconds'
        'compute dedicated-vm-host get' = 'dedicated-vm-host-id from-json help'
        'compute dedicated-vm-host host-shape list' = 'all availability-domain compartment-id from-json help instance-shape-name limit page page-size'
        'compute dedicated-vm-host instance-shape list' = 'all availability-domain compartment-id dedicated-vm-host-shape from-json help limit page page-size'
        'compute dedicated-vm-host list' = 'all availability-domain compartment-id display-name from-json help instance-shape-name lifecycle-state limit page page-size remaining-memory-in-gbs-greater-than-or-equal-to remaining-ocpus-greater-than-or-equal-to sort-by sort-order'
        'compute dedicated-vm-host update' = 'dedicated-vm-host-id defined-tags display-name force freeform-tags from-json help if-match max-wait-seconds wait-for-state wait-interval-seconds'
        'compute dedicated-vm-host-instance list' = 'all availability-domain compartment-id dedicated-vm-host-id from-json help limit page page-size sort-by sort-order'
        'compute device list-instance' = 'all from-json help instance-id is-available limit name page page-size sort-by sort-order'
        'compute global-image-capability-schema get' = 'from-json global-image-capability-schema-id help'
        'compute global-image-capability-schema list' = 'all compartment-id display-name from-json help limit page page-size sort-by sort-order'
        'compute global-image-capability-schema-version get' = 'from-json global-image-capability-schema-id global-image-capability-schema-version-name help'
        'compute global-image-capability-schema-version list' = 'all display-name from-json global-image-capability-schema-id help limit page page-size sort-by sort-order'
        'compute image change-compartment' = 'compartment-id from-json help if-match image-id'
        'compute image create' = 'compartment-id defined-tags display-name freeform-tags from-json help image-source-details instance-id launch-mode max-wait-seconds wait-for-state wait-interval-seconds'
        'compute image delete' = 'force from-json help if-match image-id max-wait-seconds wait-for-state wait-interval-seconds'
        'compute image export to-object' = 'bucket-name export-format from-json help if-match image-id name namespace'
        'compute image export to-object-uri' = 'export-format from-json help if-match image-id uri'
        'compute image get' = 'from-json help image-id'
        'compute image import from-object' = 'bucket-name compartment-id defined-tags display-name freeform-tags from-json help launch-mode name namespace operating-system operating-system-version source-image-type'
        'compute image import from-object-uri' = 'compartment-id defined-tags display-name freeform-tags from-json help launch-mode operating-system operating-system-version source-image-type uri'
        'compute image list' = 'all compartment-id display-name from-json help lifecycle-state limit operating-system operating-system-version page page-size shape sort-by sort-order'
        'compute image update' = 'defined-tags display-name force freeform-tags from-json help if-match image-id max-wait-seconds operating-system operating-system-version wait-for-state wait-interval-seconds'
        'compute image-capability-schema change-compartment' = 'compartment-id from-json help if-match image-capability-schema-id'
        'compute image-capability-schema create' = 'compartment-id defined-tags display-name freeform-tags from-json global-image-capability-schema-version-name help image-id schema-data'
        'compute image-capability-schema delete' = 'force from-json help if-match image-capability-schema-id'
        'compute image-capability-schema get' = 'from-json help image-capability-schema-id is-merge-enabled'
        'compute image-capability-schema list' = 'all compartment-id display-name from-json help image-id limit page page-size sort-by sort-order'
        'compute image-capability-schema update' = 'defined-tags display-name force freeform-tags from-json help if-match image-capability-schema-id schema-data'
        'compute image-shape-compatibility-entry add' = 'force from-json help image-id memory-constraints ocpu-constraints shape-name'
        'compute image-shape-compatibility-entry get' = 'from-json help image-id shape-name'
        'compute image-shape-compatibility-entry list' = 'all from-json help image-id limit page page-size'
        'compute image-shape-compatibility-entry remove' = 'force from-json help image-id shape-name'
        'compute instance action' = 'action from-json help if-match instance-id max-wait-seconds wait-for-state wait-interval-seconds'
        'compute instance attach-vnic' = 'assign-private-dns-record assign-public-ip defined-tags freeform-tags from-json help hostname-label instance-id nic-index nsg-ids private-ip skip-source-dest-check subnet-id vlan-id vnic-display-name wait'
        'compute instance change-compartment' = 'compartment-id from-json help if-match instance-id max-wait-seconds wait-for-state wait-interval-seconds'
        'compute instance detach-vnic' = 'compartment-id force from-json help max-wait-seconds vnic-id wait-for-state wait-interval-seconds'
        'compute instance get' = 'from-json help instance-id'
        'compute instance get-windows-initial-creds' = 'from-json help instance-id'
        'compute instance launch' = 'agent-config assign-private-dns-record assign-public-ip availability-config availability-domain boot-volume-size-in-gbs capacity-reservation-id compartment-id dedicated-vm-host-id defined-tags display-name extended-metadata fault-domain freeform-tags from-json help hostname-label image-id instance-options ipxe-script-file is-pv-encryption-in-transit-enabled launch-options max-wait-seconds metadata nsg-ids platform-config preemptible-instance-config private-ip shape shape-config skip-source-dest-check source-boot-volume-id source-details ssh-authorized-keys-file subnet-id user-data-file vnic-display-name wait-for-state wait-interval-seconds'
        'compute instance list' = 'all availability-domain capacity-reservation-id compartment-id display-name from-json help lifecycle-state limit page page-size sort-by sort-order'
        'compute instance list-vnics' = 'all compartment-id from-json help instance-id limit page page-size'
        'compute instance terminate' = 'force from-json help if-match instance-id max-wait-seconds preserve-boot-volume wait-for-state wait-interval-seconds'
        'compute instance update' = 'agent-config availability-config capacity-reservation-id defined-tags display-name extended-metadata fault-domain force freeform-tags from-json help if-match instance-id instance-options launch-options max-wait-seconds metadata shape shape-config wait-for-state wait-interval-seconds'
        'compute instance-console-connection create' = 'defined-tags freeform-tags from-json help instance-id max-wait-seconds ssh-public-key-file wait-for-state wait-interval-seconds'
        'compute instance-console-connection delete' = 'force from-json help if-match instance-console-connection-id max-wait-seconds wait-for-state wait-interval-seconds'
        'compute instance-console-connection get' = 'from-json help instance-console-connection-id'
        'compute instance-console-connection get-plink-connection-string' = 'from-json help instance-console-connection-id local-vnc-port private-key-file ssh-proxy-port'
        'compute instance-console-connection list' = 'all compartment-id from-json help instance-id limit page page-size'
        'compute instance-console-connection update' = 'defined-tags force freeform-tags from-json help if-match instance-console-connection-id max-wait-seconds wait-for-state wait-interval-seconds'
        'compute pic agreements get' = 'from-json help listing-id resource-version'
        'compute pic listing get' = 'from-json help listing-id'
        'compute pic listing list' = 'all display-name from-json help limit page page-size publisher-name publisher-type sort-order'
        'compute pic subscription create' = 'compartment-id eula-link from-json help listing-id oracle-tou-link resource-version signature time-retrieved'
        'compute pic subscription delete' = 'compartment-id force from-json help listing-id resource-version'
        'compute pic subscription list' = 'all compartment-id from-json help limit listing-id page page-size sort-by sort-order'
        'compute pic version get' = 'from-json help listing-id resource-version'
        'compute pic version list' = 'all from-json help limit listing-id page page-size sort-order'
        'compute shape list' = 'all availability-domain compartment-id from-json help image-id limit page page-size'
        'compute vnic-attachment get' = 'from-json help vnic-attachment-id'
        'compute vnic-attachment list' = 'all availability-domain compartment-id from-json help instance-id limit page page-size vnic-id'
        'compute volume-attachment attach' = 'device display-name from-json help instance-id is-read-only is-shareable max-wait-seconds type volume-id wait-for-state wait-interval-seconds'
        'compute volume-attachment attach-iscsi-volume' = 'device display-name from-json help instance-id is-read-only is-shareable max-wait-seconds use-chap volume-id wait-for-state wait-interval-seconds'
        'compute volume-attachment attach-paravirtualized-volume' = 'device display-name from-json help instance-id is-pv-encryption-in-transit-enabled is-read-only is-shareable max-wait-seconds volume-id wait-for-state wait-interval-seconds'
        'compute volume-attachment detach' = 'force from-json help if-match max-wait-seconds volume-attachment-id wait-for-state wait-interval-seconds'
        'compute volume-attachment get' = 'from-json help volume-attachment-id'
        'compute volume-attachment list' = 'all availability-domain compartment-id from-json help instance-id limit page page-size volume-id'
    }
    return $ociCommandsToLongParams
}

function GetOciCommandsToShortParams_compute() {
    $ociCommandsToShortParams = @{
        'compute boot-volume-attachment attach' = '? h'
        'compute boot-volume-attachment detach' = '? h'
        'compute boot-volume-attachment get' = '? h'
        'compute boot-volume-attachment list' = '? c h'
        'compute capacity-reservation change-compartment' = '? c h'
        'compute capacity-reservation create' = '? c h'
        'compute capacity-reservation delete' = '? h'
        'compute capacity-reservation get' = '? h'
        'compute capacity-reservation instance list' = '? c h'
        'compute capacity-reservation instance-shape list' = '? c h'
        'compute capacity-reservation list' = '? c h'
        'compute capacity-reservation update' = '? h'
        'compute console-history capture' = '? h'
        'compute console-history delete' = '? h'
        'compute console-history get' = '? h'
        'compute console-history get-content' = '? h'
        'compute console-history list' = '? c h'
        'compute console-history update' = '? h'
        'compute dedicated-vm-host change-compartment' = '? c h'
        'compute dedicated-vm-host create' = '? c h'
        'compute dedicated-vm-host delete' = '? h'
        'compute dedicated-vm-host get' = '? h'
        'compute dedicated-vm-host host-shape list' = '? c h'
        'compute dedicated-vm-host instance-shape list' = '? c h'
        'compute dedicated-vm-host list' = '? c h'
        'compute dedicated-vm-host update' = '? h'
        'compute dedicated-vm-host-instance list' = '? c h'
        'compute device list-instance' = '? h'
        'compute global-image-capability-schema get' = '? h'
        'compute global-image-capability-schema list' = '? c h'
        'compute global-image-capability-schema-version get' = '? h'
        'compute global-image-capability-schema-version list' = '? h'
        'compute image change-compartment' = '? c h'
        'compute image create' = '? c h'
        'compute image delete' = '? h'
        'compute image export to-object' = '? bn h ns'
        'compute image export to-object-uri' = '? h'
        'compute image get' = '? h'
        'compute image import from-object' = '? bn c h ns'
        'compute image import from-object-uri' = '? c h'
        'compute image list' = '? c h'
        'compute image update' = '? h'
        'compute image-capability-schema change-compartment' = '? c h'
        'compute image-capability-schema create' = '? c h'
        'compute image-capability-schema delete' = '? h'
        'compute image-capability-schema get' = '? h'
        'compute image-capability-schema list' = '? c h'
        'compute image-capability-schema update' = '? h'
        'compute image-shape-compatibility-entry add' = '? h'
        'compute image-shape-compatibility-entry get' = '? h'
        'compute image-shape-compatibility-entry list' = '? h'
        'compute image-shape-compatibility-entry remove' = '? h'
        'compute instance action' = '? h'
        'compute instance attach-vnic' = '? h'
        'compute instance change-compartment' = '? c h'
        'compute instance detach-vnic' = '? c h'
        'compute instance get' = '? h'
        'compute instance get-windows-initial-creds' = '? h'
        'compute instance launch' = '? c h'
        'compute instance list' = '? c h'
        'compute instance list-vnics' = '? c h'
        'compute instance terminate' = '? h'
        'compute instance update' = '? h'
        'compute instance-console-connection create' = '? h'
        'compute instance-console-connection delete' = '? h'
        'compute instance-console-connection get' = '? h'
        'compute instance-console-connection get-plink-connection-string' = '? h'
        'compute instance-console-connection list' = '? c h'
        'compute instance-console-connection update' = '? h'
        'compute pic agreements get' = '? h'
        'compute pic listing get' = '? h'
        'compute pic listing list' = '? h'
        'compute pic subscription create' = '? c h'
        'compute pic subscription delete' = '? c h'
        'compute pic subscription list' = '? c h'
        'compute pic version get' = '? h'
        'compute pic version list' = '? h'
        'compute shape list' = '? c h'
        'compute vnic-attachment get' = '? h'
        'compute vnic-attachment list' = '? c h'
        'compute volume-attachment attach' = '? h'
        'compute volume-attachment attach-iscsi-volume' = '? h'
        'compute volume-attachment attach-paravirtualized-volume' = '? h'
        'compute volume-attachment detach' = '? h'
        'compute volume-attachment get' = '? h'
        'compute volume-attachment list' = '? c h'
    }
    return $ociCommandsToShortParams
}