# coding: utf-8
# Copyright (c) 2016, 2021, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

import click
from oci_cli import cli_util
from oci_cli.aliasing import CommandGroupWithAlias
from services.vulnerability_scanning.src.oci_cli_vulnerability_scanning.generated import vulnerabilityscanning_cli

#################################
# host scan group/command changes
#################################
# change
# oci vulnerability-scanning work-request-log-entry list-work-request-logs
# to
# oci vulnerability-scanning work-request-log-entry list
cli_util.rename_command(vulnerabilityscanning_cli, vulnerabilityscanning_cli.work_request_log_entry_group, vulnerabilityscanning_cli.list_work_request_logs, "list")


# restructure commands
@click.command(cli_util.override('vulnerability_scanning.host_group.command_name', 'host'), cls=CommandGroupWithAlias, help="""A top level host command group""")
@cli_util.help_option_group
def host_group():
    pass


@click.command(cli_util.override('vulnerability_scanning.host_scan_group.command_name', 'scan'), cls=CommandGroupWithAlias, help="""A host scan command group""")
@cli_util.help_option_group
def host_scan_group():
    pass


@click.command(cli_util.override('vulnerability_scanning.host_scan_result_group.command_name', 'result'), cls=CommandGroupWithAlias, help="""A host scan result command group""")
@cli_util.help_option_group
def host_scan_result_group():
    pass


@click.command(cli_util.override('vulnerability_scanning.host_scan_result_port_group.command_name', 'port'), cls=CommandGroupWithAlias, help="""A host scan port-result command group""")
@cli_util.help_option_group
def host_scan_result_port_group():
    pass


@click.command(cli_util.override('vulnerability_scanning.host_scan_result_agent_group.command_name', 'agent'), cls=CommandGroupWithAlias, help="""A host scan agent-result command group""")
@cli_util.help_option_group
def host_scan_result_agent_group():
    pass


@click.command(cli_util.override('vulnerability_scanning.host_scan_result_cis_benchmark_group.command_name', 'cis-benchmark'), cls=CommandGroupWithAlias, help="""A host scan cis-benchmark-result command group""")
@cli_util.help_option_group
def host_scan_result_cis_benchmark_group():
    pass


@click.command(cli_util.override('vulnerability_scanning.host_scan_result_endpoint_protection_group.command_name', 'endpoint-protection'), cls=CommandGroupWithAlias, help="""A host scan endpoint-protection-result command group""")
@cli_util.help_option_group
def host_scan_result_endpoint_protection_group():
    pass


@click.command(cli_util.override('vulnerability_scanning.host_scan_target_override_group.command_name', 'target'), cls=CommandGroupWithAlias, help="""A host scan target command group""")
@cli_util.help_option_group
def host_scan_target_override_group():
    pass


@click.command(cli_util.override('vulnerability_scanning.host_scan_recipe_override_group.command_name', 'recipe'), cls=CommandGroupWithAlias, help="""A host scan recipe command group""")
@cli_util.help_option_group
def host_scan_recipe_override_group():
    pass


@click.command(cli_util.override('vulnerability_scanning.host_vulnerability_override_group.command_name', 'vulnerability'), cls=CommandGroupWithAlias, help="""A host vulnerability command group""")
@cli_util.help_option_group
def host_vulnerability_override_group():
    pass


# add group chain: host scan result port/agent/cis-benchmark/endpoint-protection
vulnerabilityscanning_cli.vulnerability_scanning_root_group.add_command(host_group)
host_group.add_command(host_scan_group)
host_scan_group.add_command(host_scan_result_group)

# move oci vulnerability-scanning host-cis-benchmark-scan-result <commands>
# to oci vulnerability-scanning host scan result cis-benchmark <commands>
host_scan_result_group.add_command(host_scan_result_cis_benchmark_group)
vulnerabilityscanning_cli.vulnerability_scanning_root_group.commands.pop(vulnerabilityscanning_cli.host_cis_benchmark_scan_result_group.name)
vulnerabilityscanning_cli.host_cis_benchmark_scan_result_group.commands.pop(vulnerabilityscanning_cli.change_host_cis_benchmark_scan_result_compartment.name)
vulnerabilityscanning_cli.host_cis_benchmark_scan_result_group.commands.pop(vulnerabilityscanning_cli.delete_host_cis_benchmark_scan_result.name)
vulnerabilityscanning_cli.host_cis_benchmark_scan_result_group.commands.pop(vulnerabilityscanning_cli.get_host_cis_benchmark_scan_result.name)
vulnerabilityscanning_cli.host_cis_benchmark_scan_result_group.commands.pop(vulnerabilityscanning_cli.list_host_cis_benchmark_scan_results.name)
host_scan_result_cis_benchmark_group.add_command(vulnerabilityscanning_cli.change_host_cis_benchmark_scan_result_compartment)
host_scan_result_cis_benchmark_group.add_command(vulnerabilityscanning_cli.delete_host_cis_benchmark_scan_result)
host_scan_result_cis_benchmark_group.add_command(vulnerabilityscanning_cli.get_host_cis_benchmark_scan_result)
host_scan_result_cis_benchmark_group.add_command(vulnerabilityscanning_cli.list_host_cis_benchmark_scan_results)

# move oci vulnerability-scanning host-port-scan-result <commands>
# to oci vulnerability-scanning host scan result port <commands>
host_scan_result_group.add_command(host_scan_result_port_group)
vulnerabilityscanning_cli.vulnerability_scanning_root_group.commands.pop(vulnerabilityscanning_cli.host_port_scan_result_group.name)
vulnerabilityscanning_cli.host_port_scan_result_group.commands.pop(vulnerabilityscanning_cli.change_host_port_scan_result_compartment.name)
vulnerabilityscanning_cli.host_port_scan_result_group.commands.pop(vulnerabilityscanning_cli.delete_host_port_scan_result.name)
vulnerabilityscanning_cli.host_port_scan_result_group.commands.pop(vulnerabilityscanning_cli.get_host_port_scan_result.name)
vulnerabilityscanning_cli.host_port_scan_result_group.commands.pop(vulnerabilityscanning_cli.list_host_port_scan_results.name)
host_scan_result_port_group.add_command(vulnerabilityscanning_cli.change_host_port_scan_result_compartment)
host_scan_result_port_group.add_command(vulnerabilityscanning_cli.delete_host_port_scan_result)
host_scan_result_port_group.add_command(vulnerabilityscanning_cli.get_host_port_scan_result)
host_scan_result_port_group.add_command(vulnerabilityscanning_cli.list_host_port_scan_results)

# move oci vulnerability-scanning host-endpoint-protection-scan-result <commands>
# to oci vulnerability-scanning host scan result endpoint-protection <commands>
host_scan_result_group.add_command(host_scan_result_endpoint_protection_group)
vulnerabilityscanning_cli.vulnerability_scanning_root_group.commands.pop(vulnerabilityscanning_cli.host_endpoint_protection_scan_result_group.name)
vulnerabilityscanning_cli.host_endpoint_protection_scan_result_group.commands.pop(vulnerabilityscanning_cli.change_host_endpoint_protection_scan_result_compartment.name)
vulnerabilityscanning_cli.host_endpoint_protection_scan_result_group.commands.pop(vulnerabilityscanning_cli.delete_host_endpoint_protection_scan_result.name)
vulnerabilityscanning_cli.host_endpoint_protection_scan_result_group.commands.pop(vulnerabilityscanning_cli.get_host_endpoint_protection_scan_result.name)
vulnerabilityscanning_cli.host_endpoint_protection_scan_result_group.commands.pop(vulnerabilityscanning_cli.list_host_endpoint_protection_scan_results.name)
host_scan_result_endpoint_protection_group.add_command(vulnerabilityscanning_cli.change_host_endpoint_protection_scan_result_compartment)
host_scan_result_endpoint_protection_group.add_command(vulnerabilityscanning_cli.delete_host_endpoint_protection_scan_result)
host_scan_result_endpoint_protection_group.add_command(vulnerabilityscanning_cli.get_host_endpoint_protection_scan_result)
host_scan_result_endpoint_protection_group.add_command(vulnerabilityscanning_cli.list_host_endpoint_protection_scan_results)

# move oci vulnerability-scanning host-agent-scan-result <commands>
# to oci vulnerability-scanning host scan result agent <commands>
host_scan_result_group.add_command(host_scan_result_agent_group)
vulnerabilityscanning_cli.vulnerability_scanning_root_group.commands.pop(vulnerabilityscanning_cli.host_agent_scan_result_group.name)
vulnerabilityscanning_cli.host_agent_scan_result_group.commands.pop(vulnerabilityscanning_cli.change_host_agent_scan_result_compartment.name)
vulnerabilityscanning_cli.host_agent_scan_result_group.commands.pop(vulnerabilityscanning_cli.delete_host_agent_scan_result.name)
vulnerabilityscanning_cli.host_agent_scan_result_group.commands.pop(vulnerabilityscanning_cli.get_host_agent_scan_result.name)
vulnerabilityscanning_cli.host_agent_scan_result_group.commands.pop(vulnerabilityscanning_cli.list_host_agent_scan_results.name)
vulnerabilityscanning_cli.host_agent_scan_result_group.commands.pop(vulnerabilityscanning_cli.export_host_agent_scan_result_csv.name)
host_scan_result_agent_group.add_command(vulnerabilityscanning_cli.change_host_agent_scan_result_compartment)
host_scan_result_agent_group.add_command(vulnerabilityscanning_cli.delete_host_agent_scan_result)
host_scan_result_agent_group.add_command(vulnerabilityscanning_cli.get_host_agent_scan_result)
host_scan_result_agent_group.add_command(vulnerabilityscanning_cli.list_host_agent_scan_results)
host_scan_result_agent_group.add_command(vulnerabilityscanning_cli.list_host_agent_scan_results)
host_scan_result_agent_group.add_command(vulnerabilityscanning_cli.export_host_agent_scan_result_csv)
# rename: oci vulnerability-scanning host scan result agent export-host-agent-scan-result-csv
# to oci vulnerability-scanning host scan result agent export-csv
cli_util.rename_command(vulnerabilityscanning_cli, host_scan_result_agent_group, vulnerabilityscanning_cli.export_host_agent_scan_result_csv, "export-csv")

# move oci vulnerability-scanning host-vulnerability <commands>
# to oci vulnerability-scanning host vulnerability <commands>
host_group.add_command(host_vulnerability_override_group)
vulnerabilityscanning_cli.vulnerability_scanning_root_group.commands.pop(vulnerabilityscanning_cli.host_vulnerability_group.name)
vulnerabilityscanning_cli.host_vulnerability_group.commands.pop(vulnerabilityscanning_cli.get_host_vulnerability.name)
vulnerabilityscanning_cli.host_vulnerability_group.commands.pop(vulnerabilityscanning_cli.list_host_vulnerabilities.name)
vulnerabilityscanning_cli.host_vulnerability_group.commands.pop(vulnerabilityscanning_cli.list_host_vulnerability_impacted_hosts.name)
vulnerabilityscanning_cli.host_vulnerability_group.commands.pop(vulnerabilityscanning_cli.export_host_vulnerability_csv.name)
host_vulnerability_override_group.add_command(vulnerabilityscanning_cli.get_host_vulnerability)
host_vulnerability_override_group.add_command(vulnerabilityscanning_cli.list_host_vulnerabilities)
host_vulnerability_override_group.add_command(vulnerabilityscanning_cli.list_host_vulnerability_impacted_hosts)
host_vulnerability_override_group.add_command(vulnerabilityscanning_cli.export_host_vulnerability_csv)
# rename: oci vulnerability-scanning host vulnerability export-host-vulnerability-csv
# to oci vulnerability-scanning host vulnerability export-csv
cli_util.rename_command(vulnerabilityscanning_cli, host_vulnerability_override_group, vulnerabilityscanning_cli.export_host_vulnerability_csv, "export-csv")
# rename: oci vulnerability-scanning host vulnerability list-host-vulnerability-impacted-hosts
# to oci vulnerability-scanning host vulnerability list-impacted-hosts
cli_util.rename_command(vulnerabilityscanning_cli, host_vulnerability_override_group, vulnerabilityscanning_cli.list_host_vulnerability_impacted_hosts, "list-impacted-hosts")

# move oci vulnerability-scanning host-scan-recipe <commands>
# to oci vulnerability-scanning host scan recipe <commands>
host_scan_group.add_command(host_scan_recipe_override_group)
vulnerabilityscanning_cli.vulnerability_scanning_root_group.commands.pop(vulnerabilityscanning_cli.host_scan_recipe_group.name)
vulnerabilityscanning_cli.host_scan_recipe_group.commands.pop(vulnerabilityscanning_cli.create_host_scan_recipe.name)
vulnerabilityscanning_cli.host_scan_recipe_group.commands.pop(vulnerabilityscanning_cli.get_host_scan_recipe.name)
vulnerabilityscanning_cli.host_scan_recipe_group.commands.pop(vulnerabilityscanning_cli.update_host_scan_recipe.name)
vulnerabilityscanning_cli.host_scan_recipe_group.commands.pop(vulnerabilityscanning_cli.delete_host_scan_recipe.name)
vulnerabilityscanning_cli.host_scan_recipe_group.commands.pop(vulnerabilityscanning_cli.list_host_scan_recipes.name)
vulnerabilityscanning_cli.host_scan_recipe_group.commands.pop(vulnerabilityscanning_cli.change_host_scan_recipe_compartment.name)
host_scan_recipe_override_group.add_command(vulnerabilityscanning_cli.create_host_scan_recipe)
host_scan_recipe_override_group.add_command(vulnerabilityscanning_cli.get_host_scan_recipe)
host_scan_recipe_override_group.add_command(vulnerabilityscanning_cli.list_host_scan_recipes)
host_scan_recipe_override_group.add_command(vulnerabilityscanning_cli.update_host_scan_recipe)
host_scan_recipe_override_group.add_command(vulnerabilityscanning_cli.delete_host_scan_recipe)
host_scan_recipe_override_group.add_command(vulnerabilityscanning_cli.change_host_scan_recipe_compartment)

# move oci vulnerability-scanning host-scan-target <commands>
# to oci vulnerability-scanning host scan target <commands>
host_scan_group.add_command(host_scan_target_override_group)
vulnerabilityscanning_cli.vulnerability_scanning_root_group.commands.pop(vulnerabilityscanning_cli.host_scan_target_group.name)
vulnerabilityscanning_cli.host_scan_target_group.commands.pop(vulnerabilityscanning_cli.create_host_scan_target.name)
vulnerabilityscanning_cli.host_scan_target_group.commands.pop(vulnerabilityscanning_cli.get_host_scan_target.name)
vulnerabilityscanning_cli.host_scan_target_group.commands.pop(vulnerabilityscanning_cli.update_host_scan_target.name)
vulnerabilityscanning_cli.host_scan_target_group.commands.pop(vulnerabilityscanning_cli.delete_host_scan_target.name)
vulnerabilityscanning_cli.host_scan_target_group.commands.pop(vulnerabilityscanning_cli.list_host_scan_targets.name)
vulnerabilityscanning_cli.host_scan_target_group.commands.pop(vulnerabilityscanning_cli.change_host_scan_target_compartment.name)
host_scan_target_override_group.add_command(vulnerabilityscanning_cli.create_host_scan_target)
host_scan_target_override_group.add_command(vulnerabilityscanning_cli.get_host_scan_target)
host_scan_target_override_group.add_command(vulnerabilityscanning_cli.update_host_scan_target)
host_scan_target_override_group.add_command(vulnerabilityscanning_cli.delete_host_scan_target)
host_scan_target_override_group.add_command(vulnerabilityscanning_cli.list_host_scan_targets)
host_scan_target_override_group.add_command(vulnerabilityscanning_cli.change_host_scan_target_compartment)

#######################################
# container scan group/command changes
#######################################
# remove command: oci vulnerability-scanning container-scan-target create-container-scan-target-create-ocir-container-scan-registry-details
vulnerabilityscanning_cli.container_scan_target_group.commands.pop(vulnerabilityscanning_cli.create_container_scan_target_create_ocir_container_scan_registry_details.name)
# remove command: oci vulnerability-scanning container-scan-target update-container-scan-target-update-ocir-container-scan-registry-details
vulnerabilityscanning_cli.container_scan_target_group.commands.pop(vulnerabilityscanning_cli.update_container_scan_target_update_ocir_container_scan_registry_details.name)


# restructure commands
@click.command(cli_util.override('vulnerability_scanning.container_group.command_name', 'container'), cls=CommandGroupWithAlias, help="""A top level container command group""")
@cli_util.help_option_group
def container_group():
    pass


@click.command(cli_util.override('vulnerability_scanning.container_scan_group.command_name', 'scan'), cls=CommandGroupWithAlias, help="""A container scan command group""")
@cli_util.help_option_group
def container_scan_group():
    pass


@click.command(cli_util.override('vulnerability_scanning.container_scan_result_override_group.command_name', 'result'), cls=CommandGroupWithAlias, help="""A container scan result command group""")
@cli_util.help_option_group
def container_scan_result_override_group():
    pass


@click.command(cli_util.override('vulnerability_scanning.container_scan_target_override_group.command_name', 'target'), cls=CommandGroupWithAlias, help="""A container scan target command group""")
@cli_util.help_option_group
def container_scan_target_override_group():
    pass


@click.command(cli_util.override('vulnerability_scanning.container_scan_recipe_override_group.command_name', 'recipe'), cls=CommandGroupWithAlias, help="""A container scan recipe command group""")
@cli_util.help_option_group
def container_scan_recipe_override_group():
    pass


vulnerabilityscanning_cli.vulnerability_scanning_root_group.add_command(container_group)
container_group.add_command(container_scan_group)

# move oci vulnerability-scanning container-scan-recipe <commands>
# to oci vulnerability-scanning container scan recipe <commands>
container_scan_group.add_command(container_scan_recipe_override_group)
vulnerabilityscanning_cli.vulnerability_scanning_root_group.commands.pop(vulnerabilityscanning_cli.container_scan_recipe_group.name)
vulnerabilityscanning_cli.container_scan_recipe_group.commands.pop(vulnerabilityscanning_cli.create_container_scan_recipe.name)
vulnerabilityscanning_cli.container_scan_recipe_group.commands.pop(vulnerabilityscanning_cli.get_container_scan_recipe.name)
vulnerabilityscanning_cli.container_scan_recipe_group.commands.pop(vulnerabilityscanning_cli.update_container_scan_recipe.name)
vulnerabilityscanning_cli.container_scan_recipe_group.commands.pop(vulnerabilityscanning_cli.delete_container_scan_recipe.name)
vulnerabilityscanning_cli.container_scan_recipe_group.commands.pop(vulnerabilityscanning_cli.list_container_scan_recipes.name)
vulnerabilityscanning_cli.container_scan_recipe_group.commands.pop(vulnerabilityscanning_cli.change_container_scan_recipe_compartment.name)
container_scan_recipe_override_group.add_command(vulnerabilityscanning_cli.create_container_scan_recipe)
container_scan_recipe_override_group.add_command(vulnerabilityscanning_cli.get_container_scan_recipe)
container_scan_recipe_override_group.add_command(vulnerabilityscanning_cli.list_container_scan_recipes)
container_scan_recipe_override_group.add_command(vulnerabilityscanning_cli.update_container_scan_recipe)
container_scan_recipe_override_group.add_command(vulnerabilityscanning_cli.delete_container_scan_recipe)
container_scan_recipe_override_group.add_command(vulnerabilityscanning_cli.change_container_scan_recipe_compartment)

# move oci vulnerability-scanning container-scan-target <commands>
# to oci vulnerability-scanning container scan target <commands>
container_scan_group.add_command(container_scan_target_override_group)
vulnerabilityscanning_cli.vulnerability_scanning_root_group.commands.pop(vulnerabilityscanning_cli.container_scan_target_group.name)
vulnerabilityscanning_cli.container_scan_target_group.commands.pop(vulnerabilityscanning_cli.create_container_scan_target.name)
vulnerabilityscanning_cli.container_scan_target_group.commands.pop(vulnerabilityscanning_cli.get_container_scan_target.name)
vulnerabilityscanning_cli.container_scan_target_group.commands.pop(vulnerabilityscanning_cli.update_container_scan_target.name)
vulnerabilityscanning_cli.container_scan_target_group.commands.pop(vulnerabilityscanning_cli.delete_container_scan_target.name)
vulnerabilityscanning_cli.container_scan_target_group.commands.pop(vulnerabilityscanning_cli.list_container_scan_targets.name)
vulnerabilityscanning_cli.container_scan_target_group.commands.pop(vulnerabilityscanning_cli.change_container_scan_target_compartment.name)
container_scan_target_override_group.add_command(vulnerabilityscanning_cli.create_container_scan_target)
container_scan_target_override_group.add_command(vulnerabilityscanning_cli.get_container_scan_target)
container_scan_target_override_group.add_command(vulnerabilityscanning_cli.update_container_scan_target)
container_scan_target_override_group.add_command(vulnerabilityscanning_cli.delete_container_scan_target)
container_scan_target_override_group.add_command(vulnerabilityscanning_cli.list_container_scan_targets)
container_scan_target_override_group.add_command(vulnerabilityscanning_cli.change_container_scan_target_compartment)

# move oci vulnerability-scanning container-scan-result <commands>
# to oci vulnerability-scanning container scan result <commands>
container_scan_group.add_command(container_scan_result_override_group)
vulnerabilityscanning_cli.vulnerability_scanning_root_group.commands.pop(vulnerabilityscanning_cli.container_scan_result_group.name)
vulnerabilityscanning_cli.container_scan_result_group.commands.pop(vulnerabilityscanning_cli.get_container_scan_result.name)
vulnerabilityscanning_cli.container_scan_result_group.commands.pop(vulnerabilityscanning_cli.delete_container_scan_result.name)
vulnerabilityscanning_cli.container_scan_result_group.commands.pop(vulnerabilityscanning_cli.list_container_scan_results.name)
vulnerabilityscanning_cli.container_scan_result_group.commands.pop(vulnerabilityscanning_cli.change_container_scan_result_compartment.name)
container_scan_result_override_group.add_command(vulnerabilityscanning_cli.get_container_scan_result)
container_scan_result_override_group.add_command(vulnerabilityscanning_cli.delete_container_scan_result)
container_scan_result_override_group.add_command(vulnerabilityscanning_cli.list_container_scan_results)
container_scan_result_override_group.add_command(vulnerabilityscanning_cli.change_container_scan_result_compartment)
