# coding: utf-8
# Copyright (c) 2016, 2021, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

from __future__ import print_function
import click
import oci  # noqa: F401
import six  # noqa: F401
import sys  # noqa: F401
from oci_cli.cli_root import cli
from oci_cli import cli_constants  # noqa: F401
from oci_cli import cli_util
from oci_cli import json_skeleton_utils
from oci_cli import custom_types  # noqa: F401
from oci_cli.aliasing import CommandGroupWithAlias


@cli.command(cli_util.override('vulnerability_scanning.vulnerability_scanning_root_group.command_name', 'vulnerability-scanning'), cls=CommandGroupWithAlias, help=cli_util.override('vulnerability_scanning.vulnerability_scanning_root_group.help', """Use the Vulnerability Scanning Service (VSS) APIs to manage scan recipes, targets, and reports."""), short_help=cli_util.override('vulnerability_scanning.vulnerability_scanning_root_group.short_help', """Scanning API"""))
@cli_util.help_option_group
def vulnerability_scanning_root_group():
    pass


@click.command(cli_util.override('vulnerability_scanning.host_cis_benchmark_scan_result_group.command_name', 'host-cis-benchmark-scan-result'), cls=CommandGroupWithAlias, help="""A scan result of all CIS (Center for Internet Security) benchmark execution for this host""")
@cli_util.help_option_group
def host_cis_benchmark_scan_result_group():
    pass


@click.command(cli_util.override('vulnerability_scanning.host_scan_recipe_group.command_name', 'host-scan-recipe'), cls=CommandGroupWithAlias, help="""A host scan recipe (collection of host scanning configuration settings)""")
@cli_util.help_option_group
def host_scan_recipe_group():
    pass


@click.command(cli_util.override('vulnerability_scanning.host_vulnerability_group.command_name', 'host-vulnerability'), cls=CommandGroupWithAlias, help="""A vulnerability found in one or more host scans in a compartment""")
@cli_util.help_option_group
def host_vulnerability_group():
    pass


@click.command(cli_util.override('vulnerability_scanning.host_port_scan_result_group.command_name', 'host-port-scan-result'), cls=CommandGroupWithAlias, help="""A scan result for a host port scan""")
@cli_util.help_option_group
def host_port_scan_result_group():
    pass


@click.command(cli_util.override('vulnerability_scanning.work_request_log_entry_group.command_name', 'work-request-log-entry'), cls=CommandGroupWithAlias, help="""A log message from the execution of a work request.""")
@cli_util.help_option_group
def work_request_log_entry_group():
    pass


@click.command(cli_util.override('vulnerability_scanning.work_request_group.command_name', 'work-request'), cls=CommandGroupWithAlias, help="""A description of workrequest status""")
@cli_util.help_option_group
def work_request_group():
    pass


@click.command(cli_util.override('vulnerability_scanning.host_scan_target_group.command_name', 'host-scan-target'), cls=CommandGroupWithAlias, help="""A host scan target (application of a host scan recipe to a compartment or list of hosts)""")
@cli_util.help_option_group
def host_scan_target_group():
    pass


@click.command(cli_util.override('vulnerability_scanning.container_scan_result_group.command_name', 'container-scan-result'), cls=CommandGroupWithAlias, help="""A scan result for a container scan""")
@cli_util.help_option_group
def container_scan_result_group():
    pass


@click.command(cli_util.override('vulnerability_scanning.host_endpoint_protection_scan_result_group.command_name', 'host-endpoint-protection-scan-result'), cls=CommandGroupWithAlias, help="""A scan result for a host endpoint protection scan""")
@cli_util.help_option_group
def host_endpoint_protection_scan_result_group():
    pass


@click.command(cli_util.override('vulnerability_scanning.container_scan_target_group.command_name', 'container-scan-target'), cls=CommandGroupWithAlias, help="""A container scan target (application of a container scan recipe to the registry or list of repos)""")
@cli_util.help_option_group
def container_scan_target_group():
    pass


@click.command(cli_util.override('vulnerability_scanning.work_request_error_group.command_name', 'work-request-error'), cls=CommandGroupWithAlias, help="""An error encountered while executing a work request.""")
@cli_util.help_option_group
def work_request_error_group():
    pass


@click.command(cli_util.override('vulnerability_scanning.container_scan_recipe_group.command_name', 'container-scan-recipe'), cls=CommandGroupWithAlias, help="""A container scan recipe (collection of container scanning configuration settings)""")
@cli_util.help_option_group
def container_scan_recipe_group():
    pass


@click.command(cli_util.override('vulnerability_scanning.host_agent_scan_result_group.command_name', 'host-agent-scan-result'), cls=CommandGroupWithAlias, help="""A scan result for a host agent scan""")
@cli_util.help_option_group
def host_agent_scan_result_group():
    pass


vulnerability_scanning_root_group.add_command(host_cis_benchmark_scan_result_group)
vulnerability_scanning_root_group.add_command(host_scan_recipe_group)
vulnerability_scanning_root_group.add_command(host_vulnerability_group)
vulnerability_scanning_root_group.add_command(host_port_scan_result_group)
vulnerability_scanning_root_group.add_command(work_request_log_entry_group)
vulnerability_scanning_root_group.add_command(work_request_group)
vulnerability_scanning_root_group.add_command(host_scan_target_group)
vulnerability_scanning_root_group.add_command(container_scan_result_group)
vulnerability_scanning_root_group.add_command(host_endpoint_protection_scan_result_group)
vulnerability_scanning_root_group.add_command(container_scan_target_group)
vulnerability_scanning_root_group.add_command(work_request_error_group)
vulnerability_scanning_root_group.add_command(container_scan_recipe_group)
vulnerability_scanning_root_group.add_command(host_agent_scan_result_group)


@container_scan_recipe_group.command(name=cli_util.override('vulnerability_scanning.change_container_scan_recipe_compartment.command_name', 'change-compartment'), help=u"""Moves a ContainerScanRecipe into a different compartment. When provided, If-Match is checked against ETag values of the resource. \n[Command Reference](changeContainerScanRecipeCompartment)""")
@cli_util.option('--container-scan-recipe-id', required=True, help=u"""unique ContainerScanRecipe identifier""")
@cli_util.option('--compartment-id', required=True, help=u"""The [OCID] of the compartment into which the container scan recipe should be moved.""")
@cli_util.option('--if-match', help=u"""For optimistic concurrency control. In the PUT or DELETE call for a resource, set the `if-match` parameter to the value of the etag from a previous GET or POST response for that resource. The resource will be updated or deleted only if the etag you provide matches the resource's current etag value.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={})
@cli_util.wrap_exceptions
def change_container_scan_recipe_compartment(ctx, from_json, container_scan_recipe_id, compartment_id, if_match):

    if isinstance(container_scan_recipe_id, six.string_types) and len(container_scan_recipe_id.strip()) == 0:
        raise click.UsageError('Parameter --container-scan-recipe-id cannot be whitespace or empty string')

    kwargs = {}
    if if_match is not None:
        kwargs['if_match'] = if_match
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])

    _details = {}
    _details['compartmentId'] = compartment_id

    client = cli_util.build_client('vulnerability_scanning', 'vulnerability_scanning', ctx)
    result = client.change_container_scan_recipe_compartment(
        container_scan_recipe_id=container_scan_recipe_id,
        change_container_scan_recipe_compartment_details=_details,
        **kwargs
    )
    cli_util.render_response(result, ctx)


@container_scan_result_group.command(name=cli_util.override('vulnerability_scanning.change_container_scan_result_compartment.command_name', 'change-compartment'), help=u"""Moves a ContainerScanResult into a different compartment. When provided, If-Match is checked against ETag values of the resource. \n[Command Reference](changeContainerScanResultCompartment)""")
@cli_util.option('--container-scan-result-id', required=True, help=u"""unique container scan identifier""")
@cli_util.option('--compartment-id', required=True, help=u"""The [OCID] of the compartment into which the container scan should be moved.""")
@cli_util.option('--if-match', help=u"""For optimistic concurrency control. In the PUT or DELETE call for a resource, set the `if-match` parameter to the value of the etag from a previous GET or POST response for that resource. The resource will be updated or deleted only if the etag you provide matches the resource's current etag value.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={})
@cli_util.wrap_exceptions
def change_container_scan_result_compartment(ctx, from_json, container_scan_result_id, compartment_id, if_match):

    if isinstance(container_scan_result_id, six.string_types) and len(container_scan_result_id.strip()) == 0:
        raise click.UsageError('Parameter --container-scan-result-id cannot be whitespace or empty string')

    kwargs = {}
    if if_match is not None:
        kwargs['if_match'] = if_match
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])

    _details = {}
    _details['compartmentId'] = compartment_id

    client = cli_util.build_client('vulnerability_scanning', 'vulnerability_scanning', ctx)
    result = client.change_container_scan_result_compartment(
        container_scan_result_id=container_scan_result_id,
        change_container_scan_result_compartment_details=_details,
        **kwargs
    )
    cli_util.render_response(result, ctx)


@container_scan_target_group.command(name=cli_util.override('vulnerability_scanning.change_container_scan_target_compartment.command_name', 'change-compartment'), help=u"""Moves a ContainerScanTarget into a different compartment. When provided, If-Match is checked against ETag values of the resource. \n[Command Reference](changeContainerScanTargetCompartment)""")
@cli_util.option('--container-scan-target-id', required=True, help=u"""unique ContainerScanTarget identifier""")
@cli_util.option('--compartment-id', required=True, help=u"""The [OCID] of the compartment into which the container scan target should be moved.""")
@cli_util.option('--if-match', help=u"""For optimistic concurrency control. In the PUT or DELETE call for a resource, set the `if-match` parameter to the value of the etag from a previous GET or POST response for that resource. The resource will be updated or deleted only if the etag you provide matches the resource's current etag value.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={})
@cli_util.wrap_exceptions
def change_container_scan_target_compartment(ctx, from_json, container_scan_target_id, compartment_id, if_match):

    if isinstance(container_scan_target_id, six.string_types) and len(container_scan_target_id.strip()) == 0:
        raise click.UsageError('Parameter --container-scan-target-id cannot be whitespace or empty string')

    kwargs = {}
    if if_match is not None:
        kwargs['if_match'] = if_match
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])

    _details = {}
    _details['compartmentId'] = compartment_id

    client = cli_util.build_client('vulnerability_scanning', 'vulnerability_scanning', ctx)
    result = client.change_container_scan_target_compartment(
        container_scan_target_id=container_scan_target_id,
        change_container_scan_target_compartment_details=_details,
        **kwargs
    )
    cli_util.render_response(result, ctx)


@host_agent_scan_result_group.command(name=cli_util.override('vulnerability_scanning.change_host_agent_scan_result_compartment.command_name', 'change-compartment'), help=u"""Moves a HostAgentScanResult into a different compartment. When provided, If-Match is checked against ETag values of the resource. \n[Command Reference](changeHostAgentScanResultCompartment)""")
@cli_util.option('--host-agent-scan-result-id', required=True, help=u"""unique host agent scan identifier""")
@cli_util.option('--compartment-id', required=True, help=u"""The [OCID] of the compartment into which the host agent scan should be moved.""")
@cli_util.option('--if-match', help=u"""For optimistic concurrency control. In the PUT or DELETE call for a resource, set the `if-match` parameter to the value of the etag from a previous GET or POST response for that resource. The resource will be updated or deleted only if the etag you provide matches the resource's current etag value.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={})
@cli_util.wrap_exceptions
def change_host_agent_scan_result_compartment(ctx, from_json, host_agent_scan_result_id, compartment_id, if_match):

    if isinstance(host_agent_scan_result_id, six.string_types) and len(host_agent_scan_result_id.strip()) == 0:
        raise click.UsageError('Parameter --host-agent-scan-result-id cannot be whitespace or empty string')

    kwargs = {}
    if if_match is not None:
        kwargs['if_match'] = if_match
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])

    _details = {}
    _details['compartmentId'] = compartment_id

    client = cli_util.build_client('vulnerability_scanning', 'vulnerability_scanning', ctx)
    result = client.change_host_agent_scan_result_compartment(
        host_agent_scan_result_id=host_agent_scan_result_id,
        change_host_agent_scan_result_compartment_details=_details,
        **kwargs
    )
    cli_util.render_response(result, ctx)


@host_cis_benchmark_scan_result_group.command(name=cli_util.override('vulnerability_scanning.change_host_cis_benchmark_scan_result_compartment.command_name', 'change-compartment'), help=u"""Moves a HostCisBenchmarkScanResult into a different compartment. When provided, If-Match is checked against ETag values of the resource. \n[Command Reference](changeHostCisBenchmarkScanResultCompartment)""")
@cli_util.option('--host-cis-benchmark-scan-result-id', required=True, help=u"""unique host Cis benchmark scan identifier""")
@cli_util.option('--compartment-id', required=True, help=u"""The [OCID] of the compartment into which the host port scan should be moved.""")
@cli_util.option('--if-match', help=u"""For optimistic concurrency control. In the PUT or DELETE call for a resource, set the `if-match` parameter to the value of the etag from a previous GET or POST response for that resource. The resource will be updated or deleted only if the etag you provide matches the resource's current etag value.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={})
@cli_util.wrap_exceptions
def change_host_cis_benchmark_scan_result_compartment(ctx, from_json, host_cis_benchmark_scan_result_id, compartment_id, if_match):

    if isinstance(host_cis_benchmark_scan_result_id, six.string_types) and len(host_cis_benchmark_scan_result_id.strip()) == 0:
        raise click.UsageError('Parameter --host-cis-benchmark-scan-result-id cannot be whitespace or empty string')

    kwargs = {}
    if if_match is not None:
        kwargs['if_match'] = if_match
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])

    _details = {}
    _details['compartmentId'] = compartment_id

    client = cli_util.build_client('vulnerability_scanning', 'vulnerability_scanning', ctx)
    result = client.change_host_cis_benchmark_scan_result_compartment(
        host_cis_benchmark_scan_result_id=host_cis_benchmark_scan_result_id,
        change_host_cis_benchmark_scan_result_compartment_details=_details,
        **kwargs
    )
    cli_util.render_response(result, ctx)


@host_endpoint_protection_scan_result_group.command(name=cli_util.override('vulnerability_scanning.change_host_endpoint_protection_scan_result_compartment.command_name', 'change-compartment'), help=u"""Moves a HostEndpointProtectionScanResult into a different compartment. When provided, If-Match is checked against ETag values of the resource. \n[Command Reference](changeHostEndpointProtectionScanResultCompartment)""")
@cli_util.option('--host-endpoint-protection-scan-result-id', required=True, help=u"""unique host endpoint protection scan identifier""")
@cli_util.option('--compartment-id', required=True, help=u"""The [OCID] of the compartment into which the host port scan should be moved.""")
@cli_util.option('--if-match', help=u"""For optimistic concurrency control. In the PUT or DELETE call for a resource, set the `if-match` parameter to the value of the etag from a previous GET or POST response for that resource. The resource will be updated or deleted only if the etag you provide matches the resource's current etag value.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={})
@cli_util.wrap_exceptions
def change_host_endpoint_protection_scan_result_compartment(ctx, from_json, host_endpoint_protection_scan_result_id, compartment_id, if_match):

    if isinstance(host_endpoint_protection_scan_result_id, six.string_types) and len(host_endpoint_protection_scan_result_id.strip()) == 0:
        raise click.UsageError('Parameter --host-endpoint-protection-scan-result-id cannot be whitespace or empty string')

    kwargs = {}
    if if_match is not None:
        kwargs['if_match'] = if_match
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])

    _details = {}
    _details['compartmentId'] = compartment_id

    client = cli_util.build_client('vulnerability_scanning', 'vulnerability_scanning', ctx)
    result = client.change_host_endpoint_protection_scan_result_compartment(
        host_endpoint_protection_scan_result_id=host_endpoint_protection_scan_result_id,
        change_host_endpoint_protection_scan_result_compartment_details=_details,
        **kwargs
    )
    cli_util.render_response(result, ctx)


@host_port_scan_result_group.command(name=cli_util.override('vulnerability_scanning.change_host_port_scan_result_compartment.command_name', 'change-compartment'), help=u"""Moves a HostPortScanResult into a different compartment. When provided, If-Match is checked against ETag values of the resource. \n[Command Reference](changeHostPortScanResultCompartment)""")
@cli_util.option('--host-port-scan-result-id', required=True, help=u"""unique host port scan identifier""")
@cli_util.option('--compartment-id', required=True, help=u"""The [OCID] of the compartment into which the host port scan should be moved.""")
@cli_util.option('--if-match', help=u"""For optimistic concurrency control. In the PUT or DELETE call for a resource, set the `if-match` parameter to the value of the etag from a previous GET or POST response for that resource. The resource will be updated or deleted only if the etag you provide matches the resource's current etag value.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={})
@cli_util.wrap_exceptions
def change_host_port_scan_result_compartment(ctx, from_json, host_port_scan_result_id, compartment_id, if_match):

    if isinstance(host_port_scan_result_id, six.string_types) and len(host_port_scan_result_id.strip()) == 0:
        raise click.UsageError('Parameter --host-port-scan-result-id cannot be whitespace or empty string')

    kwargs = {}
    if if_match is not None:
        kwargs['if_match'] = if_match
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])

    _details = {}
    _details['compartmentId'] = compartment_id

    client = cli_util.build_client('vulnerability_scanning', 'vulnerability_scanning', ctx)
    result = client.change_host_port_scan_result_compartment(
        host_port_scan_result_id=host_port_scan_result_id,
        change_host_port_scan_result_compartment_details=_details,
        **kwargs
    )
    cli_util.render_response(result, ctx)


@host_scan_recipe_group.command(name=cli_util.override('vulnerability_scanning.change_host_scan_recipe_compartment.command_name', 'change-compartment'), help=u"""Moves a HostScanRecipe into a different compartment. When provided, If-Match is checked against ETag values of the resource. \n[Command Reference](changeHostScanRecipeCompartment)""")
@cli_util.option('--host-scan-recipe-id', required=True, help=u"""unique HostScanRecipe identifier""")
@cli_util.option('--compartment-id', required=True, help=u"""The [OCID] of the compartment into which the host scan recipe should be moved.""")
@cli_util.option('--if-match', help=u"""For optimistic concurrency control. In the PUT or DELETE call for a resource, set the `if-match` parameter to the value of the etag from a previous GET or POST response for that resource. The resource will be updated or deleted only if the etag you provide matches the resource's current etag value.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={})
@cli_util.wrap_exceptions
def change_host_scan_recipe_compartment(ctx, from_json, host_scan_recipe_id, compartment_id, if_match):

    if isinstance(host_scan_recipe_id, six.string_types) and len(host_scan_recipe_id.strip()) == 0:
        raise click.UsageError('Parameter --host-scan-recipe-id cannot be whitespace or empty string')

    kwargs = {}
    if if_match is not None:
        kwargs['if_match'] = if_match
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])

    _details = {}
    _details['compartmentId'] = compartment_id

    client = cli_util.build_client('vulnerability_scanning', 'vulnerability_scanning', ctx)
    result = client.change_host_scan_recipe_compartment(
        host_scan_recipe_id=host_scan_recipe_id,
        change_host_scan_recipe_compartment_details=_details,
        **kwargs
    )
    cli_util.render_response(result, ctx)


@host_scan_target_group.command(name=cli_util.override('vulnerability_scanning.change_host_scan_target_compartment.command_name', 'change-compartment'), help=u"""Moves a HostScanTarget into a different compartment. When provided, If-Match is checked against ETag values of the resource. \n[Command Reference](changeHostScanTargetCompartment)""")
@cli_util.option('--host-scan-target-id', required=True, help=u"""unique HostScanTarget identifier""")
@cli_util.option('--compartment-id', required=True, help=u"""The [OCID] of the compartment into which the host scan target should be moved.""")
@cli_util.option('--if-match', help=u"""For optimistic concurrency control. In the PUT or DELETE call for a resource, set the `if-match` parameter to the value of the etag from a previous GET or POST response for that resource. The resource will be updated or deleted only if the etag you provide matches the resource's current etag value.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={})
@cli_util.wrap_exceptions
def change_host_scan_target_compartment(ctx, from_json, host_scan_target_id, compartment_id, if_match):

    if isinstance(host_scan_target_id, six.string_types) and len(host_scan_target_id.strip()) == 0:
        raise click.UsageError('Parameter --host-scan-target-id cannot be whitespace or empty string')

    kwargs = {}
    if if_match is not None:
        kwargs['if_match'] = if_match
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])

    _details = {}
    _details['compartmentId'] = compartment_id

    client = cli_util.build_client('vulnerability_scanning', 'vulnerability_scanning', ctx)
    result = client.change_host_scan_target_compartment(
        host_scan_target_id=host_scan_target_id,
        change_host_scan_target_compartment_details=_details,
        **kwargs
    )
    cli_util.render_response(result, ctx)


@container_scan_recipe_group.command(name=cli_util.override('vulnerability_scanning.create_container_scan_recipe.command_name', 'create'), help=u"""Creates a new ContainerScanRecipe \n[Command Reference](createContainerScanRecipe)""")
@cli_util.option('--compartment-id', required=True, help=u"""The [OCID] of the container scan recipe's compartment""")
@cli_util.option('--scan-settings', required=True, type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--display-name', help=u"""User friendly name of container scan recipe. If not present, will be auto-generated.""")
@cli_util.option('--freeform-tags', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{\"bar-key\": \"value\"}`""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--defined-tags', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--wait-for-state', type=custom_types.CliCaseInsensitiveChoice(["ACCEPTED", "IN_PROGRESS", "FAILED", "SUCCEEDED"]), multiple=True, help="""This operation asynchronously creates, modifies or deletes a resource and uses a work request to track the progress of the operation. Specify this option to perform the action and then wait until the work request reaches a certain state. Multiple states can be specified, returning on the first state. For example, --wait-for-state SUCCEEDED --wait-for-state FAILED would return on whichever lifecycle state is reached first. If timeout is reached, a return code of 2 is returned. For any other error, a return code of 1 is returned.""")
@cli_util.option('--max-wait-seconds', type=click.INT, help="""The maximum time to wait for the work request to reach the state defined by --wait-for-state. Defaults to 1200 seconds.""")
@cli_util.option('--wait-interval-seconds', type=click.INT, help="""Check every --wait-interval-seconds to see whether the work request to see if it has reached the state defined by --wait-for-state. Defaults to 30 seconds.""")
@json_skeleton_utils.get_cli_json_input_option({'scan-settings': {'module': 'vulnerability_scanning', 'class': 'ContainerScanSettings'}, 'freeform-tags': {'module': 'vulnerability_scanning', 'class': 'dict(str, string)'}, 'defined-tags': {'module': 'vulnerability_scanning', 'class': 'dict(str, dict(str, object))'}})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={'scan-settings': {'module': 'vulnerability_scanning', 'class': 'ContainerScanSettings'}, 'freeform-tags': {'module': 'vulnerability_scanning', 'class': 'dict(str, string)'}, 'defined-tags': {'module': 'vulnerability_scanning', 'class': 'dict(str, dict(str, object))'}}, output_type={'module': 'vulnerability_scanning', 'class': 'ContainerScanRecipe'})
@cli_util.wrap_exceptions
def create_container_scan_recipe(ctx, from_json, wait_for_state, max_wait_seconds, wait_interval_seconds, compartment_id, scan_settings, display_name, freeform_tags, defined_tags):

    kwargs = {}
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])

    _details = {}
    _details['compartmentId'] = compartment_id
    _details['scanSettings'] = cli_util.parse_json_parameter("scan_settings", scan_settings)

    if display_name is not None:
        _details['displayName'] = display_name

    if freeform_tags is not None:
        _details['freeformTags'] = cli_util.parse_json_parameter("freeform_tags", freeform_tags)

    if defined_tags is not None:
        _details['definedTags'] = cli_util.parse_json_parameter("defined_tags", defined_tags)

    client = cli_util.build_client('vulnerability_scanning', 'vulnerability_scanning', ctx)
    result = client.create_container_scan_recipe(
        create_container_scan_recipe_details=_details,
        **kwargs
    )
    if wait_for_state:

        if hasattr(client, 'get_work_request') and callable(getattr(client, 'get_work_request')):
            try:
                wait_period_kwargs = {}
                if max_wait_seconds is not None:
                    wait_period_kwargs['max_wait_seconds'] = max_wait_seconds
                if wait_interval_seconds is not None:
                    wait_period_kwargs['max_interval_seconds'] = wait_interval_seconds

                click.echo('Action completed. Waiting until the work request has entered state: {}'.format(wait_for_state), file=sys.stderr)
                result = oci.wait_until(client, client.get_work_request(result.headers['opc-work-request-id']), 'status', wait_for_state, **wait_period_kwargs)
            except oci.exceptions.MaximumWaitTimeExceeded as e:
                # If we fail, we should show an error, but we should still provide the information to the customer
                click.echo('Failed to wait until the work request entered the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                sys.exit(2)
            except Exception:
                click.echo('Encountered error while waiting for work request to enter the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                raise
        else:
            click.echo('Unable to wait for the work request to enter the specified state', file=sys.stderr)
    cli_util.render_response(result, ctx)


@container_scan_target_group.command(name=cli_util.override('vulnerability_scanning.create_container_scan_target.command_name', 'create'), help=u"""Creates a new ContainerScanTarget \n[Command Reference](createContainerScanTarget)""")
@cli_util.option('--compartment-id', required=True, help=u"""The [OCID] of the container scan target's compartment""")
@cli_util.option('--target-registry', required=True, type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--container-scan-recipe-id', required=True, help=u"""ID of the container scan recipe this target applies.""")
@cli_util.option('--display-name', help=u"""User friendly name of container scan target. If not present, will be auto-generated.""")
@cli_util.option('--description', help=u"""Target description.""")
@cli_util.option('--freeform-tags', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{\"bar-key\": \"value\"}`""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--defined-tags', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--wait-for-state', type=custom_types.CliCaseInsensitiveChoice(["ACCEPTED", "IN_PROGRESS", "FAILED", "SUCCEEDED"]), multiple=True, help="""This operation asynchronously creates, modifies or deletes a resource and uses a work request to track the progress of the operation. Specify this option to perform the action and then wait until the work request reaches a certain state. Multiple states can be specified, returning on the first state. For example, --wait-for-state SUCCEEDED --wait-for-state FAILED would return on whichever lifecycle state is reached first. If timeout is reached, a return code of 2 is returned. For any other error, a return code of 1 is returned.""")
@cli_util.option('--max-wait-seconds', type=click.INT, help="""The maximum time to wait for the work request to reach the state defined by --wait-for-state. Defaults to 1200 seconds.""")
@cli_util.option('--wait-interval-seconds', type=click.INT, help="""Check every --wait-interval-seconds to see whether the work request to see if it has reached the state defined by --wait-for-state. Defaults to 30 seconds.""")
@json_skeleton_utils.get_cli_json_input_option({'target-registry': {'module': 'vulnerability_scanning', 'class': 'CreateContainerScanRegistryDetails'}, 'freeform-tags': {'module': 'vulnerability_scanning', 'class': 'dict(str, string)'}, 'defined-tags': {'module': 'vulnerability_scanning', 'class': 'dict(str, dict(str, object))'}})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={'target-registry': {'module': 'vulnerability_scanning', 'class': 'CreateContainerScanRegistryDetails'}, 'freeform-tags': {'module': 'vulnerability_scanning', 'class': 'dict(str, string)'}, 'defined-tags': {'module': 'vulnerability_scanning', 'class': 'dict(str, dict(str, object))'}}, output_type={'module': 'vulnerability_scanning', 'class': 'ContainerScanTarget'})
@cli_util.wrap_exceptions
def create_container_scan_target(ctx, from_json, wait_for_state, max_wait_seconds, wait_interval_seconds, compartment_id, target_registry, container_scan_recipe_id, display_name, description, freeform_tags, defined_tags):

    kwargs = {}
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])

    _details = {}
    _details['compartmentId'] = compartment_id
    _details['targetRegistry'] = cli_util.parse_json_parameter("target_registry", target_registry)
    _details['containerScanRecipeId'] = container_scan_recipe_id

    if display_name is not None:
        _details['displayName'] = display_name

    if description is not None:
        _details['description'] = description

    if freeform_tags is not None:
        _details['freeformTags'] = cli_util.parse_json_parameter("freeform_tags", freeform_tags)

    if defined_tags is not None:
        _details['definedTags'] = cli_util.parse_json_parameter("defined_tags", defined_tags)

    client = cli_util.build_client('vulnerability_scanning', 'vulnerability_scanning', ctx)
    result = client.create_container_scan_target(
        create_container_scan_target_details=_details,
        **kwargs
    )
    if wait_for_state:

        if hasattr(client, 'get_work_request') and callable(getattr(client, 'get_work_request')):
            try:
                wait_period_kwargs = {}
                if max_wait_seconds is not None:
                    wait_period_kwargs['max_wait_seconds'] = max_wait_seconds
                if wait_interval_seconds is not None:
                    wait_period_kwargs['max_interval_seconds'] = wait_interval_seconds

                click.echo('Action completed. Waiting until the work request has entered state: {}'.format(wait_for_state), file=sys.stderr)
                result = oci.wait_until(client, client.get_work_request(result.headers['opc-work-request-id']), 'status', wait_for_state, **wait_period_kwargs)
            except oci.exceptions.MaximumWaitTimeExceeded as e:
                # If we fail, we should show an error, but we should still provide the information to the customer
                click.echo('Failed to wait until the work request entered the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                sys.exit(2)
            except Exception:
                click.echo('Encountered error while waiting for work request to enter the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                raise
        else:
            click.echo('Unable to wait for the work request to enter the specified state', file=sys.stderr)
    cli_util.render_response(result, ctx)


@container_scan_target_group.command(name=cli_util.override('vulnerability_scanning.create_container_scan_target_create_ocir_container_scan_registry_details.command_name', 'create-container-scan-target-create-ocir-container-scan-registry-details'), help=u"""Creates a new ContainerScanTarget \n[Command Reference](createContainerScanTarget)""")
@cli_util.option('--compartment-id', required=True, help=u"""The [OCID] of the container scan target's compartment""")
@cli_util.option('--container-scan-recipe-id', required=True, help=u"""ID of the container scan recipe this target applies.""")
@cli_util.option('--target-registry-compartment-id', required=True, help=u"""The [OCID] of the compartment to perform the scans in. All listed repositories must be in the compartment.""")
@cli_util.option('--display-name', help=u"""User friendly name of container scan target. If not present, will be auto-generated.""")
@cli_util.option('--description', help=u"""Target description.""")
@cli_util.option('--freeform-tags', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{\"bar-key\": \"value\"}`""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--defined-tags', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--target-registry-url', help=u"""URL of the registry. Required for non-OCIR registry types (for OCIR registry types, it can be inferred from the tenancy).""")
@cli_util.option('--target-registry-repositories', type=custom_types.CLI_COMPLEX_TYPE, help=u"""List of repositories to scan images in. If left empty, the target defaults to scanning all repos in the compartmentId""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--wait-for-state', type=custom_types.CliCaseInsensitiveChoice(["ACCEPTED", "IN_PROGRESS", "FAILED", "SUCCEEDED"]), multiple=True, help="""This operation asynchronously creates, modifies or deletes a resource and uses a work request to track the progress of the operation. Specify this option to perform the action and then wait until the work request reaches a certain state. Multiple states can be specified, returning on the first state. For example, --wait-for-state SUCCEEDED --wait-for-state FAILED would return on whichever lifecycle state is reached first. If timeout is reached, a return code of 2 is returned. For any other error, a return code of 1 is returned.""")
@cli_util.option('--max-wait-seconds', type=click.INT, help="""The maximum time to wait for the work request to reach the state defined by --wait-for-state. Defaults to 1200 seconds.""")
@cli_util.option('--wait-interval-seconds', type=click.INT, help="""Check every --wait-interval-seconds to see whether the work request to see if it has reached the state defined by --wait-for-state. Defaults to 30 seconds.""")
@json_skeleton_utils.get_cli_json_input_option({'freeform-tags': {'module': 'vulnerability_scanning', 'class': 'dict(str, string)'}, 'defined-tags': {'module': 'vulnerability_scanning', 'class': 'dict(str, dict(str, object))'}, 'target-registry-repositories': {'module': 'vulnerability_scanning', 'class': 'list[string]'}})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={'freeform-tags': {'module': 'vulnerability_scanning', 'class': 'dict(str, string)'}, 'defined-tags': {'module': 'vulnerability_scanning', 'class': 'dict(str, dict(str, object))'}, 'target-registry-repositories': {'module': 'vulnerability_scanning', 'class': 'list[string]'}}, output_type={'module': 'vulnerability_scanning', 'class': 'ContainerScanTarget'})
@cli_util.wrap_exceptions
def create_container_scan_target_create_ocir_container_scan_registry_details(ctx, from_json, wait_for_state, max_wait_seconds, wait_interval_seconds, compartment_id, container_scan_recipe_id, target_registry_compartment_id, display_name, description, freeform_tags, defined_tags, target_registry_url, target_registry_repositories):

    kwargs = {}
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])

    _details = {}
    _details['targetRegistry'] = {}
    _details['compartmentId'] = compartment_id
    _details['containerScanRecipeId'] = container_scan_recipe_id
    _details['targetRegistry']['compartmentId'] = target_registry_compartment_id

    if display_name is not None:
        _details['displayName'] = display_name

    if description is not None:
        _details['description'] = description

    if freeform_tags is not None:
        _details['freeformTags'] = cli_util.parse_json_parameter("freeform_tags", freeform_tags)

    if defined_tags is not None:
        _details['definedTags'] = cli_util.parse_json_parameter("defined_tags", defined_tags)

    if target_registry_url is not None:
        _details['targetRegistry']['url'] = target_registry_url

    if target_registry_repositories is not None:
        _details['targetRegistry']['repositories'] = cli_util.parse_json_parameter("target_registry_repositories", target_registry_repositories)

    _details['targetRegistry']['type'] = 'OCIR'

    client = cli_util.build_client('vulnerability_scanning', 'vulnerability_scanning', ctx)
    result = client.create_container_scan_target(
        create_container_scan_target_details=_details,
        **kwargs
    )
    if wait_for_state:

        if hasattr(client, 'get_work_request') and callable(getattr(client, 'get_work_request')):
            try:
                wait_period_kwargs = {}
                if max_wait_seconds is not None:
                    wait_period_kwargs['max_wait_seconds'] = max_wait_seconds
                if wait_interval_seconds is not None:
                    wait_period_kwargs['max_interval_seconds'] = wait_interval_seconds

                click.echo('Action completed. Waiting until the work request has entered state: {}'.format(wait_for_state), file=sys.stderr)
                result = oci.wait_until(client, client.get_work_request(result.headers['opc-work-request-id']), 'status', wait_for_state, **wait_period_kwargs)
            except oci.exceptions.MaximumWaitTimeExceeded as e:
                # If we fail, we should show an error, but we should still provide the information to the customer
                click.echo('Failed to wait until the work request entered the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                sys.exit(2)
            except Exception:
                click.echo('Encountered error while waiting for work request to enter the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                raise
        else:
            click.echo('Unable to wait for the work request to enter the specified state', file=sys.stderr)
    cli_util.render_response(result, ctx)


@host_scan_recipe_group.command(name=cli_util.override('vulnerability_scanning.create_host_scan_recipe.command_name', 'create'), help=u"""Creates a new HostScanRecipe. A recipe determines the types of security issues that you want scanned, and how often to scan. \n[Command Reference](createHostScanRecipe)""")
@cli_util.option('--compartment-id', required=True, help=u"""Compartment ID of the scanning config. If no individual hosts are specified, all hosts in this compartment are scanned""")
@cli_util.option('--port-settings', required=True, type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--agent-settings', required=True, type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--schedule', required=True, type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--display-name', help=u"""Recipe identifier, which can be renamed. If not present, it will be auto-generated. Avoid entering confidential information.""")
@cli_util.option('--freeform-tags', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{\"bar-key\": \"value\"}`""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--defined-tags', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--wait-for-state', type=custom_types.CliCaseInsensitiveChoice(["ACCEPTED", "IN_PROGRESS", "FAILED", "SUCCEEDED"]), multiple=True, help="""This operation asynchronously creates, modifies or deletes a resource and uses a work request to track the progress of the operation. Specify this option to perform the action and then wait until the work request reaches a certain state. Multiple states can be specified, returning on the first state. For example, --wait-for-state SUCCEEDED --wait-for-state FAILED would return on whichever lifecycle state is reached first. If timeout is reached, a return code of 2 is returned. For any other error, a return code of 1 is returned.""")
@cli_util.option('--max-wait-seconds', type=click.INT, help="""The maximum time to wait for the work request to reach the state defined by --wait-for-state. Defaults to 1200 seconds.""")
@cli_util.option('--wait-interval-seconds', type=click.INT, help="""Check every --wait-interval-seconds to see whether the work request to see if it has reached the state defined by --wait-for-state. Defaults to 30 seconds.""")
@json_skeleton_utils.get_cli_json_input_option({'port-settings': {'module': 'vulnerability_scanning', 'class': 'HostScanPortSettings'}, 'agent-settings': {'module': 'vulnerability_scanning', 'class': 'HostScanAgentSettings'}, 'schedule': {'module': 'vulnerability_scanning', 'class': 'Schedule'}, 'freeform-tags': {'module': 'vulnerability_scanning', 'class': 'dict(str, string)'}, 'defined-tags': {'module': 'vulnerability_scanning', 'class': 'dict(str, dict(str, object))'}})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={'port-settings': {'module': 'vulnerability_scanning', 'class': 'HostScanPortSettings'}, 'agent-settings': {'module': 'vulnerability_scanning', 'class': 'HostScanAgentSettings'}, 'schedule': {'module': 'vulnerability_scanning', 'class': 'Schedule'}, 'freeform-tags': {'module': 'vulnerability_scanning', 'class': 'dict(str, string)'}, 'defined-tags': {'module': 'vulnerability_scanning', 'class': 'dict(str, dict(str, object))'}}, output_type={'module': 'vulnerability_scanning', 'class': 'HostScanRecipe'})
@cli_util.wrap_exceptions
def create_host_scan_recipe(ctx, from_json, wait_for_state, max_wait_seconds, wait_interval_seconds, compartment_id, port_settings, agent_settings, schedule, display_name, freeform_tags, defined_tags):

    kwargs = {}
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])

    _details = {}
    _details['compartmentId'] = compartment_id
    _details['portSettings'] = cli_util.parse_json_parameter("port_settings", port_settings)
    _details['agentSettings'] = cli_util.parse_json_parameter("agent_settings", agent_settings)
    _details['schedule'] = cli_util.parse_json_parameter("schedule", schedule)

    if display_name is not None:
        _details['displayName'] = display_name

    if freeform_tags is not None:
        _details['freeformTags'] = cli_util.parse_json_parameter("freeform_tags", freeform_tags)

    if defined_tags is not None:
        _details['definedTags'] = cli_util.parse_json_parameter("defined_tags", defined_tags)

    client = cli_util.build_client('vulnerability_scanning', 'vulnerability_scanning', ctx)
    result = client.create_host_scan_recipe(
        create_host_scan_recipe_details=_details,
        **kwargs
    )
    if wait_for_state:

        if hasattr(client, 'get_work_request') and callable(getattr(client, 'get_work_request')):
            try:
                wait_period_kwargs = {}
                if max_wait_seconds is not None:
                    wait_period_kwargs['max_wait_seconds'] = max_wait_seconds
                if wait_interval_seconds is not None:
                    wait_period_kwargs['max_interval_seconds'] = wait_interval_seconds

                click.echo('Action completed. Waiting until the work request has entered state: {}'.format(wait_for_state), file=sys.stderr)
                result = oci.wait_until(client, client.get_work_request(result.headers['opc-work-request-id']), 'status', wait_for_state, **wait_period_kwargs)
            except oci.exceptions.MaximumWaitTimeExceeded as e:
                # If we fail, we should show an error, but we should still provide the information to the customer
                click.echo('Failed to wait until the work request entered the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                sys.exit(2)
            except Exception:
                click.echo('Encountered error while waiting for work request to enter the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                raise
        else:
            click.echo('Unable to wait for the work request to enter the specified state', file=sys.stderr)
    cli_util.render_response(result, ctx)


@host_scan_target_group.command(name=cli_util.override('vulnerability_scanning.create_host_scan_target.command_name', 'create'), help=u"""Creates a new HostScanTarget. A host scan target is a collection of compute instances that you want routinely scanned for security vulnerabilities. \n[Command Reference](createHostScanTarget)""")
@cli_util.option('--compartment-id', required=True, help=u"""Compartment ID of the object (this).""")
@cli_util.option('--target-compartment-id', required=True, help=u"""Compartment ID to target. If a list of hosts is provided, all hosts must be in this compartment.""")
@cli_util.option('--host-scan-recipe-id', required=True, help=u"""ID of the host scan recipe this target applies.""")
@cli_util.option('--display-name', help=u"""Target identifier, which can be renamed. If not present, it will be auto-generated. Avoid entering confidential information.""")
@cli_util.option('--description', help=u"""Target description.""")
@cli_util.option('--instance-ids', type=custom_types.CLI_COMPLEX_TYPE, help=u"""List of compute instance IDs to target (optional). If empty, targets the entire targetCompartmentId.""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--freeform-tags', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{\"bar-key\": \"value\"}`""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--defined-tags', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--wait-for-state', type=custom_types.CliCaseInsensitiveChoice(["ACCEPTED", "IN_PROGRESS", "FAILED", "SUCCEEDED"]), multiple=True, help="""This operation asynchronously creates, modifies or deletes a resource and uses a work request to track the progress of the operation. Specify this option to perform the action and then wait until the work request reaches a certain state. Multiple states can be specified, returning on the first state. For example, --wait-for-state SUCCEEDED --wait-for-state FAILED would return on whichever lifecycle state is reached first. If timeout is reached, a return code of 2 is returned. For any other error, a return code of 1 is returned.""")
@cli_util.option('--max-wait-seconds', type=click.INT, help="""The maximum time to wait for the work request to reach the state defined by --wait-for-state. Defaults to 1200 seconds.""")
@cli_util.option('--wait-interval-seconds', type=click.INT, help="""Check every --wait-interval-seconds to see whether the work request to see if it has reached the state defined by --wait-for-state. Defaults to 30 seconds.""")
@json_skeleton_utils.get_cli_json_input_option({'instance-ids': {'module': 'vulnerability_scanning', 'class': 'list[string]'}, 'freeform-tags': {'module': 'vulnerability_scanning', 'class': 'dict(str, string)'}, 'defined-tags': {'module': 'vulnerability_scanning', 'class': 'dict(str, dict(str, object))'}})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={'instance-ids': {'module': 'vulnerability_scanning', 'class': 'list[string]'}, 'freeform-tags': {'module': 'vulnerability_scanning', 'class': 'dict(str, string)'}, 'defined-tags': {'module': 'vulnerability_scanning', 'class': 'dict(str, dict(str, object))'}}, output_type={'module': 'vulnerability_scanning', 'class': 'HostScanTarget'})
@cli_util.wrap_exceptions
def create_host_scan_target(ctx, from_json, wait_for_state, max_wait_seconds, wait_interval_seconds, compartment_id, target_compartment_id, host_scan_recipe_id, display_name, description, instance_ids, freeform_tags, defined_tags):

    kwargs = {}
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])

    _details = {}
    _details['compartmentId'] = compartment_id
    _details['targetCompartmentId'] = target_compartment_id
    _details['hostScanRecipeId'] = host_scan_recipe_id

    if display_name is not None:
        _details['displayName'] = display_name

    if description is not None:
        _details['description'] = description

    if instance_ids is not None:
        _details['instanceIds'] = cli_util.parse_json_parameter("instance_ids", instance_ids)

    if freeform_tags is not None:
        _details['freeformTags'] = cli_util.parse_json_parameter("freeform_tags", freeform_tags)

    if defined_tags is not None:
        _details['definedTags'] = cli_util.parse_json_parameter("defined_tags", defined_tags)

    client = cli_util.build_client('vulnerability_scanning', 'vulnerability_scanning', ctx)
    result = client.create_host_scan_target(
        create_host_scan_target_details=_details,
        **kwargs
    )
    if wait_for_state:

        if hasattr(client, 'get_work_request') and callable(getattr(client, 'get_work_request')):
            try:
                wait_period_kwargs = {}
                if max_wait_seconds is not None:
                    wait_period_kwargs['max_wait_seconds'] = max_wait_seconds
                if wait_interval_seconds is not None:
                    wait_period_kwargs['max_interval_seconds'] = wait_interval_seconds

                click.echo('Action completed. Waiting until the work request has entered state: {}'.format(wait_for_state), file=sys.stderr)
                result = oci.wait_until(client, client.get_work_request(result.headers['opc-work-request-id']), 'status', wait_for_state, **wait_period_kwargs)
            except oci.exceptions.MaximumWaitTimeExceeded as e:
                # If we fail, we should show an error, but we should still provide the information to the customer
                click.echo('Failed to wait until the work request entered the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                sys.exit(2)
            except Exception:
                click.echo('Encountered error while waiting for work request to enter the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                raise
        else:
            click.echo('Unable to wait for the work request to enter the specified state', file=sys.stderr)
    cli_util.render_response(result, ctx)


@container_scan_recipe_group.command(name=cli_util.override('vulnerability_scanning.delete_container_scan_recipe.command_name', 'delete'), help=u"""Deletes the ContainerScanRecipe identified by the id \n[Command Reference](deleteContainerScanRecipe)""")
@cli_util.option('--container-scan-recipe-id', required=True, help=u"""unique ContainerScanRecipe identifier""")
@cli_util.option('--if-match', help=u"""For optimistic concurrency control. In the PUT or DELETE call for a resource, set the `if-match` parameter to the value of the etag from a previous GET or POST response for that resource. The resource will be updated or deleted only if the etag you provide matches the resource's current etag value.""")
@cli_util.confirm_delete_option
@cli_util.option('--wait-for-state', type=custom_types.CliCaseInsensitiveChoice(["ACCEPTED", "IN_PROGRESS", "FAILED", "SUCCEEDED"]), multiple=True, help="""This operation asynchronously creates, modifies or deletes a resource and uses a work request to track the progress of the operation. Specify this option to perform the action and then wait until the work request reaches a certain state. Multiple states can be specified, returning on the first state. For example, --wait-for-state SUCCEEDED --wait-for-state FAILED would return on whichever lifecycle state is reached first. If timeout is reached, a return code of 2 is returned. For any other error, a return code of 1 is returned.""")
@cli_util.option('--max-wait-seconds', type=click.INT, help="""The maximum time to wait for the work request to reach the state defined by --wait-for-state. Defaults to 1200 seconds.""")
@cli_util.option('--wait-interval-seconds', type=click.INT, help="""Check every --wait-interval-seconds to see whether the work request to see if it has reached the state defined by --wait-for-state. Defaults to 30 seconds.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={})
@cli_util.wrap_exceptions
def delete_container_scan_recipe(ctx, from_json, wait_for_state, max_wait_seconds, wait_interval_seconds, container_scan_recipe_id, if_match):

    if isinstance(container_scan_recipe_id, six.string_types) and len(container_scan_recipe_id.strip()) == 0:
        raise click.UsageError('Parameter --container-scan-recipe-id cannot be whitespace or empty string')

    kwargs = {}
    if if_match is not None:
        kwargs['if_match'] = if_match
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('vulnerability_scanning', 'vulnerability_scanning', ctx)
    result = client.delete_container_scan_recipe(
        container_scan_recipe_id=container_scan_recipe_id,
        **kwargs
    )
    if wait_for_state:

        if hasattr(client, 'get_work_request') and callable(getattr(client, 'get_work_request')):
            try:
                wait_period_kwargs = {}
                if max_wait_seconds is not None:
                    wait_period_kwargs['max_wait_seconds'] = max_wait_seconds
                if wait_interval_seconds is not None:
                    wait_period_kwargs['max_interval_seconds'] = wait_interval_seconds

                click.echo('Action completed. Waiting until the work request has entered state: {}'.format(wait_for_state), file=sys.stderr)
                result = oci.wait_until(client, client.get_work_request(result.headers['opc-work-request-id']), 'status', wait_for_state, **wait_period_kwargs)
            except oci.exceptions.MaximumWaitTimeExceeded as e:
                # If we fail, we should show an error, but we should still provide the information to the customer
                click.echo('Failed to wait until the work request entered the specified state. Please retrieve the work request to find its current state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                sys.exit(2)
            except Exception:
                click.echo('Encountered error while waiting for work request to enter the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                raise
        else:
            click.echo('Unable to wait for the work request to enter the specified state', file=sys.stderr)
    cli_util.render_response(result, ctx)


@container_scan_result_group.command(name=cli_util.override('vulnerability_scanning.delete_container_scan_result.command_name', 'delete'), help=u"""Deletes the ContainerScanResult identified by the id \n[Command Reference](deleteContainerScanResult)""")
@cli_util.option('--container-scan-result-id', required=True, help=u"""unique container scan identifier""")
@cli_util.option('--if-match', help=u"""For optimistic concurrency control. In the PUT or DELETE call for a resource, set the `if-match` parameter to the value of the etag from a previous GET or POST response for that resource. The resource will be updated or deleted only if the etag you provide matches the resource's current etag value.""")
@cli_util.confirm_delete_option
@cli_util.option('--wait-for-state', type=custom_types.CliCaseInsensitiveChoice(["ACCEPTED", "IN_PROGRESS", "FAILED", "SUCCEEDED"]), multiple=True, help="""This operation asynchronously creates, modifies or deletes a resource and uses a work request to track the progress of the operation. Specify this option to perform the action and then wait until the work request reaches a certain state. Multiple states can be specified, returning on the first state. For example, --wait-for-state SUCCEEDED --wait-for-state FAILED would return on whichever lifecycle state is reached first. If timeout is reached, a return code of 2 is returned. For any other error, a return code of 1 is returned.""")
@cli_util.option('--max-wait-seconds', type=click.INT, help="""The maximum time to wait for the work request to reach the state defined by --wait-for-state. Defaults to 1200 seconds.""")
@cli_util.option('--wait-interval-seconds', type=click.INT, help="""Check every --wait-interval-seconds to see whether the work request to see if it has reached the state defined by --wait-for-state. Defaults to 30 seconds.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={})
@cli_util.wrap_exceptions
def delete_container_scan_result(ctx, from_json, wait_for_state, max_wait_seconds, wait_interval_seconds, container_scan_result_id, if_match):

    if isinstance(container_scan_result_id, six.string_types) and len(container_scan_result_id.strip()) == 0:
        raise click.UsageError('Parameter --container-scan-result-id cannot be whitespace or empty string')

    kwargs = {}
    if if_match is not None:
        kwargs['if_match'] = if_match
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('vulnerability_scanning', 'vulnerability_scanning', ctx)
    result = client.delete_container_scan_result(
        container_scan_result_id=container_scan_result_id,
        **kwargs
    )
    if wait_for_state:

        if hasattr(client, 'get_work_request') and callable(getattr(client, 'get_work_request')):
            try:
                wait_period_kwargs = {}
                if max_wait_seconds is not None:
                    wait_period_kwargs['max_wait_seconds'] = max_wait_seconds
                if wait_interval_seconds is not None:
                    wait_period_kwargs['max_interval_seconds'] = wait_interval_seconds

                click.echo('Action completed. Waiting until the work request has entered state: {}'.format(wait_for_state), file=sys.stderr)
                result = oci.wait_until(client, client.get_work_request(result.headers['opc-work-request-id']), 'status', wait_for_state, **wait_period_kwargs)
            except oci.exceptions.MaximumWaitTimeExceeded as e:
                # If we fail, we should show an error, but we should still provide the information to the customer
                click.echo('Failed to wait until the work request entered the specified state. Please retrieve the work request to find its current state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                sys.exit(2)
            except Exception:
                click.echo('Encountered error while waiting for work request to enter the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                raise
        else:
            click.echo('Unable to wait for the work request to enter the specified state', file=sys.stderr)
    cli_util.render_response(result, ctx)


@container_scan_target_group.command(name=cli_util.override('vulnerability_scanning.delete_container_scan_target.command_name', 'delete'), help=u"""Deletes the ContainerScanTarget identified by the id \n[Command Reference](deleteContainerScanTarget)""")
@cli_util.option('--container-scan-target-id', required=True, help=u"""unique ContainerScanTarget identifier""")
@cli_util.option('--if-match', help=u"""For optimistic concurrency control. In the PUT or DELETE call for a resource, set the `if-match` parameter to the value of the etag from a previous GET or POST response for that resource. The resource will be updated or deleted only if the etag you provide matches the resource's current etag value.""")
@cli_util.confirm_delete_option
@cli_util.option('--wait-for-state', type=custom_types.CliCaseInsensitiveChoice(["ACCEPTED", "IN_PROGRESS", "FAILED", "SUCCEEDED"]), multiple=True, help="""This operation asynchronously creates, modifies or deletes a resource and uses a work request to track the progress of the operation. Specify this option to perform the action and then wait until the work request reaches a certain state. Multiple states can be specified, returning on the first state. For example, --wait-for-state SUCCEEDED --wait-for-state FAILED would return on whichever lifecycle state is reached first. If timeout is reached, a return code of 2 is returned. For any other error, a return code of 1 is returned.""")
@cli_util.option('--max-wait-seconds', type=click.INT, help="""The maximum time to wait for the work request to reach the state defined by --wait-for-state. Defaults to 1200 seconds.""")
@cli_util.option('--wait-interval-seconds', type=click.INT, help="""Check every --wait-interval-seconds to see whether the work request to see if it has reached the state defined by --wait-for-state. Defaults to 30 seconds.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={})
@cli_util.wrap_exceptions
def delete_container_scan_target(ctx, from_json, wait_for_state, max_wait_seconds, wait_interval_seconds, container_scan_target_id, if_match):

    if isinstance(container_scan_target_id, six.string_types) and len(container_scan_target_id.strip()) == 0:
        raise click.UsageError('Parameter --container-scan-target-id cannot be whitespace or empty string')

    kwargs = {}
    if if_match is not None:
        kwargs['if_match'] = if_match
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('vulnerability_scanning', 'vulnerability_scanning', ctx)
    result = client.delete_container_scan_target(
        container_scan_target_id=container_scan_target_id,
        **kwargs
    )
    if wait_for_state:

        if hasattr(client, 'get_work_request') and callable(getattr(client, 'get_work_request')):
            try:
                wait_period_kwargs = {}
                if max_wait_seconds is not None:
                    wait_period_kwargs['max_wait_seconds'] = max_wait_seconds
                if wait_interval_seconds is not None:
                    wait_period_kwargs['max_interval_seconds'] = wait_interval_seconds

                click.echo('Action completed. Waiting until the work request has entered state: {}'.format(wait_for_state), file=sys.stderr)
                result = oci.wait_until(client, client.get_work_request(result.headers['opc-work-request-id']), 'status', wait_for_state, **wait_period_kwargs)
            except oci.exceptions.MaximumWaitTimeExceeded as e:
                # If we fail, we should show an error, but we should still provide the information to the customer
                click.echo('Failed to wait until the work request entered the specified state. Please retrieve the work request to find its current state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                sys.exit(2)
            except Exception:
                click.echo('Encountered error while waiting for work request to enter the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                raise
        else:
            click.echo('Unable to wait for the work request to enter the specified state', file=sys.stderr)
    cli_util.render_response(result, ctx)


@host_agent_scan_result_group.command(name=cli_util.override('vulnerability_scanning.delete_host_agent_scan_result.command_name', 'delete'), help=u"""Removes the HostAgentScanResult identified by the host agent scan ID. \n[Command Reference](deleteHostAgentScanResult)""")
@cli_util.option('--host-agent-scan-result-id', required=True, help=u"""unique host agent scan identifier""")
@cli_util.option('--if-match', help=u"""For optimistic concurrency control. In the PUT or DELETE call for a resource, set the `if-match` parameter to the value of the etag from a previous GET or POST response for that resource. The resource will be updated or deleted only if the etag you provide matches the resource's current etag value.""")
@cli_util.confirm_delete_option
@cli_util.option('--wait-for-state', type=custom_types.CliCaseInsensitiveChoice(["ACCEPTED", "IN_PROGRESS", "FAILED", "SUCCEEDED"]), multiple=True, help="""This operation asynchronously creates, modifies or deletes a resource and uses a work request to track the progress of the operation. Specify this option to perform the action and then wait until the work request reaches a certain state. Multiple states can be specified, returning on the first state. For example, --wait-for-state SUCCEEDED --wait-for-state FAILED would return on whichever lifecycle state is reached first. If timeout is reached, a return code of 2 is returned. For any other error, a return code of 1 is returned.""")
@cli_util.option('--max-wait-seconds', type=click.INT, help="""The maximum time to wait for the work request to reach the state defined by --wait-for-state. Defaults to 1200 seconds.""")
@cli_util.option('--wait-interval-seconds', type=click.INT, help="""Check every --wait-interval-seconds to see whether the work request to see if it has reached the state defined by --wait-for-state. Defaults to 30 seconds.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={})
@cli_util.wrap_exceptions
def delete_host_agent_scan_result(ctx, from_json, wait_for_state, max_wait_seconds, wait_interval_seconds, host_agent_scan_result_id, if_match):

    if isinstance(host_agent_scan_result_id, six.string_types) and len(host_agent_scan_result_id.strip()) == 0:
        raise click.UsageError('Parameter --host-agent-scan-result-id cannot be whitespace or empty string')

    kwargs = {}
    if if_match is not None:
        kwargs['if_match'] = if_match
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('vulnerability_scanning', 'vulnerability_scanning', ctx)
    result = client.delete_host_agent_scan_result(
        host_agent_scan_result_id=host_agent_scan_result_id,
        **kwargs
    )
    if wait_for_state:

        if hasattr(client, 'get_work_request') and callable(getattr(client, 'get_work_request')):
            try:
                wait_period_kwargs = {}
                if max_wait_seconds is not None:
                    wait_period_kwargs['max_wait_seconds'] = max_wait_seconds
                if wait_interval_seconds is not None:
                    wait_period_kwargs['max_interval_seconds'] = wait_interval_seconds

                click.echo('Action completed. Waiting until the work request has entered state: {}'.format(wait_for_state), file=sys.stderr)
                result = oci.wait_until(client, client.get_work_request(result.headers['opc-work-request-id']), 'status', wait_for_state, **wait_period_kwargs)
            except oci.exceptions.MaximumWaitTimeExceeded as e:
                # If we fail, we should show an error, but we should still provide the information to the customer
                click.echo('Failed to wait until the work request entered the specified state. Please retrieve the work request to find its current state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                sys.exit(2)
            except Exception:
                click.echo('Encountered error while waiting for work request to enter the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                raise
        else:
            click.echo('Unable to wait for the work request to enter the specified state', file=sys.stderr)
    cli_util.render_response(result, ctx)


@host_cis_benchmark_scan_result_group.command(name=cli_util.override('vulnerability_scanning.delete_host_cis_benchmark_scan_result.command_name', 'delete'), help=u"""Deletes the HostCisBenchmarkScanResult identified by the id \n[Command Reference](deleteHostCisBenchmarkScanResult)""")
@cli_util.option('--host-cis-benchmark-scan-result-id', required=True, help=u"""unique host Cis benchmark scan identifier""")
@cli_util.option('--if-match', help=u"""For optimistic concurrency control. In the PUT or DELETE call for a resource, set the `if-match` parameter to the value of the etag from a previous GET or POST response for that resource. The resource will be updated or deleted only if the etag you provide matches the resource's current etag value.""")
@cli_util.confirm_delete_option
@cli_util.option('--wait-for-state', type=custom_types.CliCaseInsensitiveChoice(["ACCEPTED", "IN_PROGRESS", "FAILED", "SUCCEEDED"]), multiple=True, help="""This operation asynchronously creates, modifies or deletes a resource and uses a work request to track the progress of the operation. Specify this option to perform the action and then wait until the work request reaches a certain state. Multiple states can be specified, returning on the first state. For example, --wait-for-state SUCCEEDED --wait-for-state FAILED would return on whichever lifecycle state is reached first. If timeout is reached, a return code of 2 is returned. For any other error, a return code of 1 is returned.""")
@cli_util.option('--max-wait-seconds', type=click.INT, help="""The maximum time to wait for the work request to reach the state defined by --wait-for-state. Defaults to 1200 seconds.""")
@cli_util.option('--wait-interval-seconds', type=click.INT, help="""Check every --wait-interval-seconds to see whether the work request to see if it has reached the state defined by --wait-for-state. Defaults to 30 seconds.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={})
@cli_util.wrap_exceptions
def delete_host_cis_benchmark_scan_result(ctx, from_json, wait_for_state, max_wait_seconds, wait_interval_seconds, host_cis_benchmark_scan_result_id, if_match):

    if isinstance(host_cis_benchmark_scan_result_id, six.string_types) and len(host_cis_benchmark_scan_result_id.strip()) == 0:
        raise click.UsageError('Parameter --host-cis-benchmark-scan-result-id cannot be whitespace or empty string')

    kwargs = {}
    if if_match is not None:
        kwargs['if_match'] = if_match
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('vulnerability_scanning', 'vulnerability_scanning', ctx)
    result = client.delete_host_cis_benchmark_scan_result(
        host_cis_benchmark_scan_result_id=host_cis_benchmark_scan_result_id,
        **kwargs
    )
    if wait_for_state:

        if hasattr(client, 'get_work_request') and callable(getattr(client, 'get_work_request')):
            try:
                wait_period_kwargs = {}
                if max_wait_seconds is not None:
                    wait_period_kwargs['max_wait_seconds'] = max_wait_seconds
                if wait_interval_seconds is not None:
                    wait_period_kwargs['max_interval_seconds'] = wait_interval_seconds

                click.echo('Action completed. Waiting until the work request has entered state: {}'.format(wait_for_state), file=sys.stderr)
                result = oci.wait_until(client, client.get_work_request(result.headers['opc-work-request-id']), 'status', wait_for_state, **wait_period_kwargs)
            except oci.exceptions.MaximumWaitTimeExceeded as e:
                # If we fail, we should show an error, but we should still provide the information to the customer
                click.echo('Failed to wait until the work request entered the specified state. Please retrieve the work request to find its current state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                sys.exit(2)
            except Exception:
                click.echo('Encountered error while waiting for work request to enter the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                raise
        else:
            click.echo('Unable to wait for the work request to enter the specified state', file=sys.stderr)
    cli_util.render_response(result, ctx)


@host_endpoint_protection_scan_result_group.command(name=cli_util.override('vulnerability_scanning.delete_host_endpoint_protection_scan_result.command_name', 'delete'), help=u"""Deletes the HostEndpointProtectionScanResult identified by the id \n[Command Reference](deleteHostEndpointProtectionScanResult)""")
@cli_util.option('--host-endpoint-protection-scan-result-id', required=True, help=u"""unique host endpoint protection scan identifier""")
@cli_util.option('--if-match', help=u"""For optimistic concurrency control. In the PUT or DELETE call for a resource, set the `if-match` parameter to the value of the etag from a previous GET or POST response for that resource. The resource will be updated or deleted only if the etag you provide matches the resource's current etag value.""")
@cli_util.confirm_delete_option
@cli_util.option('--wait-for-state', type=custom_types.CliCaseInsensitiveChoice(["ACCEPTED", "IN_PROGRESS", "FAILED", "SUCCEEDED"]), multiple=True, help="""This operation asynchronously creates, modifies or deletes a resource and uses a work request to track the progress of the operation. Specify this option to perform the action and then wait until the work request reaches a certain state. Multiple states can be specified, returning on the first state. For example, --wait-for-state SUCCEEDED --wait-for-state FAILED would return on whichever lifecycle state is reached first. If timeout is reached, a return code of 2 is returned. For any other error, a return code of 1 is returned.""")
@cli_util.option('--max-wait-seconds', type=click.INT, help="""The maximum time to wait for the work request to reach the state defined by --wait-for-state. Defaults to 1200 seconds.""")
@cli_util.option('--wait-interval-seconds', type=click.INT, help="""Check every --wait-interval-seconds to see whether the work request to see if it has reached the state defined by --wait-for-state. Defaults to 30 seconds.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={})
@cli_util.wrap_exceptions
def delete_host_endpoint_protection_scan_result(ctx, from_json, wait_for_state, max_wait_seconds, wait_interval_seconds, host_endpoint_protection_scan_result_id, if_match):

    if isinstance(host_endpoint_protection_scan_result_id, six.string_types) and len(host_endpoint_protection_scan_result_id.strip()) == 0:
        raise click.UsageError('Parameter --host-endpoint-protection-scan-result-id cannot be whitespace or empty string')

    kwargs = {}
    if if_match is not None:
        kwargs['if_match'] = if_match
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('vulnerability_scanning', 'vulnerability_scanning', ctx)
    result = client.delete_host_endpoint_protection_scan_result(
        host_endpoint_protection_scan_result_id=host_endpoint_protection_scan_result_id,
        **kwargs
    )
    if wait_for_state:

        if hasattr(client, 'get_work_request') and callable(getattr(client, 'get_work_request')):
            try:
                wait_period_kwargs = {}
                if max_wait_seconds is not None:
                    wait_period_kwargs['max_wait_seconds'] = max_wait_seconds
                if wait_interval_seconds is not None:
                    wait_period_kwargs['max_interval_seconds'] = wait_interval_seconds

                click.echo('Action completed. Waiting until the work request has entered state: {}'.format(wait_for_state), file=sys.stderr)
                result = oci.wait_until(client, client.get_work_request(result.headers['opc-work-request-id']), 'status', wait_for_state, **wait_period_kwargs)
            except oci.exceptions.MaximumWaitTimeExceeded as e:
                # If we fail, we should show an error, but we should still provide the information to the customer
                click.echo('Failed to wait until the work request entered the specified state. Please retrieve the work request to find its current state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                sys.exit(2)
            except Exception:
                click.echo('Encountered error while waiting for work request to enter the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                raise
        else:
            click.echo('Unable to wait for the work request to enter the specified state', file=sys.stderr)
    cli_util.render_response(result, ctx)


@host_port_scan_result_group.command(name=cli_util.override('vulnerability_scanning.delete_host_port_scan_result.command_name', 'delete'), help=u"""Removes the HostPortScanResult identified by the host port scan ID. \n[Command Reference](deleteHostPortScanResult)""")
@cli_util.option('--host-port-scan-result-id', required=True, help=u"""unique host port scan identifier""")
@cli_util.option('--if-match', help=u"""For optimistic concurrency control. In the PUT or DELETE call for a resource, set the `if-match` parameter to the value of the etag from a previous GET or POST response for that resource. The resource will be updated or deleted only if the etag you provide matches the resource's current etag value.""")
@cli_util.confirm_delete_option
@cli_util.option('--wait-for-state', type=custom_types.CliCaseInsensitiveChoice(["ACCEPTED", "IN_PROGRESS", "FAILED", "SUCCEEDED"]), multiple=True, help="""This operation asynchronously creates, modifies or deletes a resource and uses a work request to track the progress of the operation. Specify this option to perform the action and then wait until the work request reaches a certain state. Multiple states can be specified, returning on the first state. For example, --wait-for-state SUCCEEDED --wait-for-state FAILED would return on whichever lifecycle state is reached first. If timeout is reached, a return code of 2 is returned. For any other error, a return code of 1 is returned.""")
@cli_util.option('--max-wait-seconds', type=click.INT, help="""The maximum time to wait for the work request to reach the state defined by --wait-for-state. Defaults to 1200 seconds.""")
@cli_util.option('--wait-interval-seconds', type=click.INT, help="""Check every --wait-interval-seconds to see whether the work request to see if it has reached the state defined by --wait-for-state. Defaults to 30 seconds.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={})
@cli_util.wrap_exceptions
def delete_host_port_scan_result(ctx, from_json, wait_for_state, max_wait_seconds, wait_interval_seconds, host_port_scan_result_id, if_match):

    if isinstance(host_port_scan_result_id, six.string_types) and len(host_port_scan_result_id.strip()) == 0:
        raise click.UsageError('Parameter --host-port-scan-result-id cannot be whitespace or empty string')

    kwargs = {}
    if if_match is not None:
        kwargs['if_match'] = if_match
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('vulnerability_scanning', 'vulnerability_scanning', ctx)
    result = client.delete_host_port_scan_result(
        host_port_scan_result_id=host_port_scan_result_id,
        **kwargs
    )
    if wait_for_state:

        if hasattr(client, 'get_work_request') and callable(getattr(client, 'get_work_request')):
            try:
                wait_period_kwargs = {}
                if max_wait_seconds is not None:
                    wait_period_kwargs['max_wait_seconds'] = max_wait_seconds
                if wait_interval_seconds is not None:
                    wait_period_kwargs['max_interval_seconds'] = wait_interval_seconds

                click.echo('Action completed. Waiting until the work request has entered state: {}'.format(wait_for_state), file=sys.stderr)
                result = oci.wait_until(client, client.get_work_request(result.headers['opc-work-request-id']), 'status', wait_for_state, **wait_period_kwargs)
            except oci.exceptions.MaximumWaitTimeExceeded as e:
                # If we fail, we should show an error, but we should still provide the information to the customer
                click.echo('Failed to wait until the work request entered the specified state. Please retrieve the work request to find its current state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                sys.exit(2)
            except Exception:
                click.echo('Encountered error while waiting for work request to enter the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                raise
        else:
            click.echo('Unable to wait for the work request to enter the specified state', file=sys.stderr)
    cli_util.render_response(result, ctx)


@host_scan_recipe_group.command(name=cli_util.override('vulnerability_scanning.delete_host_scan_recipe.command_name', 'delete'), help=u"""Removes the HostScanRecipe identified by the recipe ID. \n[Command Reference](deleteHostScanRecipe)""")
@cli_util.option('--host-scan-recipe-id', required=True, help=u"""unique HostScanRecipe identifier""")
@cli_util.option('--if-match', help=u"""For optimistic concurrency control. In the PUT or DELETE call for a resource, set the `if-match` parameter to the value of the etag from a previous GET or POST response for that resource. The resource will be updated or deleted only if the etag you provide matches the resource's current etag value.""")
@cli_util.confirm_delete_option
@cli_util.option('--wait-for-state', type=custom_types.CliCaseInsensitiveChoice(["ACCEPTED", "IN_PROGRESS", "FAILED", "SUCCEEDED"]), multiple=True, help="""This operation asynchronously creates, modifies or deletes a resource and uses a work request to track the progress of the operation. Specify this option to perform the action and then wait until the work request reaches a certain state. Multiple states can be specified, returning on the first state. For example, --wait-for-state SUCCEEDED --wait-for-state FAILED would return on whichever lifecycle state is reached first. If timeout is reached, a return code of 2 is returned. For any other error, a return code of 1 is returned.""")
@cli_util.option('--max-wait-seconds', type=click.INT, help="""The maximum time to wait for the work request to reach the state defined by --wait-for-state. Defaults to 1200 seconds.""")
@cli_util.option('--wait-interval-seconds', type=click.INT, help="""Check every --wait-interval-seconds to see whether the work request to see if it has reached the state defined by --wait-for-state. Defaults to 30 seconds.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={})
@cli_util.wrap_exceptions
def delete_host_scan_recipe(ctx, from_json, wait_for_state, max_wait_seconds, wait_interval_seconds, host_scan_recipe_id, if_match):

    if isinstance(host_scan_recipe_id, six.string_types) and len(host_scan_recipe_id.strip()) == 0:
        raise click.UsageError('Parameter --host-scan-recipe-id cannot be whitespace or empty string')

    kwargs = {}
    if if_match is not None:
        kwargs['if_match'] = if_match
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('vulnerability_scanning', 'vulnerability_scanning', ctx)
    result = client.delete_host_scan_recipe(
        host_scan_recipe_id=host_scan_recipe_id,
        **kwargs
    )
    if wait_for_state:

        if hasattr(client, 'get_work_request') and callable(getattr(client, 'get_work_request')):
            try:
                wait_period_kwargs = {}
                if max_wait_seconds is not None:
                    wait_period_kwargs['max_wait_seconds'] = max_wait_seconds
                if wait_interval_seconds is not None:
                    wait_period_kwargs['max_interval_seconds'] = wait_interval_seconds

                click.echo('Action completed. Waiting until the work request has entered state: {}'.format(wait_for_state), file=sys.stderr)
                result = oci.wait_until(client, client.get_work_request(result.headers['opc-work-request-id']), 'status', wait_for_state, **wait_period_kwargs)
            except oci.exceptions.MaximumWaitTimeExceeded as e:
                # If we fail, we should show an error, but we should still provide the information to the customer
                click.echo('Failed to wait until the work request entered the specified state. Please retrieve the work request to find its current state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                sys.exit(2)
            except Exception:
                click.echo('Encountered error while waiting for work request to enter the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                raise
        else:
            click.echo('Unable to wait for the work request to enter the specified state', file=sys.stderr)
    cli_util.render_response(result, ctx)


@host_scan_target_group.command(name=cli_util.override('vulnerability_scanning.delete_host_scan_target.command_name', 'delete'), help=u"""Removes the HostScanTarget identified by the target ID. \n[Command Reference](deleteHostScanTarget)""")
@cli_util.option('--host-scan-target-id', required=True, help=u"""unique HostScanTarget identifier""")
@cli_util.option('--if-match', help=u"""For optimistic concurrency control. In the PUT or DELETE call for a resource, set the `if-match` parameter to the value of the etag from a previous GET or POST response for that resource. The resource will be updated or deleted only if the etag you provide matches the resource's current etag value.""")
@cli_util.confirm_delete_option
@cli_util.option('--wait-for-state', type=custom_types.CliCaseInsensitiveChoice(["ACCEPTED", "IN_PROGRESS", "FAILED", "SUCCEEDED"]), multiple=True, help="""This operation asynchronously creates, modifies or deletes a resource and uses a work request to track the progress of the operation. Specify this option to perform the action and then wait until the work request reaches a certain state. Multiple states can be specified, returning on the first state. For example, --wait-for-state SUCCEEDED --wait-for-state FAILED would return on whichever lifecycle state is reached first. If timeout is reached, a return code of 2 is returned. For any other error, a return code of 1 is returned.""")
@cli_util.option('--max-wait-seconds', type=click.INT, help="""The maximum time to wait for the work request to reach the state defined by --wait-for-state. Defaults to 1200 seconds.""")
@cli_util.option('--wait-interval-seconds', type=click.INT, help="""Check every --wait-interval-seconds to see whether the work request to see if it has reached the state defined by --wait-for-state. Defaults to 30 seconds.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={})
@cli_util.wrap_exceptions
def delete_host_scan_target(ctx, from_json, wait_for_state, max_wait_seconds, wait_interval_seconds, host_scan_target_id, if_match):

    if isinstance(host_scan_target_id, six.string_types) and len(host_scan_target_id.strip()) == 0:
        raise click.UsageError('Parameter --host-scan-target-id cannot be whitespace or empty string')

    kwargs = {}
    if if_match is not None:
        kwargs['if_match'] = if_match
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('vulnerability_scanning', 'vulnerability_scanning', ctx)
    result = client.delete_host_scan_target(
        host_scan_target_id=host_scan_target_id,
        **kwargs
    )
    if wait_for_state:

        if hasattr(client, 'get_work_request') and callable(getattr(client, 'get_work_request')):
            try:
                wait_period_kwargs = {}
                if max_wait_seconds is not None:
                    wait_period_kwargs['max_wait_seconds'] = max_wait_seconds
                if wait_interval_seconds is not None:
                    wait_period_kwargs['max_interval_seconds'] = wait_interval_seconds

                click.echo('Action completed. Waiting until the work request has entered state: {}'.format(wait_for_state), file=sys.stderr)
                result = oci.wait_until(client, client.get_work_request(result.headers['opc-work-request-id']), 'status', wait_for_state, **wait_period_kwargs)
            except oci.exceptions.MaximumWaitTimeExceeded as e:
                # If we fail, we should show an error, but we should still provide the information to the customer
                click.echo('Failed to wait until the work request entered the specified state. Please retrieve the work request to find its current state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                sys.exit(2)
            except Exception:
                click.echo('Encountered error while waiting for work request to enter the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                raise
        else:
            click.echo('Unable to wait for the work request to enter the specified state', file=sys.stderr)
    cli_util.render_response(result, ctx)


@host_agent_scan_result_group.command(name=cli_util.override('vulnerability_scanning.export_host_agent_scan_result_csv.command_name', 'export-host-agent-scan-result-csv'), help=u"""Exports a list of HostAgentScanResultSummary objects within a compartment and during a specified time range in CSV format. You can filter the results by problem severity. \n[Command Reference](exportHostAgentScanResultCsv)""")
@cli_util.option('--compartment-id', required=True, help=u"""The [OCID] of the compartment to list scans in.""")
@cli_util.option('--time-started-after', required=True, type=custom_types.CLI_DATETIME, help=u"""Date and time after which scans were started, as described in [RFC 3339]""" + custom_types.CLI_DATETIME.VALID_DATETIME_CLI_HELP_MESSAGE)
@cli_util.option('--time-started-before', required=True, type=custom_types.CLI_DATETIME, help=u"""Date and time before which scans were started, as described in [RFC 3339]""" + custom_types.CLI_DATETIME.VALID_DATETIME_CLI_HELP_MESSAGE)
@cli_util.option('--file', type=click.File(mode='wb'), required=True, help="The name of the file that will receive the response data, or '-' to write to STDOUT.")
@cli_util.option('--highest-problem-severity', type=custom_types.CliCaseInsensitiveChoice(["NONE", "LOW", "MEDIUM", "HIGH", "CRITICAL"]), help=u"""Parameter to filter by highestProblemSeverity for scan results""")
@cli_util.option('--instance-id', help=u"""Parameter to filter by a single compute instance ID for scan results""")
@cli_util.option('--operating-system', help=u"""Parameter to filter by operating system for scan results""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={})
@cli_util.wrap_exceptions
def export_host_agent_scan_result_csv(ctx, from_json, file, compartment_id, time_started_after, time_started_before, highest_problem_severity, instance_id, operating_system):

    kwargs = {}
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])

    _details = {}
    _details['compartmentId'] = compartment_id
    _details['timeStartedAfter'] = time_started_after
    _details['timeStartedBefore'] = time_started_before

    if highest_problem_severity is not None:
        _details['highestProblemSeverity'] = highest_problem_severity

    if instance_id is not None:
        _details['instanceId'] = instance_id

    if operating_system is not None:
        _details['operatingSystem'] = operating_system

    client = cli_util.build_client('vulnerability_scanning', 'vulnerability_scanning', ctx)
    result = client.export_host_agent_scan_result_csv(
        export_host_agent_scan_result_csv_details=_details,
        **kwargs
    )

    # If outputting to stdout we don't want to print a progress bar because it will get mixed up with the output
    # Also we need a non-zero Content-Length in order to display a meaningful progress bar
    bar = None
    if hasattr(file, 'name') and file.name != '<stdout>' and 'Content-Length' in result.headers:
        content_length = int(result.headers['Content-Length'])
        if content_length > 0:
            bar = click.progressbar(length=content_length, label='Downloading file')

    try:
        if bar:
            bar.__enter__()

        # TODO: Make the download size a configurable option
        # use decode_content=True to automatically unzip service responses (this should be overridden for object storage)
        for chunk in result.data.raw.stream(cli_constants.MEBIBYTE, decode_content=True):
            if bar:
                bar.update(len(chunk))
            file.write(chunk)
    finally:
        if bar:
            bar.render_finish()
        file.close()


@host_vulnerability_group.command(name=cli_util.override('vulnerability_scanning.export_host_vulnerability_csv.command_name', 'export-host-vulnerability-csv'), help=u"""Exports a list of HostVulnerabilitySummary objects in a compartment in CSV format. \n[Command Reference](exportHostVulnerabilityCsv)""")
@cli_util.option('--compartment-id', required=True, help=u"""The [OCID] of the compartment to list vulnerabilities in.""")
@cli_util.option('--time-last-detected-greater-than-or-equal-to', required=True, type=custom_types.CLI_DATETIME, help=u"""Date and time on or after which this vulnerability was last detected, as described in [RFC 3339]""" + custom_types.CLI_DATETIME.VALID_DATETIME_CLI_HELP_MESSAGE)
@cli_util.option('--time-last-detected-less-than-or-equal-to', required=True, type=custom_types.CLI_DATETIME, help=u"""Date and time on or before which this vulnerability was last detected, as described in [RFC 3339]""" + custom_types.CLI_DATETIME.VALID_DATETIME_CLI_HELP_MESSAGE)
@cli_util.option('--file', type=click.File(mode='wb'), required=True, help="The name of the file that will receive the response data, or '-' to write to STDOUT.")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={})
@cli_util.wrap_exceptions
def export_host_vulnerability_csv(ctx, from_json, file, compartment_id, time_last_detected_greater_than_or_equal_to, time_last_detected_less_than_or_equal_to):

    kwargs = {}
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])

    _details = {}
    _details['compartmentId'] = compartment_id
    _details['timeLastDetectedGreaterThanOrEqualTo'] = time_last_detected_greater_than_or_equal_to
    _details['timeLastDetectedLessThanOrEqualTo'] = time_last_detected_less_than_or_equal_to

    client = cli_util.build_client('vulnerability_scanning', 'vulnerability_scanning', ctx)
    result = client.export_host_vulnerability_csv(
        export_host_vulnerability_csv_details=_details,
        **kwargs
    )

    # If outputting to stdout we don't want to print a progress bar because it will get mixed up with the output
    # Also we need a non-zero Content-Length in order to display a meaningful progress bar
    bar = None
    if hasattr(file, 'name') and file.name != '<stdout>' and 'Content-Length' in result.headers:
        content_length = int(result.headers['Content-Length'])
        if content_length > 0:
            bar = click.progressbar(length=content_length, label='Downloading file')

    try:
        if bar:
            bar.__enter__()

        # TODO: Make the download size a configurable option
        # use decode_content=True to automatically unzip service responses (this should be overridden for object storage)
        for chunk in result.data.raw.stream(cli_constants.MEBIBYTE, decode_content=True):
            if bar:
                bar.update(len(chunk))
            file.write(chunk)
    finally:
        if bar:
            bar.render_finish()
        file.close()


@container_scan_recipe_group.command(name=cli_util.override('vulnerability_scanning.get_container_scan_recipe.command_name', 'get'), help=u"""Gets a ContainerScanRecipe by identifier \n[Command Reference](getContainerScanRecipe)""")
@cli_util.option('--container-scan-recipe-id', required=True, help=u"""unique ContainerScanRecipe identifier""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'vulnerability_scanning', 'class': 'ContainerScanRecipe'})
@cli_util.wrap_exceptions
def get_container_scan_recipe(ctx, from_json, container_scan_recipe_id):

    if isinstance(container_scan_recipe_id, six.string_types) and len(container_scan_recipe_id.strip()) == 0:
        raise click.UsageError('Parameter --container-scan-recipe-id cannot be whitespace or empty string')

    kwargs = {}
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('vulnerability_scanning', 'vulnerability_scanning', ctx)
    result = client.get_container_scan_recipe(
        container_scan_recipe_id=container_scan_recipe_id,
        **kwargs
    )
    cli_util.render_response(result, ctx)


@container_scan_result_group.command(name=cli_util.override('vulnerability_scanning.get_container_scan_result.command_name', 'get'), help=u"""Returns a ContainerScanResult of the given container scan ID. \n[Command Reference](getContainerScanResult)""")
@cli_util.option('--container-scan-result-id', required=True, help=u"""unique container scan identifier""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'vulnerability_scanning', 'class': 'ContainerScanResult'})
@cli_util.wrap_exceptions
def get_container_scan_result(ctx, from_json, container_scan_result_id):

    if isinstance(container_scan_result_id, six.string_types) and len(container_scan_result_id.strip()) == 0:
        raise click.UsageError('Parameter --container-scan-result-id cannot be whitespace or empty string')

    kwargs = {}
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('vulnerability_scanning', 'vulnerability_scanning', ctx)
    result = client.get_container_scan_result(
        container_scan_result_id=container_scan_result_id,
        **kwargs
    )
    cli_util.render_response(result, ctx)


@container_scan_target_group.command(name=cli_util.override('vulnerability_scanning.get_container_scan_target.command_name', 'get'), help=u"""Gets a ContainerScanTarget by identifier \n[Command Reference](getContainerScanTarget)""")
@cli_util.option('--container-scan-target-id', required=True, help=u"""unique ContainerScanTarget identifier""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'vulnerability_scanning', 'class': 'ContainerScanTarget'})
@cli_util.wrap_exceptions
def get_container_scan_target(ctx, from_json, container_scan_target_id):

    if isinstance(container_scan_target_id, six.string_types) and len(container_scan_target_id.strip()) == 0:
        raise click.UsageError('Parameter --container-scan-target-id cannot be whitespace or empty string')

    kwargs = {}
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('vulnerability_scanning', 'vulnerability_scanning', ctx)
    result = client.get_container_scan_target(
        container_scan_target_id=container_scan_target_id,
        **kwargs
    )
    cli_util.render_response(result, ctx)


@host_agent_scan_result_group.command(name=cli_util.override('vulnerability_scanning.get_host_agent_scan_result.command_name', 'get'), help=u"""Retrieves a HostAgentScanResult identified by the host agent scan ID. The result includes a list of problems detected in a specific compute instance. \n[Command Reference](getHostAgentScanResult)""")
@cli_util.option('--host-agent-scan-result-id', required=True, help=u"""unique host agent scan identifier""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'vulnerability_scanning', 'class': 'HostAgentScanResult'})
@cli_util.wrap_exceptions
def get_host_agent_scan_result(ctx, from_json, host_agent_scan_result_id):

    if isinstance(host_agent_scan_result_id, six.string_types) and len(host_agent_scan_result_id.strip()) == 0:
        raise click.UsageError('Parameter --host-agent-scan-result-id cannot be whitespace or empty string')

    kwargs = {}
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('vulnerability_scanning', 'vulnerability_scanning', ctx)
    result = client.get_host_agent_scan_result(
        host_agent_scan_result_id=host_agent_scan_result_id,
        **kwargs
    )
    cli_util.render_response(result, ctx)


@host_cis_benchmark_scan_result_group.command(name=cli_util.override('vulnerability_scanning.get_host_cis_benchmark_scan_result.command_name', 'get'), help=u"""Returns HostCisBenchmarkScanResults for the given host CIS (Center for Internet Security) benchmark scan result ID. \n[Command Reference](getHostCisBenchmarkScanResult)""")
@cli_util.option('--host-cis-benchmark-scan-result-id', required=True, help=u"""unique host Cis benchmark scan identifier""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'vulnerability_scanning', 'class': 'HostCisBenchmarkScanResult'})
@cli_util.wrap_exceptions
def get_host_cis_benchmark_scan_result(ctx, from_json, host_cis_benchmark_scan_result_id):

    if isinstance(host_cis_benchmark_scan_result_id, six.string_types) and len(host_cis_benchmark_scan_result_id.strip()) == 0:
        raise click.UsageError('Parameter --host-cis-benchmark-scan-result-id cannot be whitespace or empty string')

    kwargs = {}
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('vulnerability_scanning', 'vulnerability_scanning', ctx)
    result = client.get_host_cis_benchmark_scan_result(
        host_cis_benchmark_scan_result_id=host_cis_benchmark_scan_result_id,
        **kwargs
    )
    cli_util.render_response(result, ctx)


@host_endpoint_protection_scan_result_group.command(name=cli_util.override('vulnerability_scanning.get_host_endpoint_protection_scan_result.command_name', 'get'), help=u"""Returns HostEndpointProtectionScanResults for the given host endpoint protection scan result ID. \n[Command Reference](getHostEndpointProtectionScanResult)""")
@cli_util.option('--host-endpoint-protection-scan-result-id', required=True, help=u"""unique host endpoint protection scan identifier""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'vulnerability_scanning', 'class': 'HostEndpointProtectionScanResult'})
@cli_util.wrap_exceptions
def get_host_endpoint_protection_scan_result(ctx, from_json, host_endpoint_protection_scan_result_id):

    if isinstance(host_endpoint_protection_scan_result_id, six.string_types) and len(host_endpoint_protection_scan_result_id.strip()) == 0:
        raise click.UsageError('Parameter --host-endpoint-protection-scan-result-id cannot be whitespace or empty string')

    kwargs = {}
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('vulnerability_scanning', 'vulnerability_scanning', ctx)
    result = client.get_host_endpoint_protection_scan_result(
        host_endpoint_protection_scan_result_id=host_endpoint_protection_scan_result_id,
        **kwargs
    )
    cli_util.render_response(result, ctx)


@host_port_scan_result_group.command(name=cli_util.override('vulnerability_scanning.get_host_port_scan_result.command_name', 'get'), help=u"""Retrieves a HostPortScanResult identified by the host port scan ID. The result includes a list of open ports that were detected in a specific compute instance. \n[Command Reference](getHostPortScanResult)""")
@cli_util.option('--host-port-scan-result-id', required=True, help=u"""unique host port scan identifier""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'vulnerability_scanning', 'class': 'HostPortScanResult'})
@cli_util.wrap_exceptions
def get_host_port_scan_result(ctx, from_json, host_port_scan_result_id):

    if isinstance(host_port_scan_result_id, six.string_types) and len(host_port_scan_result_id.strip()) == 0:
        raise click.UsageError('Parameter --host-port-scan-result-id cannot be whitespace or empty string')

    kwargs = {}
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('vulnerability_scanning', 'vulnerability_scanning', ctx)
    result = client.get_host_port_scan_result(
        host_port_scan_result_id=host_port_scan_result_id,
        **kwargs
    )
    cli_util.render_response(result, ctx)


@host_scan_recipe_group.command(name=cli_util.override('vulnerability_scanning.get_host_scan_recipe.command_name', 'get'), help=u"""Retrieves a HostScanRecipe identified by the recipe ID. A recipe determines the types of security issues that you want scanned, and how often to scan. \n[Command Reference](getHostScanRecipe)""")
@cli_util.option('--host-scan-recipe-id', required=True, help=u"""unique HostScanRecipe identifier""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'vulnerability_scanning', 'class': 'HostScanRecipe'})
@cli_util.wrap_exceptions
def get_host_scan_recipe(ctx, from_json, host_scan_recipe_id):

    if isinstance(host_scan_recipe_id, six.string_types) and len(host_scan_recipe_id.strip()) == 0:
        raise click.UsageError('Parameter --host-scan-recipe-id cannot be whitespace or empty string')

    kwargs = {}
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('vulnerability_scanning', 'vulnerability_scanning', ctx)
    result = client.get_host_scan_recipe(
        host_scan_recipe_id=host_scan_recipe_id,
        **kwargs
    )
    cli_util.render_response(result, ctx)


@host_scan_target_group.command(name=cli_util.override('vulnerability_scanning.get_host_scan_target.command_name', 'get'), help=u"""Retrieves a HostScanTarget identified by the target ID. A host scan target is a collection of compute instances that you want routinely scanned for security vulnerabilities. \n[Command Reference](getHostScanTarget)""")
@cli_util.option('--host-scan-target-id', required=True, help=u"""unique HostScanTarget identifier""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'vulnerability_scanning', 'class': 'HostScanTarget'})
@cli_util.wrap_exceptions
def get_host_scan_target(ctx, from_json, host_scan_target_id):

    if isinstance(host_scan_target_id, six.string_types) and len(host_scan_target_id.strip()) == 0:
        raise click.UsageError('Parameter --host-scan-target-id cannot be whitespace or empty string')

    kwargs = {}
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('vulnerability_scanning', 'vulnerability_scanning', ctx)
    result = client.get_host_scan_target(
        host_scan_target_id=host_scan_target_id,
        **kwargs
    )
    cli_util.render_response(result, ctx)


@host_vulnerability_group.command(name=cli_util.override('vulnerability_scanning.get_host_vulnerability.command_name', 'get'), help=u"""Retrieves a HostVulnerability identified by the host vulnerability ID. A host vulnerability describes a security issue that was detected in scans of one or more compute instances. Common Vulnerabilities and Exposures (CVE) numbers identify security vulnerabilities for operating systems and other software, including Critical Patch Updates and Security Alert advisories. \n[Command Reference](getHostVulnerability)""")
@cli_util.option('--host-vulnerability-id', required=True, help=u"""unique host scan vulnerability identifier""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'vulnerability_scanning', 'class': 'HostVulnerability'})
@cli_util.wrap_exceptions
def get_host_vulnerability(ctx, from_json, host_vulnerability_id):

    if isinstance(host_vulnerability_id, six.string_types) and len(host_vulnerability_id.strip()) == 0:
        raise click.UsageError('Parameter --host-vulnerability-id cannot be whitespace or empty string')

    kwargs = {}
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('vulnerability_scanning', 'vulnerability_scanning', ctx)
    result = client.get_host_vulnerability(
        host_vulnerability_id=host_vulnerability_id,
        **kwargs
    )
    cli_util.render_response(result, ctx)


@work_request_group.command(name=cli_util.override('vulnerability_scanning.get_work_request.command_name', 'get'), help=u"""Gets the status of the work request with the given ID. \n[Command Reference](getWorkRequest)""")
@cli_util.option('--work-request-id', required=True, help=u"""The ID of the asynchronous request.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'vulnerability_scanning', 'class': 'WorkRequest'})
@cli_util.wrap_exceptions
def get_work_request(ctx, from_json, work_request_id):

    if isinstance(work_request_id, six.string_types) and len(work_request_id.strip()) == 0:
        raise click.UsageError('Parameter --work-request-id cannot be whitespace or empty string')

    kwargs = {}
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('vulnerability_scanning', 'vulnerability_scanning', ctx)
    result = client.get_work_request(
        work_request_id=work_request_id,
        **kwargs
    )
    cli_util.render_response(result, ctx)


@container_scan_recipe_group.command(name=cli_util.override('vulnerability_scanning.list_container_scan_recipes.command_name', 'list'), help=u"""Returns a list of ContainerScanRecipeSummaries \n[Command Reference](listContainerScanRecipes)""")
@cli_util.option('--compartment-id', required=True, help=u"""The ID of the compartment in which to list resources.""")
@cli_util.option('--lifecycle-state', type=custom_types.CliCaseInsensitiveChoice(["CREATING", "UPDATING", "ACTIVE", "DELETING", "DELETED", "FAILED"]), help=u"""A filter to return only resources whose lifecycleState matches the given lifecycleState.""")
@cli_util.option('--display-name', help=u"""A filter to return only resources that match the entire display name given.""")
@cli_util.option('--limit', type=click.INT, help=u"""The maximum number of items to return.""")
@cli_util.option('--page', help=u"""The page token representing the page at which to start retrieving results. This is usually retrieved from a previous list call.""")
@cli_util.option('--sort-order', type=custom_types.CliCaseInsensitiveChoice(["ASC", "DESC"]), help=u"""The sort order to use, either 'ASC' or 'DESC'.""")
@cli_util.option('--sort-by', type=custom_types.CliCaseInsensitiveChoice(["timeCreated", "displayName"]), help=u"""The field to sort by. Only one sort order may be provided. Default order for timeCreated is descending. Default order for displayName is ascending. If no value is specified timeCreated is default.""")
@cli_util.option('--all', 'all_pages', is_flag=True, help="""Fetches all pages of results. If you provide this option, then you cannot provide the --limit option.""")
@cli_util.option('--page-size', type=click.INT, help="""When fetching results, the number of results to fetch per call. Only valid when used with --all or --limit, and ignored otherwise.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'vulnerability_scanning', 'class': 'ContainerScanRecipeSummaryCollection'})
@cli_util.wrap_exceptions
def list_container_scan_recipes(ctx, from_json, all_pages, page_size, compartment_id, lifecycle_state, display_name, limit, page, sort_order, sort_by):

    if all_pages and limit:
        raise click.UsageError('If you provide the --all option you cannot provide the --limit option')

    kwargs = {}
    if lifecycle_state is not None:
        kwargs['lifecycle_state'] = lifecycle_state
    if display_name is not None:
        kwargs['display_name'] = display_name
    if limit is not None:
        kwargs['limit'] = limit
    if page is not None:
        kwargs['page'] = page
    if sort_order is not None:
        kwargs['sort_order'] = sort_order
    if sort_by is not None:
        kwargs['sort_by'] = sort_by
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('vulnerability_scanning', 'vulnerability_scanning', ctx)
    if all_pages:
        if page_size:
            kwargs['limit'] = page_size

        result = cli_util.list_call_get_all_results(
            client.list_container_scan_recipes,
            compartment_id=compartment_id,
            **kwargs
        )
    elif limit is not None:
        result = cli_util.list_call_get_up_to_limit(
            client.list_container_scan_recipes,
            limit,
            page_size,
            compartment_id=compartment_id,
            **kwargs
        )
    else:
        result = client.list_container_scan_recipes(
            compartment_id=compartment_id,
            **kwargs
        )
    cli_util.render_response(result, ctx)


@container_scan_result_group.command(name=cli_util.override('vulnerability_scanning.list_container_scan_results.command_name', 'list'), help=u"""Returns a collection of ContainerScanResultSummary objects \n[Command Reference](listContainerScanResults)""")
@cli_util.option('--compartment-id', required=True, help=u"""The ID of the compartment in which to list resources.""")
@cli_util.option('--repository', help=u"""Repository name""")
@cli_util.option('--image', help=u"""Image name""")
@cli_util.option('--are-subcompartments-included', type=click.BOOL, help=u"""When listing with one or more filters, whether to include subcompartments for the compartmentId being listed for. Does nothing if no filters are present in the query.""")
@cli_util.option('--highest-problem-severity', type=custom_types.CliCaseInsensitiveChoice(["NONE", "LOW", "MEDIUM", "HIGH", "CRITICAL"]), help=u"""Parameter to filter by highestProblemSeverity for scan results""")
@cli_util.option('--time-started-greater-than-or-equal-to', type=custom_types.CLI_DATETIME, help=u"""Date and time on or after which scans were started, as described in [RFC 3339]""" + custom_types.CLI_DATETIME.VALID_DATETIME_CLI_HELP_MESSAGE)
@cli_util.option('--time-started-less-than-or-equal-to', type=custom_types.CLI_DATETIME, help=u"""Date and time on or before which scans were started, as described in [RFC 3339]""" + custom_types.CLI_DATETIME.VALID_DATETIME_CLI_HELP_MESSAGE)
@cli_util.option('--sort-order', type=custom_types.CliCaseInsensitiveChoice(["ASC", "DESC"]), help=u"""The sort order to use, either 'ASC' or 'DESC'.""")
@cli_util.option('--sort-by', type=custom_types.CliCaseInsensitiveChoice(["timeStarted", "problemCount", "highestProblemSeverity"]), help=u"""The field to sort by. Only one sort order may be provided. Default order is descending. If no value is specified timeFinished is default.""")
@cli_util.option('--limit', type=click.INT, help=u"""The maximum number of items to return.""")
@cli_util.option('--page', help=u"""The page token representing the page at which to start retrieving results. This is usually retrieved from a previous list call.""")
@cli_util.option('--all', 'all_pages', is_flag=True, help="""Fetches all pages of results. If you provide this option, then you cannot provide the --limit option.""")
@cli_util.option('--page-size', type=click.INT, help="""When fetching results, the number of results to fetch per call. Only valid when used with --all or --limit, and ignored otherwise.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'vulnerability_scanning', 'class': 'ContainerScanResultSummaryCollection'})
@cli_util.wrap_exceptions
def list_container_scan_results(ctx, from_json, all_pages, page_size, compartment_id, repository, image, are_subcompartments_included, highest_problem_severity, time_started_greater_than_or_equal_to, time_started_less_than_or_equal_to, sort_order, sort_by, limit, page):

    if all_pages and limit:
        raise click.UsageError('If you provide the --all option you cannot provide the --limit option')

    kwargs = {}
    if repository is not None:
        kwargs['repository'] = repository
    if image is not None:
        kwargs['image'] = image
    if are_subcompartments_included is not None:
        kwargs['are_subcompartments_included'] = are_subcompartments_included
    if highest_problem_severity is not None:
        kwargs['highest_problem_severity'] = highest_problem_severity
    if time_started_greater_than_or_equal_to is not None:
        kwargs['time_started_greater_than_or_equal_to'] = time_started_greater_than_or_equal_to
    if time_started_less_than_or_equal_to is not None:
        kwargs['time_started_less_than_or_equal_to'] = time_started_less_than_or_equal_to
    if sort_order is not None:
        kwargs['sort_order'] = sort_order
    if sort_by is not None:
        kwargs['sort_by'] = sort_by
    if limit is not None:
        kwargs['limit'] = limit
    if page is not None:
        kwargs['page'] = page
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('vulnerability_scanning', 'vulnerability_scanning', ctx)
    if all_pages:
        if page_size:
            kwargs['limit'] = page_size

        result = cli_util.list_call_get_all_results(
            client.list_container_scan_results,
            compartment_id=compartment_id,
            **kwargs
        )
    elif limit is not None:
        result = cli_util.list_call_get_up_to_limit(
            client.list_container_scan_results,
            limit,
            page_size,
            compartment_id=compartment_id,
            **kwargs
        )
    else:
        result = client.list_container_scan_results(
            compartment_id=compartment_id,
            **kwargs
        )
    cli_util.render_response(result, ctx)


@container_scan_target_group.command(name=cli_util.override('vulnerability_scanning.list_container_scan_targets.command_name', 'list'), help=u"""Returns a list of ContainerScanTargetSummaries \n[Command Reference](listContainerScanTargets)""")
@cli_util.option('--compartment-id', required=True, help=u"""The ID of the compartment in which to list resources.""")
@cli_util.option('--lifecycle-state', type=custom_types.CliCaseInsensitiveChoice(["CREATING", "UPDATING", "ACTIVE", "DELETING", "DELETED", "FAILED"]), help=u"""A filter to return only resources whose lifecycleState matches the given lifecycleState.""")
@cli_util.option('--display-name', help=u"""A filter to return only resources that match the entire display name given.""")
@cli_util.option('--limit', type=click.INT, help=u"""The maximum number of items to return.""")
@cli_util.option('--page', help=u"""The page token representing the page at which to start retrieving results. This is usually retrieved from a previous list call.""")
@cli_util.option('--sort-order', type=custom_types.CliCaseInsensitiveChoice(["ASC", "DESC"]), help=u"""The sort order to use, either 'ASC' or 'DESC'.""")
@cli_util.option('--sort-by', type=custom_types.CliCaseInsensitiveChoice(["timeCreated", "displayName"]), help=u"""The field to sort by. Only one sort order may be provided. Default order for timeCreated is descending. Default order for displayName is ascending. If no value is specified timeCreated is default.""")
@cli_util.option('--all', 'all_pages', is_flag=True, help="""Fetches all pages of results. If you provide this option, then you cannot provide the --limit option.""")
@cli_util.option('--page-size', type=click.INT, help="""When fetching results, the number of results to fetch per call. Only valid when used with --all or --limit, and ignored otherwise.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'vulnerability_scanning', 'class': 'ContainerScanTargetSummaryCollection'})
@cli_util.wrap_exceptions
def list_container_scan_targets(ctx, from_json, all_pages, page_size, compartment_id, lifecycle_state, display_name, limit, page, sort_order, sort_by):

    if all_pages and limit:
        raise click.UsageError('If you provide the --all option you cannot provide the --limit option')

    kwargs = {}
    if lifecycle_state is not None:
        kwargs['lifecycle_state'] = lifecycle_state
    if display_name is not None:
        kwargs['display_name'] = display_name
    if limit is not None:
        kwargs['limit'] = limit
    if page is not None:
        kwargs['page'] = page
    if sort_order is not None:
        kwargs['sort_order'] = sort_order
    if sort_by is not None:
        kwargs['sort_by'] = sort_by
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('vulnerability_scanning', 'vulnerability_scanning', ctx)
    if all_pages:
        if page_size:
            kwargs['limit'] = page_size

        result = cli_util.list_call_get_all_results(
            client.list_container_scan_targets,
            compartment_id=compartment_id,
            **kwargs
        )
    elif limit is not None:
        result = cli_util.list_call_get_up_to_limit(
            client.list_container_scan_targets,
            limit,
            page_size,
            compartment_id=compartment_id,
            **kwargs
        )
    else:
        result = client.list_container_scan_targets(
            compartment_id=compartment_id,
            **kwargs
        )
    cli_util.render_response(result, ctx)


@host_agent_scan_result_group.command(name=cli_util.override('vulnerability_scanning.list_host_agent_scan_results.command_name', 'list'), help=u"""Retrieves a list of HostAgentScanResultSummary objects in a compartment. You can filter and sort the results by problem severity and time. An agent scan result includes a list of problems detected in a specific compute instance. \n[Command Reference](listHostAgentScanResults)""")
@cli_util.option('--compartment-id', required=True, help=u"""The ID of the compartment in which to list resources.""")
@cli_util.option('--instance-id', help=u"""The ID of a compute instance""")
@cli_util.option('--highest-problem-severity', type=custom_types.CliCaseInsensitiveChoice(["NONE", "LOW", "MEDIUM", "HIGH", "CRITICAL"]), help=u"""Parameter to filter by highestProblemSeverity for scan results""")
@cli_util.option('--operating-system', help=u"""Parameter to filter by operating system for scan results""")
@cli_util.option('--time-started-greater-than-or-equal-to', type=custom_types.CLI_DATETIME, help=u"""Date and time on or after which scans were started, as described in [RFC 3339]""" + custom_types.CLI_DATETIME.VALID_DATETIME_CLI_HELP_MESSAGE)
@cli_util.option('--time-started-less-than-or-equal-to', type=custom_types.CLI_DATETIME, help=u"""Date and time on or before which scans were started, as described in [RFC 3339]""" + custom_types.CLI_DATETIME.VALID_DATETIME_CLI_HELP_MESSAGE)
@cli_util.option('--sort-order', type=custom_types.CliCaseInsensitiveChoice(["ASC", "DESC"]), help=u"""The sort order to use, either 'ASC' or 'DESC'.""")
@cli_util.option('--sort-by', type=custom_types.CliCaseInsensitiveChoice(["timeStarted", "timeFinished", "problemCount", "highestProblemSeverity", "timeCompleted"]), help=u"""The field to sort by. Only one sort order may be provided. Default order is descending. If no value is specified timeStarted is default.""")
@cli_util.option('--limit', type=click.INT, help=u"""The maximum number of items to return.""")
@cli_util.option('--page', help=u"""The page token representing the page at which to start retrieving results. This is usually retrieved from a previous list call.""")
@cli_util.option('--display-name', help=u"""A filter to return only resources that match the entire display name given.""")
@cli_util.option('--all', 'all_pages', is_flag=True, help="""Fetches all pages of results. If you provide this option, then you cannot provide the --limit option.""")
@cli_util.option('--page-size', type=click.INT, help="""When fetching results, the number of results to fetch per call. Only valid when used with --all or --limit, and ignored otherwise.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'vulnerability_scanning', 'class': 'HostAgentScanResultSummaryCollection'})
@cli_util.wrap_exceptions
def list_host_agent_scan_results(ctx, from_json, all_pages, page_size, compartment_id, instance_id, highest_problem_severity, operating_system, time_started_greater_than_or_equal_to, time_started_less_than_or_equal_to, sort_order, sort_by, limit, page, display_name):

    if all_pages and limit:
        raise click.UsageError('If you provide the --all option you cannot provide the --limit option')

    kwargs = {}
    if instance_id is not None:
        kwargs['instance_id'] = instance_id
    if highest_problem_severity is not None:
        kwargs['highest_problem_severity'] = highest_problem_severity
    if operating_system is not None:
        kwargs['operating_system'] = operating_system
    if time_started_greater_than_or_equal_to is not None:
        kwargs['time_started_greater_than_or_equal_to'] = time_started_greater_than_or_equal_to
    if time_started_less_than_or_equal_to is not None:
        kwargs['time_started_less_than_or_equal_to'] = time_started_less_than_or_equal_to
    if sort_order is not None:
        kwargs['sort_order'] = sort_order
    if sort_by is not None:
        kwargs['sort_by'] = sort_by
    if limit is not None:
        kwargs['limit'] = limit
    if page is not None:
        kwargs['page'] = page
    if display_name is not None:
        kwargs['display_name'] = display_name
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('vulnerability_scanning', 'vulnerability_scanning', ctx)
    if all_pages:
        if page_size:
            kwargs['limit'] = page_size

        result = cli_util.list_call_get_all_results(
            client.list_host_agent_scan_results,
            compartment_id=compartment_id,
            **kwargs
        )
    elif limit is not None:
        result = cli_util.list_call_get_up_to_limit(
            client.list_host_agent_scan_results,
            limit,
            page_size,
            compartment_id=compartment_id,
            **kwargs
        )
    else:
        result = client.list_host_agent_scan_results(
            compartment_id=compartment_id,
            **kwargs
        )
    cli_util.render_response(result, ctx)


@host_cis_benchmark_scan_result_group.command(name=cli_util.override('vulnerability_scanning.list_host_cis_benchmark_scan_results.command_name', 'list'), help=u"""Returns a collection of HostCisBenchmarkScanResultSummary objects \n[Command Reference](listHostCisBenchmarkScanResults)""")
@cli_util.option('--compartment-id', required=True, help=u"""The ID of the compartment in which to list resources.""")
@cli_util.option('--instance-id', help=u"""The ID of a compute instance""")
@cli_util.option('--highest-problem-severity', type=custom_types.CliCaseInsensitiveChoice(["NONE", "LOW", "MEDIUM", "HIGH", "CRITICAL"]), help=u"""Parameter to filter by highestProblemSeverity for scan results""")
@cli_util.option('--time-started-greater-than-or-equal-to', type=custom_types.CLI_DATETIME, help=u"""Date and time on or after which scans were started, as described in [RFC 3339]""" + custom_types.CLI_DATETIME.VALID_DATETIME_CLI_HELP_MESSAGE)
@cli_util.option('--time-started-less-than-or-equal-to', type=custom_types.CLI_DATETIME, help=u"""Date and time on or before which scans were started, as described in [RFC 3339]""" + custom_types.CLI_DATETIME.VALID_DATETIME_CLI_HELP_MESSAGE)
@cli_util.option('--sort-order', type=custom_types.CliCaseInsensitiveChoice(["ASC", "DESC"]), help=u"""The sort order to use, either 'ASC' or 'DESC'.""")
@cli_util.option('--sort-by', type=custom_types.CliCaseInsensitiveChoice(["timeStarted", "timeFinished", "cisBenchmarkScanIssuesCount"]), help=u"""The field to sort by. Only one sort order may be provided. Default order is descending. If no value is specified timeFinished is default.""")
@cli_util.option('--limit', type=click.INT, help=u"""The maximum number of items to return.""")
@cli_util.option('--page', help=u"""The page token representing the page at which to start retrieving results. This is usually retrieved from a previous list call.""")
@cli_util.option('--display-name', help=u"""A filter to return only resources that match the entire display name given.""")
@cli_util.option('--all', 'all_pages', is_flag=True, help="""Fetches all pages of results. If you provide this option, then you cannot provide the --limit option.""")
@cli_util.option('--page-size', type=click.INT, help="""When fetching results, the number of results to fetch per call. Only valid when used with --all or --limit, and ignored otherwise.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'vulnerability_scanning', 'class': 'HostCisBenchmarkScanResultSummaryCollection'})
@cli_util.wrap_exceptions
def list_host_cis_benchmark_scan_results(ctx, from_json, all_pages, page_size, compartment_id, instance_id, highest_problem_severity, time_started_greater_than_or_equal_to, time_started_less_than_or_equal_to, sort_order, sort_by, limit, page, display_name):

    if all_pages and limit:
        raise click.UsageError('If you provide the --all option you cannot provide the --limit option')

    kwargs = {}
    if instance_id is not None:
        kwargs['instance_id'] = instance_id
    if highest_problem_severity is not None:
        kwargs['highest_problem_severity'] = highest_problem_severity
    if time_started_greater_than_or_equal_to is not None:
        kwargs['time_started_greater_than_or_equal_to'] = time_started_greater_than_or_equal_to
    if time_started_less_than_or_equal_to is not None:
        kwargs['time_started_less_than_or_equal_to'] = time_started_less_than_or_equal_to
    if sort_order is not None:
        kwargs['sort_order'] = sort_order
    if sort_by is not None:
        kwargs['sort_by'] = sort_by
    if limit is not None:
        kwargs['limit'] = limit
    if page is not None:
        kwargs['page'] = page
    if display_name is not None:
        kwargs['display_name'] = display_name
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('vulnerability_scanning', 'vulnerability_scanning', ctx)
    if all_pages:
        if page_size:
            kwargs['limit'] = page_size

        result = cli_util.list_call_get_all_results(
            client.list_host_cis_benchmark_scan_results,
            compartment_id=compartment_id,
            **kwargs
        )
    elif limit is not None:
        result = cli_util.list_call_get_up_to_limit(
            client.list_host_cis_benchmark_scan_results,
            limit,
            page_size,
            compartment_id=compartment_id,
            **kwargs
        )
    else:
        result = client.list_host_cis_benchmark_scan_results(
            compartment_id=compartment_id,
            **kwargs
        )
    cli_util.render_response(result, ctx)


@host_endpoint_protection_scan_result_group.command(name=cli_util.override('vulnerability_scanning.list_host_endpoint_protection_scan_results.command_name', 'list'), help=u"""Returns a collection of HostEndpointProtectionScanResultSummary objects \n[Command Reference](listHostEndpointProtectionScanResults)""")
@cli_util.option('--compartment-id', required=True, help=u"""The ID of the compartment in which to list resources.""")
@cli_util.option('--instance-id', help=u"""The ID of a compute instance""")
@cli_util.option('--highest-problem-severity', type=custom_types.CliCaseInsensitiveChoice(["NONE", "LOW", "MEDIUM", "HIGH", "CRITICAL"]), help=u"""Parameter to filter by highestProblemSeverity for scan results""")
@cli_util.option('--time-started-greater-than-or-equal-to', type=custom_types.CLI_DATETIME, help=u"""Date and time on or after which scans were started, as described in [RFC 3339]""" + custom_types.CLI_DATETIME.VALID_DATETIME_CLI_HELP_MESSAGE)
@cli_util.option('--time-started-less-than-or-equal-to', type=custom_types.CLI_DATETIME, help=u"""Date and time on or before which scans were started, as described in [RFC 3339]""" + custom_types.CLI_DATETIME.VALID_DATETIME_CLI_HELP_MESSAGE)
@cli_util.option('--sort-order', type=custom_types.CliCaseInsensitiveChoice(["ASC", "DESC"]), help=u"""The sort order to use, either 'ASC' or 'DESC'.""")
@cli_util.option('--sort-by', type=custom_types.CliCaseInsensitiveChoice(["timeStarted", "timeFinished", "problemSeverity"]), help=u"""The field to sort by. Only one sort order may be provided. Default order is descending. If no value is specified timeFinished is default.""")
@cli_util.option('--limit', type=click.INT, help=u"""The maximum number of items to return.""")
@cli_util.option('--page', help=u"""The page token representing the page at which to start retrieving results. This is usually retrieved from a previous list call.""")
@cli_util.option('--display-name', help=u"""A filter to return only resources that match the entire display name given.""")
@cli_util.option('--all', 'all_pages', is_flag=True, help="""Fetches all pages of results. If you provide this option, then you cannot provide the --limit option.""")
@cli_util.option('--page-size', type=click.INT, help="""When fetching results, the number of results to fetch per call. Only valid when used with --all or --limit, and ignored otherwise.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'vulnerability_scanning', 'class': 'HostEndpointProtectionScanResultSummaryCollection'})
@cli_util.wrap_exceptions
def list_host_endpoint_protection_scan_results(ctx, from_json, all_pages, page_size, compartment_id, instance_id, highest_problem_severity, time_started_greater_than_or_equal_to, time_started_less_than_or_equal_to, sort_order, sort_by, limit, page, display_name):

    if all_pages and limit:
        raise click.UsageError('If you provide the --all option you cannot provide the --limit option')

    kwargs = {}
    if instance_id is not None:
        kwargs['instance_id'] = instance_id
    if highest_problem_severity is not None:
        kwargs['highest_problem_severity'] = highest_problem_severity
    if time_started_greater_than_or_equal_to is not None:
        kwargs['time_started_greater_than_or_equal_to'] = time_started_greater_than_or_equal_to
    if time_started_less_than_or_equal_to is not None:
        kwargs['time_started_less_than_or_equal_to'] = time_started_less_than_or_equal_to
    if sort_order is not None:
        kwargs['sort_order'] = sort_order
    if sort_by is not None:
        kwargs['sort_by'] = sort_by
    if limit is not None:
        kwargs['limit'] = limit
    if page is not None:
        kwargs['page'] = page
    if display_name is not None:
        kwargs['display_name'] = display_name
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('vulnerability_scanning', 'vulnerability_scanning', ctx)
    if all_pages:
        if page_size:
            kwargs['limit'] = page_size

        result = cli_util.list_call_get_all_results(
            client.list_host_endpoint_protection_scan_results,
            compartment_id=compartment_id,
            **kwargs
        )
    elif limit is not None:
        result = cli_util.list_call_get_up_to_limit(
            client.list_host_endpoint_protection_scan_results,
            limit,
            page_size,
            compartment_id=compartment_id,
            **kwargs
        )
    else:
        result = client.list_host_endpoint_protection_scan_results(
            compartment_id=compartment_id,
            **kwargs
        )
    cli_util.render_response(result, ctx)


@host_port_scan_result_group.command(name=cli_util.override('vulnerability_scanning.list_host_port_scan_results.command_name', 'list'), help=u"""Retrieves a list of HostPortScanResultSummary objects in a compartment. You can filter and sort the results by problem severity and time. A port scan result includes a list of open ports that were detected in a specific compute instance. \n[Command Reference](listHostPortScanResults)""")
@cli_util.option('--compartment-id', required=True, help=u"""The ID of the compartment in which to list resources.""")
@cli_util.option('--instance-id', help=u"""The ID of a compute instance""")
@cli_util.option('--highest-problem-severity', type=custom_types.CliCaseInsensitiveChoice(["NONE", "LOW", "MEDIUM", "HIGH", "CRITICAL"]), help=u"""Parameter to filter by highestProblemSeverity for scan results""")
@cli_util.option('--time-started-greater-than-or-equal-to', type=custom_types.CLI_DATETIME, help=u"""Date and time on or after which scans were started, as described in [RFC 3339]""" + custom_types.CLI_DATETIME.VALID_DATETIME_CLI_HELP_MESSAGE)
@cli_util.option('--time-started-less-than-or-equal-to', type=custom_types.CLI_DATETIME, help=u"""Date and time on or before which scans were started, as described in [RFC 3339]""" + custom_types.CLI_DATETIME.VALID_DATETIME_CLI_HELP_MESSAGE)
@cli_util.option('--sort-order', type=custom_types.CliCaseInsensitiveChoice(["ASC", "DESC"]), help=u"""The sort order to use, either 'ASC' or 'DESC'.""")
@cli_util.option('--sort-by', type=custom_types.CliCaseInsensitiveChoice(["timeStarted", "timeFinished", "openPortCount", "highestProblemSeverity", "timeCompleted"]), help=u"""The field to sort by. Only one sort order may be provided. Default order is descending. If no value is specified timeFinished is default.""")
@cli_util.option('--limit', type=click.INT, help=u"""The maximum number of items to return.""")
@cli_util.option('--page', help=u"""The page token representing the page at which to start retrieving results. This is usually retrieved from a previous list call.""")
@cli_util.option('--display-name', help=u"""A filter to return only resources that match the entire display name given.""")
@cli_util.option('--all', 'all_pages', is_flag=True, help="""Fetches all pages of results. If you provide this option, then you cannot provide the --limit option.""")
@cli_util.option('--page-size', type=click.INT, help="""When fetching results, the number of results to fetch per call. Only valid when used with --all or --limit, and ignored otherwise.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'vulnerability_scanning', 'class': 'HostPortScanResultSummaryCollection'})
@cli_util.wrap_exceptions
def list_host_port_scan_results(ctx, from_json, all_pages, page_size, compartment_id, instance_id, highest_problem_severity, time_started_greater_than_or_equal_to, time_started_less_than_or_equal_to, sort_order, sort_by, limit, page, display_name):

    if all_pages and limit:
        raise click.UsageError('If you provide the --all option you cannot provide the --limit option')

    kwargs = {}
    if instance_id is not None:
        kwargs['instance_id'] = instance_id
    if highest_problem_severity is not None:
        kwargs['highest_problem_severity'] = highest_problem_severity
    if time_started_greater_than_or_equal_to is not None:
        kwargs['time_started_greater_than_or_equal_to'] = time_started_greater_than_or_equal_to
    if time_started_less_than_or_equal_to is not None:
        kwargs['time_started_less_than_or_equal_to'] = time_started_less_than_or_equal_to
    if sort_order is not None:
        kwargs['sort_order'] = sort_order
    if sort_by is not None:
        kwargs['sort_by'] = sort_by
    if limit is not None:
        kwargs['limit'] = limit
    if page is not None:
        kwargs['page'] = page
    if display_name is not None:
        kwargs['display_name'] = display_name
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('vulnerability_scanning', 'vulnerability_scanning', ctx)
    if all_pages:
        if page_size:
            kwargs['limit'] = page_size

        result = cli_util.list_call_get_all_results(
            client.list_host_port_scan_results,
            compartment_id=compartment_id,
            **kwargs
        )
    elif limit is not None:
        result = cli_util.list_call_get_up_to_limit(
            client.list_host_port_scan_results,
            limit,
            page_size,
            compartment_id=compartment_id,
            **kwargs
        )
    else:
        result = client.list_host_port_scan_results(
            compartment_id=compartment_id,
            **kwargs
        )
    cli_util.render_response(result, ctx)


@host_scan_recipe_group.command(name=cli_util.override('vulnerability_scanning.list_host_scan_recipes.command_name', 'list'), help=u"""Retrieves a list of HostScanRecipeSummary objects in a compartment. A recipe determines the types of security issues that you want scanned, and how often to scan. \n[Command Reference](listHostScanRecipes)""")
@cli_util.option('--compartment-id', required=True, help=u"""The ID of the compartment in which to list resources.""")
@cli_util.option('--lifecycle-state', type=custom_types.CliCaseInsensitiveChoice(["CREATING", "UPDATING", "ACTIVE", "DELETING", "DELETED", "FAILED"]), help=u"""A filter to return only resources whose lifecycleState matches the given lifecycleState.""")
@cli_util.option('--display-name', help=u"""A filter to return only resources that match the entire display name given.""")
@cli_util.option('--limit', type=click.INT, help=u"""The maximum number of items to return.""")
@cli_util.option('--page', help=u"""The page token representing the page at which to start retrieving results. This is usually retrieved from a previous list call.""")
@cli_util.option('--sort-order', type=custom_types.CliCaseInsensitiveChoice(["ASC", "DESC"]), help=u"""The sort order to use, either 'ASC' or 'DESC'.""")
@cli_util.option('--sort-by', type=custom_types.CliCaseInsensitiveChoice(["timeCreated", "displayName"]), help=u"""The field to sort by. Only one sort order may be provided. Default order for timeCreated is descending. Default order for displayName is ascending. If no value is specified timeCreated is default.""")
@cli_util.option('--all', 'all_pages', is_flag=True, help="""Fetches all pages of results. If you provide this option, then you cannot provide the --limit option.""")
@cli_util.option('--page-size', type=click.INT, help="""When fetching results, the number of results to fetch per call. Only valid when used with --all or --limit, and ignored otherwise.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'vulnerability_scanning', 'class': 'HostScanRecipeSummaryCollection'})
@cli_util.wrap_exceptions
def list_host_scan_recipes(ctx, from_json, all_pages, page_size, compartment_id, lifecycle_state, display_name, limit, page, sort_order, sort_by):

    if all_pages and limit:
        raise click.UsageError('If you provide the --all option you cannot provide the --limit option')

    kwargs = {}
    if lifecycle_state is not None:
        kwargs['lifecycle_state'] = lifecycle_state
    if display_name is not None:
        kwargs['display_name'] = display_name
    if limit is not None:
        kwargs['limit'] = limit
    if page is not None:
        kwargs['page'] = page
    if sort_order is not None:
        kwargs['sort_order'] = sort_order
    if sort_by is not None:
        kwargs['sort_by'] = sort_by
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('vulnerability_scanning', 'vulnerability_scanning', ctx)
    if all_pages:
        if page_size:
            kwargs['limit'] = page_size

        result = cli_util.list_call_get_all_results(
            client.list_host_scan_recipes,
            compartment_id=compartment_id,
            **kwargs
        )
    elif limit is not None:
        result = cli_util.list_call_get_up_to_limit(
            client.list_host_scan_recipes,
            limit,
            page_size,
            compartment_id=compartment_id,
            **kwargs
        )
    else:
        result = client.list_host_scan_recipes(
            compartment_id=compartment_id,
            **kwargs
        )
    cli_util.render_response(result, ctx)


@host_scan_target_group.command(name=cli_util.override('vulnerability_scanning.list_host_scan_targets.command_name', 'list'), help=u"""Retrieves a list of HostScanTargetSummary objects in a compartment. A host scan target is a collection of compute instances that you want routinely scanned for security vulnerabilities. \n[Command Reference](listHostScanTargets)""")
@cli_util.option('--compartment-id', required=True, help=u"""The ID of the compartment in which to list resources.""")
@cli_util.option('--lifecycle-state', type=custom_types.CliCaseInsensitiveChoice(["CREATING", "UPDATING", "ACTIVE", "DELETING", "DELETED", "FAILED"]), help=u"""A filter to return only resources whose lifecycleState matches the given lifecycleState.""")
@cli_util.option('--display-name', help=u"""A filter to return only resources that match the entire display name given.""")
@cli_util.option('--limit', type=click.INT, help=u"""The maximum number of items to return.""")
@cli_util.option('--page', help=u"""The page token representing the page at which to start retrieving results. This is usually retrieved from a previous list call.""")
@cli_util.option('--sort-order', type=custom_types.CliCaseInsensitiveChoice(["ASC", "DESC"]), help=u"""The sort order to use, either 'ASC' or 'DESC'.""")
@cli_util.option('--sort-by', type=custom_types.CliCaseInsensitiveChoice(["timeCreated", "displayName"]), help=u"""The field to sort by. Only one sort order may be provided. Default order for timeCreated is descending. Default order for displayName is ascending. If no value is specified timeCreated is default.""")
@cli_util.option('--all', 'all_pages', is_flag=True, help="""Fetches all pages of results. If you provide this option, then you cannot provide the --limit option.""")
@cli_util.option('--page-size', type=click.INT, help="""When fetching results, the number of results to fetch per call. Only valid when used with --all or --limit, and ignored otherwise.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'vulnerability_scanning', 'class': 'HostScanTargetSummaryCollection'})
@cli_util.wrap_exceptions
def list_host_scan_targets(ctx, from_json, all_pages, page_size, compartment_id, lifecycle_state, display_name, limit, page, sort_order, sort_by):

    if all_pages and limit:
        raise click.UsageError('If you provide the --all option you cannot provide the --limit option')

    kwargs = {}
    if lifecycle_state is not None:
        kwargs['lifecycle_state'] = lifecycle_state
    if display_name is not None:
        kwargs['display_name'] = display_name
    if limit is not None:
        kwargs['limit'] = limit
    if page is not None:
        kwargs['page'] = page
    if sort_order is not None:
        kwargs['sort_order'] = sort_order
    if sort_by is not None:
        kwargs['sort_by'] = sort_by
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('vulnerability_scanning', 'vulnerability_scanning', ctx)
    if all_pages:
        if page_size:
            kwargs['limit'] = page_size

        result = cli_util.list_call_get_all_results(
            client.list_host_scan_targets,
            compartment_id=compartment_id,
            **kwargs
        )
    elif limit is not None:
        result = cli_util.list_call_get_up_to_limit(
            client.list_host_scan_targets,
            limit,
            page_size,
            compartment_id=compartment_id,
            **kwargs
        )
    else:
        result = client.list_host_scan_targets(
            compartment_id=compartment_id,
            **kwargs
        )
    cli_util.render_response(result, ctx)


@host_vulnerability_group.command(name=cli_util.override('vulnerability_scanning.list_host_vulnerabilities.command_name', 'list'), help=u"""Retrieves a list of HostVulnerabilitySummary objects in a compartment. You can filter and sort the vulnerabilities by problem severity and time. A host vulnerability describes a security issue that was detected in scans of one or more compute instances. \n[Command Reference](listHostVulnerabilities)""")
@cli_util.option('--compartment-id', required=True, help=u"""The ID of the compartment in which to list resources.""")
@cli_util.option('--limit', type=click.INT, help=u"""The maximum number of items to return.""")
@cli_util.option('--page', help=u"""The page token representing the page at which to start retrieving results. This is usually retrieved from a previous list call.""")
@cli_util.option('--severity', type=custom_types.CliCaseInsensitiveChoice(["NONE", "LOW", "MEDIUM", "HIGH", "CRITICAL"]), help=u"""A filter to return only resources that have a severity that matches the given severity""")
@cli_util.option('--name', help=u"""A filter to return only resources that match the entire name given.""")
@cli_util.option('--cve-reference', help=u"""Parameter to filter by CVE reference number for vulnerabilities""")
@cli_util.option('--vulnerability-type', type=custom_types.CliCaseInsensitiveChoice(["CVE", "PROBLEM"]), help=u"""The field to filter vulnerabilities based on its type. Only one value can be provided.""")
@cli_util.option('--sort-order', type=custom_types.CliCaseInsensitiveChoice(["ASC", "DESC"]), help=u"""The sort order to use, either 'ASC' or 'DESC'.""")
@cli_util.option('--sort-by', type=custom_types.CliCaseInsensitiveChoice(["name", "severity", "impactedHosts", "firstDetected", "lastDetected"]), help=u"""The field to sort by. Only one sort order may be provided. Default order for 'name' is Ascending. Default order for other values is descending. If no value is specified name is default.""")
@cli_util.option('--all', 'all_pages', is_flag=True, help="""Fetches all pages of results. If you provide this option, then you cannot provide the --limit option.""")
@cli_util.option('--page-size', type=click.INT, help="""When fetching results, the number of results to fetch per call. Only valid when used with --all or --limit, and ignored otherwise.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'vulnerability_scanning', 'class': 'HostVulnerabilitySummaryCollection'})
@cli_util.wrap_exceptions
def list_host_vulnerabilities(ctx, from_json, all_pages, page_size, compartment_id, limit, page, severity, name, cve_reference, vulnerability_type, sort_order, sort_by):

    if all_pages and limit:
        raise click.UsageError('If you provide the --all option you cannot provide the --limit option')

    kwargs = {}
    if limit is not None:
        kwargs['limit'] = limit
    if page is not None:
        kwargs['page'] = page
    if severity is not None:
        kwargs['severity'] = severity
    if name is not None:
        kwargs['name'] = name
    if cve_reference is not None:
        kwargs['cve_reference'] = cve_reference
    if vulnerability_type is not None:
        kwargs['vulnerability_type'] = vulnerability_type
    if sort_order is not None:
        kwargs['sort_order'] = sort_order
    if sort_by is not None:
        kwargs['sort_by'] = sort_by
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('vulnerability_scanning', 'vulnerability_scanning', ctx)
    if all_pages:
        if page_size:
            kwargs['limit'] = page_size

        result = cli_util.list_call_get_all_results(
            client.list_host_vulnerabilities,
            compartment_id=compartment_id,
            **kwargs
        )
    elif limit is not None:
        result = cli_util.list_call_get_up_to_limit(
            client.list_host_vulnerabilities,
            limit,
            page_size,
            compartment_id=compartment_id,
            **kwargs
        )
    else:
        result = client.list_host_vulnerabilities(
            compartment_id=compartment_id,
            **kwargs
        )
    cli_util.render_response(result, ctx)


@host_vulnerability_group.command(name=cli_util.override('vulnerability_scanning.list_host_vulnerability_impacted_hosts.command_name', 'list-host-vulnerability-impacted-hosts'), help=u"""Retrieves a list of HostVulnerabilityImpactedHostSummary objects for a specific host vulnerability ID. An impacted host summary identifies a compute instance on which the specified vulnerability was detected. \n[Command Reference](listHostVulnerabilityImpactedHosts)""")
@cli_util.option('--host-vulnerability-id', required=True, help=u"""unique host scan vulnerability identifier""")
@cli_util.option('--sort-order', type=custom_types.CliCaseInsensitiveChoice(["ASC", "DESC"]), help=u"""The sort order to use, either 'ASC' or 'DESC'.""")
@cli_util.option('--sort-by', type=custom_types.CliCaseInsensitiveChoice(["instanceId"]), help=u"""The field to sort by. Only one sort order may be provided. Default order is Ascending. If no value is specified instanceId is default.""")
@cli_util.option('--limit', type=click.INT, help=u"""The maximum number of items to return.""")
@cli_util.option('--page', help=u"""The page token representing the page at which to start retrieving results. This is usually retrieved from a previous list call.""")
@cli_util.option('--all', 'all_pages', is_flag=True, help="""Fetches all pages of results. If you provide this option, then you cannot provide the --limit option.""")
@cli_util.option('--page-size', type=click.INT, help="""When fetching results, the number of results to fetch per call. Only valid when used with --all or --limit, and ignored otherwise.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'vulnerability_scanning', 'class': 'HostVulnerabilityImpactedHostSummaryCollection'})
@cli_util.wrap_exceptions
def list_host_vulnerability_impacted_hosts(ctx, from_json, all_pages, page_size, host_vulnerability_id, sort_order, sort_by, limit, page):

    if all_pages and limit:
        raise click.UsageError('If you provide the --all option you cannot provide the --limit option')

    if isinstance(host_vulnerability_id, six.string_types) and len(host_vulnerability_id.strip()) == 0:
        raise click.UsageError('Parameter --host-vulnerability-id cannot be whitespace or empty string')

    kwargs = {}
    if sort_order is not None:
        kwargs['sort_order'] = sort_order
    if sort_by is not None:
        kwargs['sort_by'] = sort_by
    if limit is not None:
        kwargs['limit'] = limit
    if page is not None:
        kwargs['page'] = page
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('vulnerability_scanning', 'vulnerability_scanning', ctx)
    if all_pages:
        if page_size:
            kwargs['limit'] = page_size

        result = cli_util.list_call_get_all_results(
            client.list_host_vulnerability_impacted_hosts,
            host_vulnerability_id=host_vulnerability_id,
            **kwargs
        )
    elif limit is not None:
        result = cli_util.list_call_get_up_to_limit(
            client.list_host_vulnerability_impacted_hosts,
            limit,
            page_size,
            host_vulnerability_id=host_vulnerability_id,
            **kwargs
        )
    else:
        result = client.list_host_vulnerability_impacted_hosts(
            host_vulnerability_id=host_vulnerability_id,
            **kwargs
        )
    cli_util.render_response(result, ctx)


@work_request_error_group.command(name=cli_util.override('vulnerability_scanning.list_work_request_errors.command_name', 'list'), help=u"""Return a (paginated) list of errors for a given work request. \n[Command Reference](listWorkRequestErrors)""")
@cli_util.option('--work-request-id', required=True, help=u"""The ID of the asynchronous request.""")
@cli_util.option('--page', help=u"""The page token representing the page at which to start retrieving results. This is usually retrieved from a previous list call.""")
@cli_util.option('--limit', type=click.INT, help=u"""The maximum number of items to return.""")
@cli_util.option('--all', 'all_pages', is_flag=True, help="""Fetches all pages of results. If you provide this option, then you cannot provide the --limit option.""")
@cli_util.option('--page-size', type=click.INT, help="""When fetching results, the number of results to fetch per call. Only valid when used with --all or --limit, and ignored otherwise.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'vulnerability_scanning', 'class': 'WorkRequestErrorCollection'})
@cli_util.wrap_exceptions
def list_work_request_errors(ctx, from_json, all_pages, page_size, work_request_id, page, limit):

    if all_pages and limit:
        raise click.UsageError('If you provide the --all option you cannot provide the --limit option')

    if isinstance(work_request_id, six.string_types) and len(work_request_id.strip()) == 0:
        raise click.UsageError('Parameter --work-request-id cannot be whitespace or empty string')

    kwargs = {}
    if page is not None:
        kwargs['page'] = page
    if limit is not None:
        kwargs['limit'] = limit
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('vulnerability_scanning', 'vulnerability_scanning', ctx)
    if all_pages:
        if page_size:
            kwargs['limit'] = page_size

        result = cli_util.list_call_get_all_results(
            client.list_work_request_errors,
            work_request_id=work_request_id,
            **kwargs
        )
    elif limit is not None:
        result = cli_util.list_call_get_up_to_limit(
            client.list_work_request_errors,
            limit,
            page_size,
            work_request_id=work_request_id,
            **kwargs
        )
    else:
        result = client.list_work_request_errors(
            work_request_id=work_request_id,
            **kwargs
        )
    cli_util.render_response(result, ctx)


@work_request_log_entry_group.command(name=cli_util.override('vulnerability_scanning.list_work_request_logs.command_name', 'list-work-request-logs'), help=u"""Return a (paginated) list of logs for a given work request. \n[Command Reference](listWorkRequestLogs)""")
@cli_util.option('--work-request-id', required=True, help=u"""The ID of the asynchronous request.""")
@cli_util.option('--page', help=u"""The page token representing the page at which to start retrieving results. This is usually retrieved from a previous list call.""")
@cli_util.option('--limit', type=click.INT, help=u"""The maximum number of items to return.""")
@cli_util.option('--all', 'all_pages', is_flag=True, help="""Fetches all pages of results. If you provide this option, then you cannot provide the --limit option.""")
@cli_util.option('--page-size', type=click.INT, help="""When fetching results, the number of results to fetch per call. Only valid when used with --all or --limit, and ignored otherwise.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'vulnerability_scanning', 'class': 'WorkRequestLogEntryCollection'})
@cli_util.wrap_exceptions
def list_work_request_logs(ctx, from_json, all_pages, page_size, work_request_id, page, limit):

    if all_pages and limit:
        raise click.UsageError('If you provide the --all option you cannot provide the --limit option')

    if isinstance(work_request_id, six.string_types) and len(work_request_id.strip()) == 0:
        raise click.UsageError('Parameter --work-request-id cannot be whitespace or empty string')

    kwargs = {}
    if page is not None:
        kwargs['page'] = page
    if limit is not None:
        kwargs['limit'] = limit
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('vulnerability_scanning', 'vulnerability_scanning', ctx)
    if all_pages:
        if page_size:
            kwargs['limit'] = page_size

        result = cli_util.list_call_get_all_results(
            client.list_work_request_logs,
            work_request_id=work_request_id,
            **kwargs
        )
    elif limit is not None:
        result = cli_util.list_call_get_up_to_limit(
            client.list_work_request_logs,
            limit,
            page_size,
            work_request_id=work_request_id,
            **kwargs
        )
    else:
        result = client.list_work_request_logs(
            work_request_id=work_request_id,
            **kwargs
        )
    cli_util.render_response(result, ctx)


@work_request_group.command(name=cli_util.override('vulnerability_scanning.list_work_requests.command_name', 'list'), help=u"""Lists the work requests in a compartment. \n[Command Reference](listWorkRequests)""")
@cli_util.option('--compartment-id', required=True, help=u"""The ID of the compartment in which to list resources.""")
@cli_util.option('--page', help=u"""The page token representing the page at which to start retrieving results. This is usually retrieved from a previous list call.""")
@cli_util.option('--limit', type=click.INT, help=u"""The maximum number of items to return.""")
@cli_util.option('--all', 'all_pages', is_flag=True, help="""Fetches all pages of results. If you provide this option, then you cannot provide the --limit option.""")
@cli_util.option('--page-size', type=click.INT, help="""When fetching results, the number of results to fetch per call. Only valid when used with --all or --limit, and ignored otherwise.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'vulnerability_scanning', 'class': 'WorkRequestCollection'})
@cli_util.wrap_exceptions
def list_work_requests(ctx, from_json, all_pages, page_size, compartment_id, page, limit):

    if all_pages and limit:
        raise click.UsageError('If you provide the --all option you cannot provide the --limit option')

    kwargs = {}
    if page is not None:
        kwargs['page'] = page
    if limit is not None:
        kwargs['limit'] = limit
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('vulnerability_scanning', 'vulnerability_scanning', ctx)
    if all_pages:
        if page_size:
            kwargs['limit'] = page_size

        result = cli_util.list_call_get_all_results(
            client.list_work_requests,
            compartment_id=compartment_id,
            **kwargs
        )
    elif limit is not None:
        result = cli_util.list_call_get_up_to_limit(
            client.list_work_requests,
            limit,
            page_size,
            compartment_id=compartment_id,
            **kwargs
        )
    else:
        result = client.list_work_requests(
            compartment_id=compartment_id,
            **kwargs
        )
    cli_util.render_response(result, ctx)


@container_scan_recipe_group.command(name=cli_util.override('vulnerability_scanning.update_container_scan_recipe.command_name', 'update'), help=u"""Updates the ContainerScanRecipe identified by the id \n[Command Reference](updateContainerScanRecipe)""")
@cli_util.option('--container-scan-recipe-id', required=True, help=u"""unique ContainerScanRecipe identifier""")
@cli_util.option('--display-name', help=u"""User friendly name of container scan recipe""")
@cli_util.option('--scan-settings', type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--freeform-tags', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{\"bar-key\": \"value\"}`""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--defined-tags', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--if-match', help=u"""For optimistic concurrency control. In the PUT or DELETE call for a resource, set the `if-match` parameter to the value of the etag from a previous GET or POST response for that resource. The resource will be updated or deleted only if the etag you provide matches the resource's current etag value.""")
@cli_util.option('--force', help="""Perform update without prompting for confirmation.""", is_flag=True)
@cli_util.option('--wait-for-state', type=custom_types.CliCaseInsensitiveChoice(["ACCEPTED", "IN_PROGRESS", "FAILED", "SUCCEEDED"]), multiple=True, help="""This operation asynchronously creates, modifies or deletes a resource and uses a work request to track the progress of the operation. Specify this option to perform the action and then wait until the work request reaches a certain state. Multiple states can be specified, returning on the first state. For example, --wait-for-state SUCCEEDED --wait-for-state FAILED would return on whichever lifecycle state is reached first. If timeout is reached, a return code of 2 is returned. For any other error, a return code of 1 is returned.""")
@cli_util.option('--max-wait-seconds', type=click.INT, help="""The maximum time to wait for the work request to reach the state defined by --wait-for-state. Defaults to 1200 seconds.""")
@cli_util.option('--wait-interval-seconds', type=click.INT, help="""Check every --wait-interval-seconds to see whether the work request to see if it has reached the state defined by --wait-for-state. Defaults to 30 seconds.""")
@json_skeleton_utils.get_cli_json_input_option({'scan-settings': {'module': 'vulnerability_scanning', 'class': 'ContainerScanSettings'}, 'freeform-tags': {'module': 'vulnerability_scanning', 'class': 'dict(str, string)'}, 'defined-tags': {'module': 'vulnerability_scanning', 'class': 'dict(str, dict(str, object))'}})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={'scan-settings': {'module': 'vulnerability_scanning', 'class': 'ContainerScanSettings'}, 'freeform-tags': {'module': 'vulnerability_scanning', 'class': 'dict(str, string)'}, 'defined-tags': {'module': 'vulnerability_scanning', 'class': 'dict(str, dict(str, object))'}})
@cli_util.wrap_exceptions
def update_container_scan_recipe(ctx, from_json, force, wait_for_state, max_wait_seconds, wait_interval_seconds, container_scan_recipe_id, display_name, scan_settings, freeform_tags, defined_tags, if_match):

    if isinstance(container_scan_recipe_id, six.string_types) and len(container_scan_recipe_id.strip()) == 0:
        raise click.UsageError('Parameter --container-scan-recipe-id cannot be whitespace or empty string')
    if not force:
        if scan_settings or freeform_tags or defined_tags:
            if not click.confirm("WARNING: Updates to scan-settings and freeform-tags and defined-tags will replace any existing values. Are you sure you want to continue?"):
                ctx.abort()

    kwargs = {}
    if if_match is not None:
        kwargs['if_match'] = if_match
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])

    _details = {}

    if display_name is not None:
        _details['displayName'] = display_name

    if scan_settings is not None:
        _details['scanSettings'] = cli_util.parse_json_parameter("scan_settings", scan_settings)

    if freeform_tags is not None:
        _details['freeformTags'] = cli_util.parse_json_parameter("freeform_tags", freeform_tags)

    if defined_tags is not None:
        _details['definedTags'] = cli_util.parse_json_parameter("defined_tags", defined_tags)

    client = cli_util.build_client('vulnerability_scanning', 'vulnerability_scanning', ctx)
    result = client.update_container_scan_recipe(
        container_scan_recipe_id=container_scan_recipe_id,
        update_container_scan_recipe_details=_details,
        **kwargs
    )
    if wait_for_state:

        if hasattr(client, 'get_work_request') and callable(getattr(client, 'get_work_request')):
            try:
                wait_period_kwargs = {}
                if max_wait_seconds is not None:
                    wait_period_kwargs['max_wait_seconds'] = max_wait_seconds
                if wait_interval_seconds is not None:
                    wait_period_kwargs['max_interval_seconds'] = wait_interval_seconds

                click.echo('Action completed. Waiting until the work request has entered state: {}'.format(wait_for_state), file=sys.stderr)
                result = oci.wait_until(client, client.get_work_request(result.headers['opc-work-request-id']), 'status', wait_for_state, **wait_period_kwargs)
            except oci.exceptions.MaximumWaitTimeExceeded as e:
                # If we fail, we should show an error, but we should still provide the information to the customer
                click.echo('Failed to wait until the work request entered the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                sys.exit(2)
            except Exception:
                click.echo('Encountered error while waiting for work request to enter the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                raise
        else:
            click.echo('Unable to wait for the work request to enter the specified state', file=sys.stderr)
    cli_util.render_response(result, ctx)


@container_scan_target_group.command(name=cli_util.override('vulnerability_scanning.update_container_scan_target.command_name', 'update'), help=u"""Updates the ContainerScanTarget identified by the id \n[Command Reference](updateContainerScanTarget)""")
@cli_util.option('--container-scan-target-id', required=True, help=u"""unique ContainerScanTarget identifier""")
@cli_util.option('--display-name', help=u"""User friendly name of container scan target""")
@cli_util.option('--description', help=u"""Target description.""")
@cli_util.option('--target-registry', type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--container-scan-recipe-id', help=u"""ID of the container scan recipe this target applies.""")
@cli_util.option('--freeform-tags', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{\"bar-key\": \"value\"}`""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--defined-tags', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--if-match', help=u"""For optimistic concurrency control. In the PUT or DELETE call for a resource, set the `if-match` parameter to the value of the etag from a previous GET or POST response for that resource. The resource will be updated or deleted only if the etag you provide matches the resource's current etag value.""")
@cli_util.option('--force', help="""Perform update without prompting for confirmation.""", is_flag=True)
@cli_util.option('--wait-for-state', type=custom_types.CliCaseInsensitiveChoice(["ACCEPTED", "IN_PROGRESS", "FAILED", "SUCCEEDED"]), multiple=True, help="""This operation asynchronously creates, modifies or deletes a resource and uses a work request to track the progress of the operation. Specify this option to perform the action and then wait until the work request reaches a certain state. Multiple states can be specified, returning on the first state. For example, --wait-for-state SUCCEEDED --wait-for-state FAILED would return on whichever lifecycle state is reached first. If timeout is reached, a return code of 2 is returned. For any other error, a return code of 1 is returned.""")
@cli_util.option('--max-wait-seconds', type=click.INT, help="""The maximum time to wait for the work request to reach the state defined by --wait-for-state. Defaults to 1200 seconds.""")
@cli_util.option('--wait-interval-seconds', type=click.INT, help="""Check every --wait-interval-seconds to see whether the work request to see if it has reached the state defined by --wait-for-state. Defaults to 30 seconds.""")
@json_skeleton_utils.get_cli_json_input_option({'target-registry': {'module': 'vulnerability_scanning', 'class': 'UpdateContainerScanRegistryDetails'}, 'freeform-tags': {'module': 'vulnerability_scanning', 'class': 'dict(str, string)'}, 'defined-tags': {'module': 'vulnerability_scanning', 'class': 'dict(str, dict(str, object))'}})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={'target-registry': {'module': 'vulnerability_scanning', 'class': 'UpdateContainerScanRegistryDetails'}, 'freeform-tags': {'module': 'vulnerability_scanning', 'class': 'dict(str, string)'}, 'defined-tags': {'module': 'vulnerability_scanning', 'class': 'dict(str, dict(str, object))'}})
@cli_util.wrap_exceptions
def update_container_scan_target(ctx, from_json, force, wait_for_state, max_wait_seconds, wait_interval_seconds, container_scan_target_id, display_name, description, target_registry, container_scan_recipe_id, freeform_tags, defined_tags, if_match):

    if isinstance(container_scan_target_id, six.string_types) and len(container_scan_target_id.strip()) == 0:
        raise click.UsageError('Parameter --container-scan-target-id cannot be whitespace or empty string')
    if not force:
        if target_registry or freeform_tags or defined_tags:
            if not click.confirm("WARNING: Updates to target-registry and freeform-tags and defined-tags will replace any existing values. Are you sure you want to continue?"):
                ctx.abort()

    kwargs = {}
    if if_match is not None:
        kwargs['if_match'] = if_match
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])

    _details = {}

    if display_name is not None:
        _details['displayName'] = display_name

    if description is not None:
        _details['description'] = description

    if target_registry is not None:
        _details['targetRegistry'] = cli_util.parse_json_parameter("target_registry", target_registry)

    if container_scan_recipe_id is not None:
        _details['containerScanRecipeId'] = container_scan_recipe_id

    if freeform_tags is not None:
        _details['freeformTags'] = cli_util.parse_json_parameter("freeform_tags", freeform_tags)

    if defined_tags is not None:
        _details['definedTags'] = cli_util.parse_json_parameter("defined_tags", defined_tags)

    client = cli_util.build_client('vulnerability_scanning', 'vulnerability_scanning', ctx)
    result = client.update_container_scan_target(
        container_scan_target_id=container_scan_target_id,
        update_container_scan_target_details=_details,
        **kwargs
    )
    if wait_for_state:

        if hasattr(client, 'get_work_request') and callable(getattr(client, 'get_work_request')):
            try:
                wait_period_kwargs = {}
                if max_wait_seconds is not None:
                    wait_period_kwargs['max_wait_seconds'] = max_wait_seconds
                if wait_interval_seconds is not None:
                    wait_period_kwargs['max_interval_seconds'] = wait_interval_seconds

                click.echo('Action completed. Waiting until the work request has entered state: {}'.format(wait_for_state), file=sys.stderr)
                result = oci.wait_until(client, client.get_work_request(result.headers['opc-work-request-id']), 'status', wait_for_state, **wait_period_kwargs)
            except oci.exceptions.MaximumWaitTimeExceeded as e:
                # If we fail, we should show an error, but we should still provide the information to the customer
                click.echo('Failed to wait until the work request entered the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                sys.exit(2)
            except Exception:
                click.echo('Encountered error while waiting for work request to enter the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                raise
        else:
            click.echo('Unable to wait for the work request to enter the specified state', file=sys.stderr)
    cli_util.render_response(result, ctx)


@container_scan_target_group.command(name=cli_util.override('vulnerability_scanning.update_container_scan_target_update_ocir_container_scan_registry_details.command_name', 'update-container-scan-target-update-ocir-container-scan-registry-details'), help=u"""Updates the ContainerScanTarget identified by the id \n[Command Reference](updateContainerScanTarget)""")
@cli_util.option('--container-scan-target-id', required=True, help=u"""unique ContainerScanTarget identifier""")
@cli_util.option('--display-name', help=u"""User friendly name of container scan target""")
@cli_util.option('--description', help=u"""Target description.""")
@cli_util.option('--container-scan-recipe-id', help=u"""ID of the container scan recipe this target applies.""")
@cli_util.option('--freeform-tags', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{\"bar-key\": \"value\"}`""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--defined-tags', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--if-match', help=u"""For optimistic concurrency control. In the PUT or DELETE call for a resource, set the `if-match` parameter to the value of the etag from a previous GET or POST response for that resource. The resource will be updated or deleted only if the etag you provide matches the resource's current etag value.""")
@cli_util.option('--target-registry-url', help=u"""URL of the registry. Required for non-OCIR registry types (for OCIR registry types, it can be inferred from the tenancy). If null, will not be updated.""")
@cli_util.option('--target-registry-compartment-id', help=u"""The [OCID] of the compartment to perform the scans in. All listed repositories must be in the compartment.""")
@cli_util.option('--target-registry-repositories', type=custom_types.CLI_COMPLEX_TYPE, help=u"""List of repositories to scan images in. If left empty, the target defaults to scanning all repos in the compartmentId""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--force', help="""Perform update without prompting for confirmation.""", is_flag=True)
@cli_util.option('--wait-for-state', type=custom_types.CliCaseInsensitiveChoice(["ACCEPTED", "IN_PROGRESS", "FAILED", "SUCCEEDED"]), multiple=True, help="""This operation asynchronously creates, modifies or deletes a resource and uses a work request to track the progress of the operation. Specify this option to perform the action and then wait until the work request reaches a certain state. Multiple states can be specified, returning on the first state. For example, --wait-for-state SUCCEEDED --wait-for-state FAILED would return on whichever lifecycle state is reached first. If timeout is reached, a return code of 2 is returned. For any other error, a return code of 1 is returned.""")
@cli_util.option('--max-wait-seconds', type=click.INT, help="""The maximum time to wait for the work request to reach the state defined by --wait-for-state. Defaults to 1200 seconds.""")
@cli_util.option('--wait-interval-seconds', type=click.INT, help="""Check every --wait-interval-seconds to see whether the work request to see if it has reached the state defined by --wait-for-state. Defaults to 30 seconds.""")
@json_skeleton_utils.get_cli_json_input_option({'freeform-tags': {'module': 'vulnerability_scanning', 'class': 'dict(str, string)'}, 'defined-tags': {'module': 'vulnerability_scanning', 'class': 'dict(str, dict(str, object))'}, 'target-registry-repositories': {'module': 'vulnerability_scanning', 'class': 'list[string]'}})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={'freeform-tags': {'module': 'vulnerability_scanning', 'class': 'dict(str, string)'}, 'defined-tags': {'module': 'vulnerability_scanning', 'class': 'dict(str, dict(str, object))'}, 'target-registry-repositories': {'module': 'vulnerability_scanning', 'class': 'list[string]'}})
@cli_util.wrap_exceptions
def update_container_scan_target_update_ocir_container_scan_registry_details(ctx, from_json, force, wait_for_state, max_wait_seconds, wait_interval_seconds, container_scan_target_id, display_name, description, container_scan_recipe_id, freeform_tags, defined_tags, if_match, target_registry_url, target_registry_compartment_id, target_registry_repositories):

    if isinstance(container_scan_target_id, six.string_types) and len(container_scan_target_id.strip()) == 0:
        raise click.UsageError('Parameter --container-scan-target-id cannot be whitespace or empty string')
    if not force:
        if freeform_tags or defined_tags:
            if not click.confirm("WARNING: Updates to freeform-tags and defined-tags will replace any existing values. Are you sure you want to continue?"):
                ctx.abort()

    kwargs = {}
    if if_match is not None:
        kwargs['if_match'] = if_match
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])

    _details = {}
    _details['targetRegistry'] = {}

    if display_name is not None:
        _details['displayName'] = display_name

    if description is not None:
        _details['description'] = description

    if container_scan_recipe_id is not None:
        _details['containerScanRecipeId'] = container_scan_recipe_id

    if freeform_tags is not None:
        _details['freeformTags'] = cli_util.parse_json_parameter("freeform_tags", freeform_tags)

    if defined_tags is not None:
        _details['definedTags'] = cli_util.parse_json_parameter("defined_tags", defined_tags)

    if target_registry_url is not None:
        _details['targetRegistry']['url'] = target_registry_url

    if target_registry_compartment_id is not None:
        _details['targetRegistry']['compartmentId'] = target_registry_compartment_id

    if target_registry_repositories is not None:
        _details['targetRegistry']['repositories'] = cli_util.parse_json_parameter("target_registry_repositories", target_registry_repositories)

    _details['targetRegistry']['type'] = 'OCIR'

    client = cli_util.build_client('vulnerability_scanning', 'vulnerability_scanning', ctx)
    result = client.update_container_scan_target(
        container_scan_target_id=container_scan_target_id,
        update_container_scan_target_details=_details,
        **kwargs
    )
    if wait_for_state:

        if hasattr(client, 'get_work_request') and callable(getattr(client, 'get_work_request')):
            try:
                wait_period_kwargs = {}
                if max_wait_seconds is not None:
                    wait_period_kwargs['max_wait_seconds'] = max_wait_seconds
                if wait_interval_seconds is not None:
                    wait_period_kwargs['max_interval_seconds'] = wait_interval_seconds

                click.echo('Action completed. Waiting until the work request has entered state: {}'.format(wait_for_state), file=sys.stderr)
                result = oci.wait_until(client, client.get_work_request(result.headers['opc-work-request-id']), 'status', wait_for_state, **wait_period_kwargs)
            except oci.exceptions.MaximumWaitTimeExceeded as e:
                # If we fail, we should show an error, but we should still provide the information to the customer
                click.echo('Failed to wait until the work request entered the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                sys.exit(2)
            except Exception:
                click.echo('Encountered error while waiting for work request to enter the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                raise
        else:
            click.echo('Unable to wait for the work request to enter the specified state', file=sys.stderr)
    cli_util.render_response(result, ctx)


@host_scan_recipe_group.command(name=cli_util.override('vulnerability_scanning.update_host_scan_recipe.command_name', 'update'), help=u"""Updates the HostScanRecipe identified by the recipe ID. A recipe determines the types of security issues that you want scanned, and how often to scan. \n[Command Reference](updateHostScanRecipe)""")
@cli_util.option('--host-scan-recipe-id', required=True, help=u"""unique HostScanRecipe identifier""")
@cli_util.option('--display-name', help=u"""Recipe identifier, which can be renamed. Avoid entering confidential information.""")
@cli_util.option('--port-settings', type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--agent-settings', type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--schedule', type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--freeform-tags', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{\"bar-key\": \"value\"}`""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--defined-tags', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--if-match', help=u"""For optimistic concurrency control. In the PUT or DELETE call for a resource, set the `if-match` parameter to the value of the etag from a previous GET or POST response for that resource. The resource will be updated or deleted only if the etag you provide matches the resource's current etag value.""")
@cli_util.option('--force', help="""Perform update without prompting for confirmation.""", is_flag=True)
@cli_util.option('--wait-for-state', type=custom_types.CliCaseInsensitiveChoice(["ACCEPTED", "IN_PROGRESS", "FAILED", "SUCCEEDED"]), multiple=True, help="""This operation asynchronously creates, modifies or deletes a resource and uses a work request to track the progress of the operation. Specify this option to perform the action and then wait until the work request reaches a certain state. Multiple states can be specified, returning on the first state. For example, --wait-for-state SUCCEEDED --wait-for-state FAILED would return on whichever lifecycle state is reached first. If timeout is reached, a return code of 2 is returned. For any other error, a return code of 1 is returned.""")
@cli_util.option('--max-wait-seconds', type=click.INT, help="""The maximum time to wait for the work request to reach the state defined by --wait-for-state. Defaults to 1200 seconds.""")
@cli_util.option('--wait-interval-seconds', type=click.INT, help="""Check every --wait-interval-seconds to see whether the work request to see if it has reached the state defined by --wait-for-state. Defaults to 30 seconds.""")
@json_skeleton_utils.get_cli_json_input_option({'port-settings': {'module': 'vulnerability_scanning', 'class': 'HostScanPortSettings'}, 'agent-settings': {'module': 'vulnerability_scanning', 'class': 'HostScanAgentSettings'}, 'schedule': {'module': 'vulnerability_scanning', 'class': 'Schedule'}, 'freeform-tags': {'module': 'vulnerability_scanning', 'class': 'dict(str, string)'}, 'defined-tags': {'module': 'vulnerability_scanning', 'class': 'dict(str, dict(str, object))'}})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={'port-settings': {'module': 'vulnerability_scanning', 'class': 'HostScanPortSettings'}, 'agent-settings': {'module': 'vulnerability_scanning', 'class': 'HostScanAgentSettings'}, 'schedule': {'module': 'vulnerability_scanning', 'class': 'Schedule'}, 'freeform-tags': {'module': 'vulnerability_scanning', 'class': 'dict(str, string)'}, 'defined-tags': {'module': 'vulnerability_scanning', 'class': 'dict(str, dict(str, object))'}})
@cli_util.wrap_exceptions
def update_host_scan_recipe(ctx, from_json, force, wait_for_state, max_wait_seconds, wait_interval_seconds, host_scan_recipe_id, display_name, port_settings, agent_settings, schedule, freeform_tags, defined_tags, if_match):

    if isinstance(host_scan_recipe_id, six.string_types) and len(host_scan_recipe_id.strip()) == 0:
        raise click.UsageError('Parameter --host-scan-recipe-id cannot be whitespace or empty string')
    if not force:
        if port_settings or agent_settings or schedule or freeform_tags or defined_tags:
            if not click.confirm("WARNING: Updates to port-settings and agent-settings and schedule and freeform-tags and defined-tags will replace any existing values. Are you sure you want to continue?"):
                ctx.abort()

    kwargs = {}
    if if_match is not None:
        kwargs['if_match'] = if_match
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])

    _details = {}

    if display_name is not None:
        _details['displayName'] = display_name

    if port_settings is not None:
        _details['portSettings'] = cli_util.parse_json_parameter("port_settings", port_settings)

    if agent_settings is not None:
        _details['agentSettings'] = cli_util.parse_json_parameter("agent_settings", agent_settings)

    if schedule is not None:
        _details['schedule'] = cli_util.parse_json_parameter("schedule", schedule)

    if freeform_tags is not None:
        _details['freeformTags'] = cli_util.parse_json_parameter("freeform_tags", freeform_tags)

    if defined_tags is not None:
        _details['definedTags'] = cli_util.parse_json_parameter("defined_tags", defined_tags)

    client = cli_util.build_client('vulnerability_scanning', 'vulnerability_scanning', ctx)
    result = client.update_host_scan_recipe(
        host_scan_recipe_id=host_scan_recipe_id,
        update_host_scan_recipe_details=_details,
        **kwargs
    )
    if wait_for_state:

        if hasattr(client, 'get_work_request') and callable(getattr(client, 'get_work_request')):
            try:
                wait_period_kwargs = {}
                if max_wait_seconds is not None:
                    wait_period_kwargs['max_wait_seconds'] = max_wait_seconds
                if wait_interval_seconds is not None:
                    wait_period_kwargs['max_interval_seconds'] = wait_interval_seconds

                click.echo('Action completed. Waiting until the work request has entered state: {}'.format(wait_for_state), file=sys.stderr)
                result = oci.wait_until(client, client.get_work_request(result.headers['opc-work-request-id']), 'status', wait_for_state, **wait_period_kwargs)
            except oci.exceptions.MaximumWaitTimeExceeded as e:
                # If we fail, we should show an error, but we should still provide the information to the customer
                click.echo('Failed to wait until the work request entered the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                sys.exit(2)
            except Exception:
                click.echo('Encountered error while waiting for work request to enter the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                raise
        else:
            click.echo('Unable to wait for the work request to enter the specified state', file=sys.stderr)
    cli_util.render_response(result, ctx)


@host_scan_target_group.command(name=cli_util.override('vulnerability_scanning.update_host_scan_target.command_name', 'update'), help=u"""Updates the HostScanTarget identified by the target ID. A host scan target is a collection of compute instances that you want routinely scanned for security vulnerabilities. \n[Command Reference](updateHostScanTarget)""")
@cli_util.option('--host-scan-target-id', required=True, help=u"""unique HostScanTarget identifier""")
@cli_util.option('--display-name', help=u"""Target identifier, which can be renamed. Avoid entering confidential information.""")
@cli_util.option('--description', help=u"""Target description.""")
@cli_util.option('--target-compartment-id', help=u"""Compartment ID to target. If a list of hosts is provided, all hosts must be in this compartment.""")
@cli_util.option('--instance-ids', type=custom_types.CLI_COMPLEX_TYPE, help=u"""List of compute instance IDs to target (optional). If empty, targets the entire targetCompartmentId.""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--host-scan-recipe-id', help=u"""ID of the host scan recipe this target applies.""")
@cli_util.option('--freeform-tags', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{\"bar-key\": \"value\"}`""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--defined-tags', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--if-match', help=u"""For optimistic concurrency control. In the PUT or DELETE call for a resource, set the `if-match` parameter to the value of the etag from a previous GET or POST response for that resource. The resource will be updated or deleted only if the etag you provide matches the resource's current etag value.""")
@cli_util.option('--force', help="""Perform update without prompting for confirmation.""", is_flag=True)
@cli_util.option('--wait-for-state', type=custom_types.CliCaseInsensitiveChoice(["ACCEPTED", "IN_PROGRESS", "FAILED", "SUCCEEDED"]), multiple=True, help="""This operation asynchronously creates, modifies or deletes a resource and uses a work request to track the progress of the operation. Specify this option to perform the action and then wait until the work request reaches a certain state. Multiple states can be specified, returning on the first state. For example, --wait-for-state SUCCEEDED --wait-for-state FAILED would return on whichever lifecycle state is reached first. If timeout is reached, a return code of 2 is returned. For any other error, a return code of 1 is returned.""")
@cli_util.option('--max-wait-seconds', type=click.INT, help="""The maximum time to wait for the work request to reach the state defined by --wait-for-state. Defaults to 1200 seconds.""")
@cli_util.option('--wait-interval-seconds', type=click.INT, help="""Check every --wait-interval-seconds to see whether the work request to see if it has reached the state defined by --wait-for-state. Defaults to 30 seconds.""")
@json_skeleton_utils.get_cli_json_input_option({'instance-ids': {'module': 'vulnerability_scanning', 'class': 'list[string]'}, 'freeform-tags': {'module': 'vulnerability_scanning', 'class': 'dict(str, string)'}, 'defined-tags': {'module': 'vulnerability_scanning', 'class': 'dict(str, dict(str, object))'}})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={'instance-ids': {'module': 'vulnerability_scanning', 'class': 'list[string]'}, 'freeform-tags': {'module': 'vulnerability_scanning', 'class': 'dict(str, string)'}, 'defined-tags': {'module': 'vulnerability_scanning', 'class': 'dict(str, dict(str, object))'}})
@cli_util.wrap_exceptions
def update_host_scan_target(ctx, from_json, force, wait_for_state, max_wait_seconds, wait_interval_seconds, host_scan_target_id, display_name, description, target_compartment_id, instance_ids, host_scan_recipe_id, freeform_tags, defined_tags, if_match):

    if isinstance(host_scan_target_id, six.string_types) and len(host_scan_target_id.strip()) == 0:
        raise click.UsageError('Parameter --host-scan-target-id cannot be whitespace or empty string')
    if not force:
        if instance_ids or freeform_tags or defined_tags:
            if not click.confirm("WARNING: Updates to instance-ids and freeform-tags and defined-tags will replace any existing values. Are you sure you want to continue?"):
                ctx.abort()

    kwargs = {}
    if if_match is not None:
        kwargs['if_match'] = if_match
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])

    _details = {}

    if display_name is not None:
        _details['displayName'] = display_name

    if description is not None:
        _details['description'] = description

    if target_compartment_id is not None:
        _details['targetCompartmentId'] = target_compartment_id

    if instance_ids is not None:
        _details['instanceIds'] = cli_util.parse_json_parameter("instance_ids", instance_ids)

    if host_scan_recipe_id is not None:
        _details['hostScanRecipeId'] = host_scan_recipe_id

    if freeform_tags is not None:
        _details['freeformTags'] = cli_util.parse_json_parameter("freeform_tags", freeform_tags)

    if defined_tags is not None:
        _details['definedTags'] = cli_util.parse_json_parameter("defined_tags", defined_tags)

    client = cli_util.build_client('vulnerability_scanning', 'vulnerability_scanning', ctx)
    result = client.update_host_scan_target(
        host_scan_target_id=host_scan_target_id,
        update_host_scan_target_details=_details,
        **kwargs
    )
    if wait_for_state:

        if hasattr(client, 'get_work_request') and callable(getattr(client, 'get_work_request')):
            try:
                wait_period_kwargs = {}
                if max_wait_seconds is not None:
                    wait_period_kwargs['max_wait_seconds'] = max_wait_seconds
                if wait_interval_seconds is not None:
                    wait_period_kwargs['max_interval_seconds'] = wait_interval_seconds

                click.echo('Action completed. Waiting until the work request has entered state: {}'.format(wait_for_state), file=sys.stderr)
                result = oci.wait_until(client, client.get_work_request(result.headers['opc-work-request-id']), 'status', wait_for_state, **wait_period_kwargs)
            except oci.exceptions.MaximumWaitTimeExceeded as e:
                # If we fail, we should show an error, but we should still provide the information to the customer
                click.echo('Failed to wait until the work request entered the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                sys.exit(2)
            except Exception:
                click.echo('Encountered error while waiting for work request to enter the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                raise
        else:
            click.echo('Unable to wait for the work request to enter the specified state', file=sys.stderr)
    cli_util.render_response(result, ctx)
