"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.WordPress = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const ec2 = require("@aws-cdk/aws-ec2");
const ecs = require("@aws-cdk/aws-ecs");
const ecsPatterns = require("@aws-cdk/aws-ecs-patterns");
const efs = require("@aws-cdk/aws-efs");
const rds = require("@aws-cdk/aws-rds");
const cdk = require("@aws-cdk/core");
/**
 * @stability stable
 */
class WordPress extends cdk.Construct {
    /**
     * @stability stable
     */
    constructor(scope, id, props = {}) {
        var _b, _c, _d, _e;
        super(scope, id);
        const vpc = (_b = props.vpc) !== null && _b !== void 0 ? _b : new ec2.Vpc(this, 'Vpc', { maxAzs: 3, natGateways: 1 });
        const rdsInstance = (_c = props.rdsInstance) !== null && _c !== void 0 ? _c : new rds.DatabaseInstance(this, 'Database', {
            engine: rds.DatabaseInstanceEngine.mysql({
                version: rds.MysqlEngineVersion.VER_8_0_21,
            }),
            vpc,
            deleteAutomatedBackups: true,
            instanceType: ec2.InstanceType.of(ec2.InstanceClass.BURSTABLE3, ec2.InstanceSize.MICRO),
            allocatedStorage: 10,
        });
        const cluster = (_d = props.cluster) !== null && _d !== void 0 ? _d : new ecs.Cluster(this, 'EcsCluster', { vpc });
        const autoScalingGroup = cluster.addCapacity('ASG', {
            instanceType: ec2.InstanceType.of(ec2.InstanceClass.T3A, ec2.InstanceSize.SMALL),
            maxCapacity: 3,
            machineImage: ecs.EcsOptimizedImage.amazonLinux2(),
        });
        autoScalingGroup.scaleOnCpuUtilization('KeepCpuHalfwayLoaded', {
            targetUtilizationPercent: 50,
        });
        const loadBalancedEcsService = new ecsPatterns.ApplicationLoadBalancedEc2Service(this, 'Service', {
            cluster,
            memoryLimitMiB: 512,
            taskImageOptions: {
                image: ecs.ContainerImage.fromRegistry('wordpress'),
                environment: {
                    WORDPRESS_DB_NAME: 'wordpress',
                },
                secrets: {
                    WORDPRESS_DB_HOST: ecs.Secret.fromSecretsManager(rdsInstance.secret, 'host'),
                    WORDPRESS_DB_USER: ecs.Secret.fromSecretsManager(rdsInstance.secret, 'username'),
                    WORDPRESS_DB_PASSWORD: ecs.Secret.fromSecretsManager(rdsInstance.secret, 'password'),
                },
            },
            desiredCount: 2,
        });
        const scaling = loadBalancedEcsService.service.autoScaleTaskCount({
            maxCapacity: 6,
        });
        scaling.scaleOnCpuUtilization('CpuScaling', {
            targetUtilizationPercent: 50,
        });
        loadBalancedEcsService.targetGroup.healthCheck = {
            path: '/wp-includes/images/blank.gif',
            interval: cdk.Duration.minutes(1),
        };
        rdsInstance.connections.allowFrom(loadBalancedEcsService.cluster.connections, ec2.Port.tcp(3306));
        const fileSystem = new efs.FileSystem(this, 'FileSystem', {
            vpc,
            encrypted: true,
        });
        fileSystem.connections.allowFrom(autoScalingGroup.connections.connections, ec2.Port.tcp(2049));
        const volumeName = 'efs';
        loadBalancedEcsService.taskDefinition.addVolume({
            name: volumeName,
            efsVolumeConfiguration: {
                fileSystemId: fileSystem.fileSystemId,
            },
        });
        (_e = loadBalancedEcsService.taskDefinition.defaultContainer) === null || _e === void 0 ? void 0 : _e.addMountPoints({
            containerPath: '/var/www/html',
            readOnly: false,
            sourceVolume: volumeName,
        });
        this.endpoint = `http://${loadBalancedEcsService.loadBalancer.loadBalancerDnsName}`;
    }
}
exports.WordPress = WordPress;
_a = JSII_RTTI_SYMBOL_1;
WordPress[_a] = { fqn: "cdk-wordpress.WordPress", version: "0.0.59" };
//# sourceMappingURL=data:application/json;base64,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