"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.WebappConfig = void 0;
const config_file_1 = require("../config-file");
class WebappConfig {
    constructor(props) {
        this.props = props;
        this.file = new config_file_1.ConfigFile('config.json', JSON.stringify(this.frontendConfig));
    }
    get frontendConfig() {
        var _a;
        return {
            packageLinks: this.packageLinks,
            packageTags: this.packageTags,
            featuredPackages: this.featuredPackages,
            packageStats: (_a = this.props.showPackageStats) !== null && _a !== void 0 ? _a : true,
            featureFlags: this.props.featureFlags,
            categories: this.props.categories,
        };
    }
    get packageLinks() {
        var _a;
        const packageLinks = (_a = this.props.packageLinks) !== null && _a !== void 0 ? _a : [];
        // remove allowed domains from frontend config
        return packageLinks.map(({ allowedDomains, ...rest }) => rest);
    }
    get packageTags() {
        var _a;
        const packageTags = (_a = this.props.packageTags) !== null && _a !== void 0 ? _a : [];
        // remove conditional logic from frontend config
        return packageTags.map(({ condition, ...rest }) => rest);
    }
    get featuredPackages() {
        var _a;
        const config = (_a = this.props.featuredPackages) !== null && _a !== void 0 ? _a : {
            sections: [
                {
                    name: 'Recently updated',
                    showLastUpdated: 10,
                },
            ],
        };
        for (const section of config.sections) {
            if ((section.showPackages !== undefined && section.showLastUpdated !== undefined) ||
                (section.showPackages === undefined && section.showLastUpdated === undefined)) {
                throw new Error('Exactly one of \'showPackages\' and \'showPackages\' should be provided.');
            }
        }
        return config;
    }
}
exports.WebappConfig = WebappConfig;
//# sourceMappingURL=data:application/json;base64,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